/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.aggregate;

import org.jkiss.dbeaver.model.data.aggregate.FunctionNumeric;

public class FunctionAvg
extends FunctionNumeric {
    protected double result = Double.NaN;

    @Override
    public boolean accumulate(Object value) {
        Number num = FunctionAvg.getNumeric(value);
        if (num != null) {
            if (Double.isNaN(this.result)) {
                this.result = 0.0;
            }
            this.result += num.doubleValue();
            return true;
        }
        return false;
    }

    @Override
    public Object getResult(int valueCount) {
        if (Double.isNaN(this.result)) {
            return null;
        }
        return this.result / (double)valueCount;
    }
}

