/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProjectManager;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.controls.ScriptSelectorPanel;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDataSourceDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class OpenHandler
extends AbstractDataSourceHandler {
    public static void openResource(IResource resource, IWorkbenchWindow window) {
        try {
            DBPResourceHandler handler = DBWorkbench.getPlatform().getProjectManager().getResourceHandler(resource);
            if (handler != null) {
                handler.openResource(resource);
            }
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.actions_navigator_error_dialog_open_resource_title, "Can't open resource '" + resource.getName() + "'", (Throwable)e);
        }
    }

    public static void openResourceEditor(IWorkbenchWindow workbenchWindow, SQLEditorUtils.ResourceInfo resourceInfo) {
        if (resourceInfo.getResource() != null) {
            OpenHandler.openResource(resourceInfo.getResource(), workbenchWindow);
        } else if (resourceInfo.getLocalFile() != null) {
            EditorUtils.openExternalFileEditor((File)resourceInfo.getLocalFile(), (IWorkbenchWindow)workbenchWindow);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String actionId = event.getCommand().getId();
        try {
            switch (actionId) {
                case "org.jkiss.dbeaver.core.sql.editor.open": {
                    OpenHandler.openEditor(event);
                    break;
                }
                case "org.jkiss.dbeaver.core.sql.editor.create": {
                    OpenHandler.openNewEditor(event);
                    break;
                }
                case "org.jkiss.dbeaver.core.sql.editor.recent": {
                    OpenHandler.openRecentEditor(event);
                }
            }
        }
        catch (CoreException e) {
            DBWorkbench.getPlatformUI().showError("Open editor", "Can execute command '" + actionId + "'", (Throwable)e);
        }
        return null;
    }

    private static void openEditor(ExecutionEvent event) throws ExecutionException, CoreException {
        List<DBPDataSourceContainer> containers = OpenHandler.getDataSourceContainers(event);
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IProject project = !containers.isEmpty() ? containers.get(0).getRegistry().getProject() : DBWorkbench.getPlatform().getProjectManager().getActiveProject();
        OpenHandler.checkProjectIsOpen(project);
        DBPDataSourceContainer[] containerList = containers.toArray(new DBPDataSourceContainer[containers.size()]);
        IFolder rootFolder = SQLEditorUtils.getScriptsFolder(project, true);
        List<SQLEditorUtils.ResourceInfo> scriptTree = SQLEditorUtils.findScriptTree(rootFolder, containerList.length == 0 ? null : containerList);
        if (scriptTree.isEmpty() && containerList.length == 1) {
            IFile newScript = SQLEditorUtils.createNewScript(project, rootFolder, containers.isEmpty() ? null : containers.get(0));
            OpenHandler.openResource((IResource)newScript, workbenchWindow);
        } else {
            ScriptSelectorPanel selector = new ScriptSelectorPanel(workbenchWindow, containerList, rootFolder);
            selector.showTree(scriptTree);
        }
    }

    public static void openNewEditor(IWorkbenchWindow workbenchWindow, DBPDataSourceContainer dataSourceContainer, ISelection selection) throws CoreException {
        IProject project = dataSourceContainer != null ? dataSourceContainer.getRegistry().getProject() : DBWorkbench.getPlatform().getProjectManager().getActiveProject();
        OpenHandler.checkProjectIsOpen(project);
        IFolder folder = OpenHandler.getCurrentScriptFolder(selection);
        IFile scriptFile = SQLEditorUtils.createNewScript(project, folder, dataSourceContainer);
        OpenHandler.openResource((IResource)scriptFile, workbenchWindow);
    }

    public static IFolder getCurrentScriptFolder(ISelection selection) {
        Object element;
        IFolder folder = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof DBNResource && ((DBNResource)element).getResource() instanceof IFolder) {
            folder = (IFolder)((DBNResource)element).getResource();
        }
        return folder;
    }

    private static void openNewEditor(ExecutionEvent event) throws CoreException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        try {
            DBPDataSourceContainer dataSourceContainer = OpenHandler.getCurrentConnection(event);
            OpenHandler.openNewEditor(workbenchWindow, dataSourceContainer, HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        }
        catch (InterruptedException interruptedException) {}
    }

    private static void openRecentEditor(ExecutionEvent event) throws CoreException {
        try {
            DBPDataSourceContainer dataSourceContainer = OpenHandler.getCurrentConnection(event);
            OpenHandler.openRecentScript(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), dataSourceContainer, null);
        }
        catch (InterruptedException interruptedException) {}
    }

    @Nullable
    private static DBPDataSourceContainer getCurrentConnection(ExecutionEvent event) throws InterruptedException {
        IProject project;
        DBPDataSourceContainer dataSourceContainer = OpenHandler.getDataSourceContainer((ExecutionEvent)event, (boolean)false);
        DBPProjectManager projectRegistry = DBWorkbench.getPlatform().getProjectManager();
        IProject iProject = project = dataSourceContainer != null ? dataSourceContainer.getRegistry().getProject() : projectRegistry.getActiveProject();
        if (dataSourceContainer == null) {
            DBPDataSourceRegistry dataSourceRegistry = projectRegistry.getDataSourceRegistry(project);
            if (dataSourceRegistry == null) {
                return null;
            }
            if (dataSourceRegistry.getDataSources().size() == 1) {
                dataSourceContainer = (DBPDataSourceContainer)dataSourceRegistry.getDataSources().get(0);
            } else if (!dataSourceRegistry.getDataSources().isEmpty()) {
                SelectDataSourceDialog dialog = new SelectDataSourceDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), project, null);
                if (dialog.open() == 1) {
                    throw new InterruptedException();
                }
                dataSourceContainer = dialog.getDataSource();
            }
        }
        return dataSourceContainer;
    }

    @Nullable
    private static IFolder getCurrentFolder(ExecutionEvent event) {
        HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return null;
    }

    private static List<DBPDataSourceContainer> getDataSourceContainers(ExecutionEvent event) {
        IWorkbenchPart activePart;
        DBPDataSourceContainer partContainer;
        ArrayList<DBPDataSourceContainer> containers = new ArrayList<DBPDataSourceContainer>();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof DBNLocalFolder) {
                    for (DBNDataSource ds : ((DBNLocalFolder)obj).getDataSources()) {
                        containers.add(ds.getDataSourceContainer());
                    }
                } else {
                    DBSObject selectedObject = DBUtils.getFromObject((Object)obj);
                    if (selectedObject != null) {
                        if (selectedObject instanceof DBPDataSourceContainer) {
                            containers.add((DBPDataSourceContainer)selectedObject);
                        } else {
                            containers.add(selectedObject.getDataSource().getContainer());
                        }
                    }
                }
                ++n2;
            }
        }
        if (containers.isEmpty() && (partContainer = OpenHandler.getDataSourceContainers(activePart = HandlerUtil.getActivePart((ExecutionEvent)event))) != null) {
            containers.add(partContainer);
        }
        return containers;
    }

    private static DBPDataSourceContainer getDataSourceContainers(IWorkbenchPart activePart) {
        if (activePart instanceof IDataSourceContainerProvider) {
            return ((IDataSourceContainerProvider)activePart).getDataSourceContainer();
        }
        if (activePart instanceof DBPContextProvider) {
            DBCExecutionContext context = ((DBPContextProvider)activePart).getExecutionContext();
            return context == null ? null : context.getDataSource().getContainer();
        }
        return null;
    }

    public static void openRecentScript(@NotNull IWorkbenchWindow workbenchWindow, @Nullable DBPDataSourceContainer dataSourceContainer, @Nullable IFolder scriptFolder) throws CoreException {
        IProject project = dataSourceContainer != null ? dataSourceContainer.getRegistry().getProject() : DBWorkbench.getPlatform().getProjectManager().getActiveProject();
        OpenHandler.checkProjectIsOpen(project);
        SQLEditorUtils.ResourceInfo res = SQLEditorUtils.findRecentScript(project, dataSourceContainer);
        if (res != null) {
            OpenHandler.openResourceEditor(workbenchWindow, res);
        } else {
            IFile scriptFile = SQLEditorUtils.createNewScript(project, scriptFolder, dataSourceContainer);
            OpenHandler.openResource((IResource)scriptFile, workbenchWindow);
        }
    }

    public static void checkProjectIsOpen(IProject project) throws CoreException {
        if (project == null) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)new IllegalStateException("No active project.")));
        }
        if (!project.isOpen()) {
            try {
                UIUtils.runInProgressService(monitor -> {
                    try {
                        project.open(monitor.getNestedMonitor());
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw (CoreException)e.getTargetException();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static SQLEditor openSQLConsole(IWorkbenchWindow workbenchWindow, DBPDataSourceContainer dataSourceContainer, String name, String sqlText) {
        StringEditorInput sqlInput = new StringEditorInput(name, (CharSequence)sqlText, false, "UTF-8");
        return OpenHandler.openSQLConsole(workbenchWindow, dataSourceContainer, (IEditorInput)sqlInput);
    }

    public static SQLEditor openSQLConsole(IWorkbenchWindow workbenchWindow, DBPDataSourceContainer dataSourceContainer, IEditorInput sqlInput) {
        EditorUtils.setInputDataSource((IEditorInput)sqlInput, (DBPDataSourceContainer)dataSourceContainer);
        return OpenHandler.openSQLEditor(workbenchWindow, sqlInput);
    }

    private static SQLEditor openSQLEditor(IWorkbenchWindow workbenchWindow, IEditorInput sqlInput) {
        try {
            return (SQLEditor)workbenchWindow.getActivePage().openEditor(sqlInput, SQLEditor.class.getName());
        }
        catch (PartInitException e) {
            DBWorkbench.getPlatformUI().showError("Can't open editor", null, (Throwable)e);
            return null;
        }
    }
}

