/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;

public class SQLResultsView
extends ViewPart {
    public static final String VIEW_ID = "org.jkiss.dbeaver.core.sqlResults";
    private ResultSetViewer viewer;
    private DetachedContainer detachedContainer = new DetachedContainer();

    public ResultSetViewer getViewer() {
        return this.viewer;
    }

    public void setContainer(IResultSetContainer container) {
        this.detachedContainer.currentContainer = container;
        DBSDataContainer dataContainer = container.getDataContainer();
        String partName = dataContainer == null ? "Data" : dataContainer.getName();
        this.setPartName(partName);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new ResultSetViewer(parent, this.getSite(), (IResultSetContainer)this.detachedContainer);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ResultSetViewer.class) {
            return adapter.cast(this.viewer);
        }
        return (T)this.viewer.getAdapter(adapter);
    }

    private class DetachedContainer
    implements IResultSetContainer {
        private IResultSetContainer currentContainer;

        private DetachedContainer() {
        }

        @Nullable
        public DBCExecutionContext getExecutionContext() {
            return this.currentContainer == null ? null : this.currentContainer.getExecutionContext();
        }

        @Nullable
        public IResultSetController getResultSetController() {
            return this.currentContainer == null ? null : this.currentContainer.getResultSetController();
        }

        @Nullable
        public DBSDataContainer getDataContainer() {
            return this.currentContainer == null ? null : this.currentContainer.getDataContainer();
        }

        public boolean isReadyToRun() {
            return this.currentContainer != null && this.currentContainer.isReadyToRun();
        }

        public void openNewContainer(DBRProgressMonitor monitor, DBSDataContainer dataContainer, DBDDataFilter newFilter) {
            DBWorkbench.getPlatformUI().showError("Data container", "Not supported");
        }

        public IResultSetDecorator createResultSetDecorator() {
            return new QueryResultsDecorator();
        }
    }
}

