/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.ISchemeInformation;
import org.eclipse.urischeme.IUriSchemeExtensionReader;

public class UriSchemeHandlerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Text handlerLocation;
    CheckboxTableViewer tableViewer;
    private String currentLocation = null;
    IStatusManagerWrapper statusManagerWrapper = new IStatusManagerWrapper(){};
    IMessageDialogWrapper messageDialogWrapper = new IMessageDialogWrapper(){};
    IOperatingSystemRegistration operatingSystemRegistration = null;
    IUriSchemeExtensionReader extensionReader = null;
    private Composite handlerComposite;

    public UriSchemeHandlerPreferencePage() {
        super.setDescription(IDEWorkbenchMessages.UrlHandlerPreferencePage_Page_Description);
    }

    public void init(IWorkbench workbench) {
        if (this.operatingSystemRegistration == null) {
            this.operatingSystemRegistration = IOperatingSystemRegistration.getInstance();
        }
        if (this.extensionReader == null) {
            this.extensionReader = IUriSchemeExtensionReader.newInstance();
        }
        if (this.operatingSystemRegistration != null) {
            this.currentLocation = this.operatingSystemRegistration.getEclipseLauncher();
        }
    }

    protected Control createContents(Composite parent) {
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.link_handlers_page_context");
        }
        this.noDefaultAndApplyButton();
        this.addFiller(parent, 2);
        this.createTableViewerForSchemes(parent);
        this.createHandlerLocationControls(parent);
        return parent;
    }

    private void addFiller(Composite composite, int horizontalSpan) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = horizontalSpan;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private void createTableViewerForSchemes(Composite parent) {
        Composite editorComposite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 0;
        editorComposite.setLayoutData((Object)gridData);
        Table schemeTable = new Table(editorComposite, 68388);
        schemeTable.setHeaderVisible(true);
        schemeTable.setLinesVisible(true);
        schemeTable.setFont(parent.getFont());
        TableColumnLayout tableColumnlayout = new TableColumnLayout();
        editorComposite.setLayout((Layout)tableColumnlayout);
        TableColumn nameColumn = new TableColumn(schemeTable, 0, 0);
        nameColumn.setText(IDEWorkbenchMessages.UrlHandlerPreferencePage_ColumnName_SchemeName);
        TableColumn descriptionColumn = new TableColumn(schemeTable, 0, 1);
        descriptionColumn.setText(IDEWorkbenchMessages.UrlHandlerPreferencePage_ColumnName_SchemeDescription);
        TableColumn appColumn = new TableColumn(schemeTable, 0, 2);
        appColumn.setText(IDEWorkbenchMessages.UrlHandlerPreferencePage_ColumnName_Handler);
        tableColumnlayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(20));
        tableColumnlayout.setColumnData((Widget)descriptionColumn, (ColumnLayoutData)new ColumnWeightData(60));
        tableColumnlayout.setColumnData((Widget)appColumn, (ColumnLayoutData)new ColumnWeightData(20));
        this.tableViewer = new CheckboxTableViewer(schemeTable);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
        TableSchemeSelectionListener listener = new TableSchemeSelectionListener();
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        this.tableViewer.addCheckStateListener((ICheckStateListener)listener);
        Collection<Object> schemeInformationList = Collections.emptyList();
        try {
            schemeInformationList = this.retrieveSchemeInformationList();
        }
        catch (Exception exception) {
            Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.UrlHandlerPreferencePage_Error_Reading_Scheme, (Throwable)exception);
            this.statusManagerWrapper.handle((IStatus)status, 5);
        }
        this.tableViewer.setInput(schemeInformationList);
        for (UiSchemeInformation uiSchemeInformation : schemeInformationList) {
            this.tableViewer.setChecked((Object)uiSchemeInformation, uiSchemeInformation.checked);
        }
    }

    private void createHandlerLocationControls(Composite parent) {
        this.handlerComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.handlerComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.handlerComposite);
        new Label(this.handlerComposite, 0).setText(IDEWorkbenchMessages.UrlHandlerPreferencePage_Handler_Label);
        this.handlerLocation = new Text(this.handlerComposite, 2056);
        this.handlerLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.handlerComposite.setVisible(false);
    }

    private Collection<UiSchemeInformation> retrieveSchemeInformationList() throws Exception {
        ArrayList<UiSchemeInformation> returnList = new ArrayList<UiSchemeInformation>();
        Collection schemes = this.extensionReader.getSchemes();
        if (this.operatingSystemRegistration != null) {
            for (ISchemeInformation info : this.operatingSystemRegistration.getSchemesInformation(schemes)) {
                returnList.add(new UiSchemeInformation(info.isHandled(), info));
            }
        }
        return returnList;
    }

    public boolean performOk() {
        if (this.operatingSystemRegistration == null) {
            return true;
        }
        ArrayList<ISchemeInformation> toAdd = new ArrayList<ISchemeInformation>();
        ArrayList<ISchemeInformation> toRemove = new ArrayList<ISchemeInformation>();
        for (UiSchemeInformation info : (Collection)this.tableViewer.getInput()) {
            if (info.checked && !info.information.isHandled()) {
                toAdd.add(info.information);
            }
            if (info.checked || !info.information.isHandled()) continue;
            toRemove.add(info.information);
        }
        try {
            this.operatingSystemRegistration.handleSchemes(toAdd, toRemove);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.UrlHandlerPreferencePage_Error_Writing_Scheme, (Throwable)e);
            this.statusManagerWrapper.handle((IStatus)status, 5);
        }
        return true;
    }

    private boolean schemeIsHandledByOther(ISchemeInformation info) {
        boolean handlerLocationIsSet;
        boolean schemeIsNotHandled = !info.isHandled();
        boolean bl = handlerLocationIsSet = info.getHandlerInstanceLocation() != null && !info.getHandlerInstanceLocation().isEmpty();
        return schemeIsNotHandled && handlerLocationIsSet;
    }

    static interface IMessageDialogWrapper {
        default public void openWarning(Shell shell, String title, String message) {
            MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
        }
    }

    static interface IStatusManagerWrapper {
        default public void handle(IStatus status, int style) {
            StatusManager.getManager().handle(status, style);
        }
    }

    private final class ItemLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ItemLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof UiSchemeInformation) {
                UiSchemeInformation schemeInfo = (UiSchemeInformation)element;
                switch (columnIndex) {
                    case 0: {
                        return schemeInfo.information.getName();
                    }
                    case 1: {
                        return schemeInfo.information.getDescription();
                    }
                    case 2: {
                        String text = "";
                        if (schemeInfo.checked) {
                            text = IDEWorkbenchMessages.UrlHandlerPreferencePage_Column_Handler_Text_Current_Application;
                        } else if (UriSchemeHandlerPreferencePage.this.schemeIsHandledByOther(schemeInfo.information)) {
                            text = IDEWorkbenchMessages.UrlHandlerPreferencePage_Column_Handler_Text_Other_Application;
                        }
                        return text;
                    }
                }
                throw new IllegalArgumentException("Unknown column");
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }
    }

    private class TableSchemeSelectionListener
    implements ICheckStateListener,
    ISelectionChangedListener {
        private TableSchemeSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.handleSelection();
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            this.handleCheckbox(event);
        }

        private void handleSelection() {
            Object firstElement;
            IStructuredSelection selection = UriSchemeHandlerPreferencePage.this.tableViewer.getStructuredSelection();
            Object object = firstElement = selection != null ? selection.getFirstElement() : null;
            if (firstElement != null && firstElement instanceof UiSchemeInformation) {
                this.setSchemeDetails((UiSchemeInformation)firstElement);
                UriSchemeHandlerPreferencePage.this.handlerComposite.setVisible(true);
            }
        }

        private void setSchemeDetails(UiSchemeInformation schemeInfo) {
            if (schemeInfo.checked) {
                UriSchemeHandlerPreferencePage.this.handlerLocation.setText(UriSchemeHandlerPreferencePage.this.currentLocation);
            } else if (UriSchemeHandlerPreferencePage.this.schemeIsHandledByOther(schemeInfo.information)) {
                UriSchemeHandlerPreferencePage.this.handlerLocation.setText(schemeInfo.information.getHandlerInstanceLocation());
            } else {
                UriSchemeHandlerPreferencePage.this.handlerLocation.setText(IDEWorkbenchMessages.UrlHandlerPreferencePage_Handler_Text_No_Application);
            }
        }

        private void handleCheckbox(CheckStateChangedEvent event) {
            UiSchemeInformation schemeInformation = (UiSchemeInformation)event.getElement();
            if (event.getChecked() && UriSchemeHandlerPreferencePage.this.schemeIsHandledByOther(schemeInformation.information)) {
                schemeInformation.checked = false;
                UriSchemeHandlerPreferencePage.this.tableViewer.setChecked((Object)schemeInformation, schemeInformation.checked);
                UriSchemeHandlerPreferencePage.this.messageDialogWrapper.openWarning(UriSchemeHandlerPreferencePage.this.getShell(), IDEWorkbenchMessages.UriHandlerPreferencePage_Warning_OtherApp, NLS.bind((String)IDEWorkbenchMessages.UriHandlerPreferencePage_Warning_OtherApp_Description, (Object)schemeInformation.information.getHandlerInstanceLocation(), (Object)schemeInformation.information.getName()));
                return;
            }
            schemeInformation.checked = event.getChecked();
            this.setSchemeDetails(schemeInformation);
            UriSchemeHandlerPreferencePage.this.tableViewer.update((Object)schemeInformation, null);
        }
    }

    static final class UiSchemeInformation {
        public boolean checked;
        public ISchemeInformation information;

        public UiSchemeInformation(boolean checked, ISchemeInformation information) {
            this.checked = checked;
            this.information = information;
        }
    }
}

