/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.sql.SQLException;
import java.sql.SQLXML;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.oracle.data.OracleCLOBValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleContentXML;
import org.jkiss.dbeaver.ext.oracle.data.OracleXMLWrapper;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class OracleXMLValueHandler
extends OracleCLOBValueHandler {
    public static final OracleXMLValueHandler INSTANCE = new OracleXMLValueHandler();

    @NotNull
    public String getValueContentType(@NotNull DBSTypedObject attribute) {
        return "text/xml";
    }

    protected DBDContent fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        Object object;
        try {
            object = resultSet.getObject(index);
        }
        catch (SQLException sQLException) {
            try {
                object = resultSet.getSQLXML(index);
            }
            catch (SQLException sQLException2) {
                object = null;
            }
        }
        if (object == null) {
            return new OracleContentXML(session.getDataSource(), null);
        }
        if (object.getClass().getName().equals("oracle.xdb.XMLType")) {
            return new OracleContentXML(session.getDataSource(), new OracleXMLWrapper(object));
        }
        if (object instanceof SQLXML) {
            return new OracleContentXML(session.getDataSource(), (SQLXML)object);
        }
        throw new DBCException("Unsupported object type: " + object.getClass().getName());
    }

    public DBDContent getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return new OracleContentXML(session.getDataSource(), null);
        }
        if (object instanceof OracleContentXML) {
            return copy ? (OracleContentXML)((OracleContentXML)((Object)object)).cloneValue(session.getProgressMonitor()) : (OracleContentXML)((Object)object);
        }
        return super.getValueFromObject(session, type, object, copy);
    }
}

