'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _url = require('url');

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _prStatusesView = require('../views/pr-statuses-view');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Issueish {
  constructor(data) {
    this.number = data.number;
    this.title = data.title;
    this.url = new _url.URL(data.url);
    this.authorLogin = data.author.login;
    this.authorAvatarURL = new _url.URL(data.author.avatarUrl);
    this.createdAt = (0, _moment2.default)(data.createdAt, _moment2.default.ISO_8601);
    this.headRefName = data.headRefName;
    this.headRepositoryID = data.repository.id;
    this.statusContexts = data.commits.nodes.reduce((acc, node) => {
      const status = node.commit.status;
      if (status !== null) {
        acc.push(...status.contexts);
      }
      return acc;
    }, []);
  }

  getNumber() {
    return this.number;
  }

  getTitle() {
    return this.title;
  }

  getGitHubURL() {
    return this.url.toString();
  }

  getAuthorLogin() {
    return this.authorLogin;
  }

  getAuthorAvatarURL(size = 32) {
    const u = new _url.URL(this.authorAvatarURL.toString());
    u.searchParams.set('s', size);
    return u.toString();
  }

  getCreatedAt() {
    return this.createdAt;
  }

  getHeadRefName() {
    return this.headRefName;
  }

  getHeadRepositoryID() {
    return this.headRepositoryID;
  }

  getStatusCounts() {
    return this.statusContexts.reduce((acc, context) => {
      acc[(0, _prStatusesView.category)(context.state).toLowerCase()]++;
      return acc;
    }, { pending: 0, failure: 0, success: 0 });
  }
}
exports.default = Issueish;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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