'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEndpoint = getEndpoint;
// API endpoint for a GitHub instance, either dotcom or an Enterprise installation.
class Endpoint {
  constructor(host, apiHost, apiRouteParts) {
    this.host = host;
    this.apiHost = apiHost;
    this.apiRoute = apiRouteParts.map(encodeURIComponent).join('/');
  }

  getRestURI(...parts) {
    const sep = parts.length > 0 ? '/' : '';
    return this.getRestRoot() + sep + parts.map(encodeURIComponent).join('/');
  }

  getGraphQLRoot() {
    return this.getRestURI('graphql');
  }

  getRestRoot() {
    const sep = this.apiRoute !== '' ? '/' : '';
    return `https://${this.apiHost}${sep}${this.apiRoute}`;
  }

  getHost() {
    return this.host;
  }

  getLoginAccount() {
    return `https://${this.apiHost}`;
  }
}

// API endpoint for GitHub.com
const dotcomEndpoint = new Endpoint('github.com', 'api.github.com', []);

function getEndpoint(host) {
  if (host === 'github.com') {
    return dotcomEndpoint;
  } else {
    return new Endpoint(host, host, ['api', 'v3']);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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