'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _atomTextEditor = require('./atom-text-editor');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const gutterProps = {
  name: _propTypes2.default.string.isRequired,
  priority: _propTypes2.default.number.isRequired,
  visible: _propTypes2.default.bool,
  type: _propTypes2.default.oneOf(['line-number', 'decorated']),
  labelFn: _propTypes2.default.func,
  onMouseDown: _propTypes2.default.func,
  onMouseMove: _propTypes2.default.func
};

class BareGutter extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'observeEditor', 'forceUpdate');

    this.state = {
      gutter: null
    };

    this.sub = new _eventKit.Disposable();
  }

  componentDidMount() {
    this.sub = this.props.editorHolder.observe(this.observeEditor);
  }

  componentDidUpdate(prevProps) {
    if (this.props.editorHolder !== prevProps.editorHolder) {
      this.sub.dispose();
      this.sub = this.props.editorHolder.observe(this.observeEditor);
    }
  }

  componentWillUnmount() {
    if (this.state.gutter !== null) {
      try {
        this.state.gutter.destroy();
      } catch (e) {
        // Gutter already destroyed. Disregard.
      }
    }
    this.sub.dispose();
  }

  render() {
    return null;
  }

  observeEditor(editor) {
    this.setState((prevState, props) => {
      if (prevState.gutter !== null) {
        prevState.gutter.destroy();
      }

      const options = (0, _helpers.extractProps)(props, gutterProps);
      options.class = props.className;
      return { gutter: editor.addGutter(options) };
    });
  }
}

BareGutter.propTypes = _extends({
  editorHolder: _propTypes3.RefHolderPropType.isRequired,
  className: _propTypes2.default.string
}, gutterProps);
BareGutter.defaultProps = {
  visible: true,
  type: 'decorated',
  labelFn: () => {}
};
class Gutter extends _react2.default.Component {

  constructor(props) {
    super(props);
    this.state = {
      editorHolder: _refHolder2.default.on(this.props.editor)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const editorChanged = state.editorHolder.map(editor => editor !== props.editor).getOr(props.editor !== undefined);
    return editorChanged ? _refHolder2.default.on(props.editor) : null;
  }

  render() {
    if (!this.state.editorHolder.isEmpty()) {
      return _react2.default.createElement(BareGutter, _extends({}, this.props, { editorHolder: this.state.editorHolder }));
    }

    return _react2.default.createElement(
      _atomTextEditor.TextEditorContext.Consumer,
      null,
      editorHolder => _react2.default.createElement(BareGutter, _extends({}, this.props, { editorHolder: editorHolder }))
    );
  }
}
exports.default = Gutter;
Gutter.propTypes = {
  editor: _propTypes2.default.object
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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