/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.options;

import java.util.prefs.Preferences;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.openide.util.NbPreferences;

public final class TracerOptions {
    private static final String PROP_PROBES_APP = "TracerOptions.probesApp";
    public static final int KEY_PROBES_FIRSTEXP = 0;
    public static final int KEY_PROBES_ALLEXP = 1;
    public static final int KEY_PROBES_ALLCOLL = 2;
    private static final int PROBES_APP_DEFAULT = 0;
    private static final String PROP_REFRESH_RATE = "TracerOptions.refreshRate";
    private static final String PROP_REFRESH_CUSTOMIZABLE = "TracerOptions.refreshCustomizable";
    private static final String PROP_SHOW_VALUES = "TracerOptions.showValues";
    private static final String PROP_SHOW_LEGEND = "TracerOptions.showLegend";
    private static final String PROP_ROWS_DECORATION = "TracerOptions.rowsDecoration";
    private static final String PROP_ROWS_SELECTION = "TracerOptions.rowsSelection";
    private static final String PROP_INITIALLY_OPEN = "TracerOptions.initiallyOpen";
    private static final String PROP_PROBE_ADDED = "TracerOptions.probeAdded";
    private static final String PROP_PROBE_ADDED2 = "TracerOptions.probeAdded2";
    private static final String PROP_SESSION_STARTED = "TracerOptions.sessionStarted";
    private static final String PROP_ROW_SELECTED = "TracerOptions.rowSelected";
    private static final String PROP_ROW_SELECTED2 = "TracerOptions.rowSelected2";
    public static final String VIEWS_UNCHANGED = "";
    public static final String VIEW_PROBES = "KEY_probes";
    public static final String VIEW_TIMELINE = "KEY_timeline";
    public static final String VIEW_SETTINGS = "KEY_settings";
    public static final String VIEW_DETAILS = "KEY_details";
    static final String INITIALLY_OPEN_DEFAULT = "KEY_probes";
    static final String PROBE_ADDED_DEFAULT = "KEY_probes,KEY_timeline";
    static final String PROBE_ADDED_DEFAULT2 = "KEY_probes";
    static final String SESSION_STARTED_DEFAULT = "KEY_timeline";
    static final String ROW_SELECTED_DEFAULT = "KEY_timeline,KEY_details";
    static final String ROW_SELECTED_DEFAULT2 = "KEY_timeline";
    private static final String PROP_CLEAR_SELECTION = "TracerOptions.clearSelection";
    private static final String PROP_ZOOM_MODE = "TracerOptions.zoomMode";
    private static final String KEY_FIXED_SCALE = "KEY_fixedScale";
    private static final String KEY_SCALE_TO_FIT = "KEY_scaleToFit";
    public static final String FIXED_SCALE = "fixed scale";
    public static final String SCALE_TO_FIT = "scale to fit";
    private static final String PROP_MOUSE_WHEEL_ACTION = "TracerOptions.mouseWheelAction";
    private static final String KEY_MOUSE_WHEEL_ZOOMS = "KEY_mouseWheelZooms";
    private static final String KEY_MOUSE_WHEEL_HSCROLLS = "KEY_mouseWheelHScrolls";
    private static final String KEY_MOUSE_WHEEL_VSCROLLS = "KEY_mouseWheelVScrolls";
    public static final String MOUSE_WHEEL_ZOOMS = "zoom";
    public static final String MOUSE_WHEEL_HSCROLLS = "horizontal scroll";
    public static final String MOUSE_WHEEL_VSCROLLS = "vertical scroll";
    private static final String PROP_TIMELINE_TOOLBAR = "TracerOptions.timelineToolbar";
    private static final String PROP_SELECTION_TOOLBAR = "TracerOptions.selectionToolbar";
    private static final String PROP_EXTRA_TOOLBAR = "TracerOptions.extraToolbar";
    public static final int SHOW_ALWAYS = 0;
    public static final int SHOW_AS_NEEDED = 1;
    public static final int SHOW_NEVER = 2;
    private static final int TIMELINE_TOOLBAR_DEFAULT = 1;
    private static final int SELECTION_TOOLBAR_DEFAULT = 1;
    private static final int EXTRA_TOOLBAR_DEFAULT = 1;
    private static TracerOptions INSTANCE;
    private final Preferences prefs = NbPreferences.forModule(TracerOptions.class);

    public static synchronized TracerOptions getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TracerOptions();
        }
        return INSTANCE;
    }

    void setProbesApp(int n) {
        this.prefs.putInt(PROP_PROBES_APP, n);
    }

    public int getProbesApp() {
        return this.prefs.getInt(PROP_PROBES_APP, 0);
    }

    void setRefresh(int n) {
        this.prefs.putInt(PROP_REFRESH_RATE, n);
    }

    int getRefresh() {
        return this.prefs.getInt(PROP_REFRESH_RATE, -1);
    }

    public int getRefreshRate() {
        int n = this.getRefresh();
        return n != -1 ? n : 1000;
    }

    void setRefreshCustomizable(boolean bl) {
        this.prefs.putBoolean(PROP_REFRESH_CUSTOMIZABLE, bl);
    }

    public boolean isRefreshCustomizable() {
        return this.prefs.getBoolean(PROP_REFRESH_CUSTOMIZABLE, false);
    }

    void setShowValuesEnabled(boolean bl) {
        this.prefs.putBoolean(PROP_SHOW_VALUES, bl);
    }

    public boolean isShowValuesEnabled() {
        return this.prefs.getBoolean(PROP_SHOW_VALUES, true);
    }

    void setShowLegendEnabled(boolean bl) {
        this.prefs.putBoolean(PROP_SHOW_LEGEND, bl);
    }

    public boolean isShowLegendEnabled() {
        return this.prefs.getBoolean(PROP_SHOW_LEGEND, true);
    }

    void setRowsDecorationEnabled(boolean bl) {
        if (Utils.forceSpeed()) {
            return;
        }
        this.prefs.putBoolean(PROP_ROWS_DECORATION, bl);
    }

    public boolean isRowsDecorationEnabled() {
        if (Utils.forceSpeed()) {
            return false;
        }
        return this.prefs.getBoolean(PROP_ROWS_DECORATION, !Utils.forceSpeed());
    }

    void setRowsSelectionEnabled(boolean bl) {
        this.prefs.putBoolean(PROP_ROWS_SELECTION, bl);
    }

    public boolean isRowsSelectionEnabled() {
        return this.prefs.getBoolean(PROP_ROWS_SELECTION, !Utils.forceSpeed());
    }

    void setInitiallyOpened(String string) {
        this.prefs.put(PROP_INITIALLY_OPEN, string);
    }

    public String getInitiallyOpened() {
        return this.prefs.get(PROP_INITIALLY_OPEN, "KEY_probes");
    }

    void setOnProbeAdded(String string) {
        this.prefs.put(PROP_PROBE_ADDED, string);
    }

    public String getOnProbeAdded() {
        return this.prefs.get(PROP_PROBE_ADDED, PROBE_ADDED_DEFAULT);
    }

    void setOnProbeAdded2(String string) {
        this.prefs.put(PROP_PROBE_ADDED2, string);
    }

    public String getOnProbeAdded2() {
        return this.prefs.get(PROP_PROBE_ADDED2, "KEY_probes");
    }

    void setOnSessionStart(String string) {
        this.prefs.put(PROP_SESSION_STARTED, string);
    }

    public String getOnSessionStart() {
        return this.prefs.get(PROP_SESSION_STARTED, "KEY_timeline");
    }

    void setOnRowSelected(String string) {
        this.prefs.put(PROP_ROW_SELECTED, string);
    }

    public String getOnRowSelected() {
        return this.prefs.get(PROP_ROW_SELECTED, ROW_SELECTED_DEFAULT);
    }

    void setOnRowSelected2(String string) {
        this.prefs.put(PROP_ROW_SELECTED2, string);
    }

    public String getOnRowSelected2() {
        return this.prefs.get(PROP_ROW_SELECTED2, "KEY_timeline");
    }

    void setZoomMode(String string) {
        if (SCALE_TO_FIT.equals(string)) {
            this.prefs.put(PROP_ZOOM_MODE, KEY_SCALE_TO_FIT);
        } else {
            this.prefs.put(PROP_ZOOM_MODE, KEY_FIXED_SCALE);
        }
    }

    public String getZoomMode() {
        String string = this.prefs.get(PROP_ZOOM_MODE, KEY_FIXED_SCALE);
        if (KEY_SCALE_TO_FIT.equals(string)) {
            return SCALE_TO_FIT;
        }
        return FIXED_SCALE;
    }

    void setMouseWheelAction(String string) {
        if (MOUSE_WHEEL_HSCROLLS.equals(string)) {
            this.prefs.put(PROP_MOUSE_WHEEL_ACTION, KEY_MOUSE_WHEEL_HSCROLLS);
        } else if (MOUSE_WHEEL_VSCROLLS.equals(string)) {
            this.prefs.put(PROP_MOUSE_WHEEL_ACTION, KEY_MOUSE_WHEEL_VSCROLLS);
        } else {
            this.prefs.put(PROP_MOUSE_WHEEL_ACTION, KEY_MOUSE_WHEEL_ZOOMS);
        }
    }

    public String getMouseWheelAction() {
        String string = this.prefs.get(PROP_MOUSE_WHEEL_ACTION, KEY_MOUSE_WHEEL_ZOOMS);
        if (KEY_MOUSE_WHEEL_HSCROLLS.equals(string)) {
            return MOUSE_WHEEL_HSCROLLS;
        }
        if (KEY_MOUSE_WHEEL_VSCROLLS.equals(string)) {
            return MOUSE_WHEEL_VSCROLLS;
        }
        return MOUSE_WHEEL_ZOOMS;
    }

    void setTimelineToolbar(int n) {
        this.prefs.putInt(PROP_TIMELINE_TOOLBAR, n);
    }

    public int getTimelineToolbar() {
        return this.prefs.getInt(PROP_TIMELINE_TOOLBAR, 1);
    }

    void setSelectionToolbar(int n) {
        this.prefs.putInt(PROP_SELECTION_TOOLBAR, n);
    }

    public int getSelectionToolbar() {
        return this.prefs.getInt(PROP_SELECTION_TOOLBAR, 1);
    }

    void setExtraToolbar(int n) {
        this.prefs.putInt(PROP_EXTRA_TOOLBAR, n);
    }

    public int getExtraToolbar() {
        return this.prefs.getInt(PROP_EXTRA_TOOLBAR, 1);
    }

    void setClearSelection(boolean bl) {
        this.prefs.putBoolean(PROP_CLEAR_SELECTION, bl);
    }

    public boolean isClearSelection() {
        return this.prefs.getBoolean(PROP_CLEAR_SELECTION, true);
    }

    private TracerOptions() {
    }
}

