/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.memorylint.FieldAccess;
import org.netbeans.modules.profiler.heapwalk.memorylint.Histogram;
import org.netbeans.modules.profiler.heapwalk.memorylint.IteratingRule;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class HashMapHistogram
extends IteratingRule {
    private FieldAccess fldHMEKey;
    private FieldAccess fldHMENext;
    private FieldAccess fldHMEValue;
    private FieldAccess fldHMTable;
    private FieldAccess fldSValue;
    private Histogram<HashmapEntry> byIncomming;
    private JavaClass clsHM;
    private JavaClass clsHME;
    private JavaClass clsString;
    private Set<Instance> known = new HashSet<Instance>();

    public HashMapHistogram() {
        super(NbBundle.getMessage(HashMapHistogram.class, (String)"LBL_HMH_Name"), NbBundle.getMessage(HashMapHistogram.class, (String)"LBL_HMH_Desc"), "java.util.HashMap");
    }

    @Override
    public String getHTMLDescription() {
        return NbBundle.getMessage(HashMapHistogram.class, (String)"LBL_HMH_LongDesc");
    }

    @Override
    protected void perform(Instance instance) {
        HashmapEntry hashmapEntry = this.sizeOfHashmap(instance);
        String string = this.getContext().getRootIncommingString(instance);
        string = Utils.printClass(this.getContext(), string);
        this.byIncomming.add(string, hashmapEntry);
    }

    @Override
    protected void prepareRule(MemoryLint memoryLint) {
        Heap heap = memoryLint.getHeap();
        this.clsString = heap.getJavaClassByName("java.lang.String");
        this.clsHM = heap.getJavaClassByName("java.util.HashMap");
        this.clsHME = heap.getJavaClassByName("java.util.HashMap$Entry");
        this.fldSValue = new FieldAccess(this.clsString, "value");
        this.fldHMTable = new FieldAccess(this.clsHM, "table");
        this.fldHMEKey = new FieldAccess(this.clsHME, "key");
        this.fldHMEValue = new FieldAccess(this.clsHME, "value");
        this.fldHMENext = new FieldAccess(this.clsHME, "next");
        this.byIncomming = new Histogram();
    }

    @Override
    protected void summary() {
        this.getContext().appendResults(this.byIncomming.toString(50000));
    }

    private boolean add(Instance instance) {
        if (this.known.contains(instance)) {
            return false;
        }
        this.known.add(instance);
        return true;
    }

    private long sizeIfNewString(Instance instance) {
        if (instance == null) {
            return 0L;
        }
        if ("java.lang.String".equals(instance.getJavaClass().getName()) && this.add(instance)) {
            long l = instance.getSize();
            Instance instance2 = this.fldSValue.getRefValue(instance);
            if (instance2 != null && this.add(instance2)) {
                l += instance2.getSize();
            }
            return l;
        }
        return 0L;
    }

    private HashmapEntry sizeOfHashmap(Instance instance) {
        ObjectArrayInstance objectArrayInstance = (ObjectArrayInstance)this.fldHMTable.getRefValue(instance);
        long l = instance.getSize() + objectArrayInstance.getSize();
        int n = 0;
        int n2 = 0;
        List list = objectArrayInstance.getValues();
        for (Instance instance2 : list) {
            while (instance2 != null) {
                ++n;
                l += instance2.getSize();
                long l2 = this.sizeIfNewString(this.fldHMEKey.getRefValue(instance2));
                if (l2 != 0L) {
                    ++n2;
                }
                l += l2;
                l2 = this.sizeIfNewString(this.fldHMEValue.getRefValue(instance2));
                if (l2 != 0L) {
                    ++n2;
                }
                l += l2;
                instance2 = this.fldHMENext.getRefValue(instance2);
            }
        }
        HashmapEntry hashmapEntry = new HashmapEntry(l, n, n2);
        return hashmapEntry;
    }

    private static class HashmapEntry
    extends Histogram.Entry<HashmapEntry> {
        int hmeCount;
        int strCount;

        HashmapEntry(long l, int n, int n2) {
            super(l);
            this.hmeCount = n;
            this.strCount = n2;
        }

        @Override
        public String toString() {
            return "#:" + this.getCount() + "/" + this.getSize() + "B, " + this.hmeCount + " HMEs, " + this.strCount + " Strings<br>";
        }

        @Override
        protected void add(HashmapEntry hashmapEntry) {
            this.hmeCount += hashmapEntry.hmeCount;
            this.strCount += hashmapEntry.strCount;
        }
    }
}

