/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.HeaderComponent;
import org.netbeans.lib.profiler.ui.swing.ProfilerColumnModel;
import org.netbeans.lib.profiler.ui.swing.ProfilerRowSorter;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableActions;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableHovers;
import org.netbeans.lib.profiler.ui.swing.renderer.Movable;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.Lookup;

public class ProfilerTable
extends JTable {
    public static final String PROP_NO_HOVER = "ProfilerTableHover_NoHover";
    private ScrollableRenderer _renderer;
    private boolean isCustomRendering;
    private int mainColumn = 0;
    private boolean shadeUnfocusedSelection = false;
    private boolean selectionOnMiddlePress = false;
    boolean internal;
    private Object selection;
    private int fixedSelectionColumn = -1;
    private ListSelectionListener selectionListener;
    private boolean columnWidthsValid;
    private Set<Integer> scrollableColumns;
    private final boolean hideableColums;
    private boolean scrolling;
    private Action defaultAction;
    private long pressedWhen;
    private Point pressedPoint;
    private boolean providesPopupMenu;

    private static ResourceBundle BUNDLE() {
        return ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.swing.Bundle");
    }

    public ProfilerTable(TableModel tableModel, boolean bl, boolean bl2, int[] nArray) {
        super(tableModel);
        this.hideableColums = bl2;
        this.setupModels(bl);
        this.setupAppearance();
        if (nArray != null && nArray.length > 0) {
            this.initScrollableColumns(nArray);
        }
        this.tweak();
    }

    protected void setupModels(boolean bl) {
        this.setAutoCreateRowSorter(false);
        if (bl) {
            this.setRowSorter(this.createRowSorter());
        }
    }

    @Override
    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            ProfilerColumnModel profilerColumnModel = this._getColumnModel();
            while (profilerColumnModel.getColumnCount() > 0) {
                profilerColumnModel.removeColumn(profilerColumnModel.getColumn(0));
            }
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                this.addColumn(profilerColumnModel.createTableColumn(i));
            }
        }
    }

    private void tweak() {
        for (Tweaker tweaker : Lookup.getDefault().lookupAll(Tweaker.class)) {
            tweaker.tweak(this);
        }
    }

    protected void setupAppearance() {
        this.setAutoResizeMode(1);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(true);
        this.setRowMargin(0);
        this.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        if (UIUtils.isNimbusLookAndFeel() && Boolean.TRUE.equals(UIManager.getBoolean("nb.dark.theme"))) {
            this.setForeground(UIManager.getColor("text"));
        }
        ProfilerTableActions.install(this);
        ProfilerTableHovers.install(this);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilerTable.this.performDefaultAction(actionEvent);
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ProfilerTable.this.focusGained();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ProfilerTable.this.focusLost();
            }
        });
    }

    @Override
    public Color getBackground() {
        return this.isEnabled() ? super.getBackground() : UIManager.getColor("TextField.inactiveBackground");
    }

    private void focusGained() {
        this.repaint();
    }

    private void focusLost() {
        this.repaint();
    }

    public void setDefaultRenderer(Class<?> clazz, ProfilerRenderer profilerRenderer) {
        super.setDefaultRenderer(clazz, ProfilerTable.createTableCellRenderer(profilerRenderer));
    }

    public void setColumnRenderer(int n, ProfilerRenderer profilerRenderer) {
        int n2 = this.convertColumnIndexToModel(n);
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        tableColumn.setCellRenderer(ProfilerTable.createTableCellRenderer(profilerRenderer));
    }

    public static TableCellRenderer createTableCellRenderer(ProfilerRenderer profilerRenderer) {
        return new ProfilerRendererWrapper(profilerRenderer);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        int n3;
        boolean bl;
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        boolean bl2 = component.isEnabled();
        if (!bl2) {
            component.setForeground(UIManager.getColor("TextField.inactiveForeground"));
        }
        if ((bl = this.isCellSelected(n, n2)) && this.isEnabled()) {
            int n4 = n3 = !this.shadeUnfocusedSelection || super.isFocusOwner() ? 1 : 0;
            if (bl2) {
                component.setForeground(n3 != 0 ? this.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
            }
            component.setBackground(n3 != 0 ? this.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
        } else if (!this.isEnabled()) {
            if (bl2) {
                component.setForeground(UIManager.getColor("TextField.inactiveForeground"));
            }
            component.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        } else {
            if (bl2) {
                component.setForeground(this.getForeground());
            }
            component.setBackground(this.background(n, n2));
        }
        component.move(0, 0);
        n3 = this.convertColumnIndexToModel(n2);
        if (!this.isCustomRendering() && this.isScrollableColumn(n3)) {
            int n5 = this.getColumnPreferredWidth(n3);
            return this.getScrollableRenderer(component, n3, n5);
        }
        return component;
    }

    private Color background(int n, int n2) {
        Color color;
        Color color2 = color = (n & 1) == 0 ? this.getBackground() : UIUtils.getDarker(this.getBackground());
        if (this.convertColumnIndexToModel(n2) == this.getSortColumn() && !SortOrder.UNSORTED.equals((Object)this._getRowSorter().getSortOrder())) {
            int n3 = color.getRed() - 4;
            int n4 = color.getGreen() - 4;
            int n5 = color.getBlue() + 6;
            color = UIUtils.getSafeColor(n3, n4, n5);
        }
        return color;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        component.setForeground(this.getSelectionForeground());
        component.setBackground(this.getSelectionBackground());
        return component;
    }

    private ScrollableRenderer getScrollableRenderer(Component component, int n, int n2) {
        if (this._renderer == null) {
            this._renderer = new ScrollableRenderer();
        }
        this._renderer.setRenderer(component, this.getColumnOffset(n), n2);
        return this._renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Component getRenderer(TableCellRenderer tableCellRenderer, int n, int n2, boolean bl) {
        this.isCustomRendering = true;
        try {
            Object object;
            Component component = this.prepareRenderer(tableCellRenderer, n, n2);
            if (bl) {
                component.setSize(component.getPreferredSize().width, this.getRowHeight());
                if (!ProfilerTable.isLeadingAlign(component)) {
                    object = this.getColumnModel();
                    int n3 = -component.getWidth();
                    int n4 = object.getColumn(n2).getWidth();
                    int n5 = this.convertColumnIndexToModel(n2);
                    n3 = this.isScrollableColumn(n5) ? (n3 += Math.max(n4, this.getColumnPreferredWidth(n5))) : (n3 += n4);
                    component.move(n3 - object.getColumnMargin(), 0);
                }
            }
            object = component;
            return object;
        }
        finally {
            this.isCustomRendering = false;
        }
    }

    @Override
    public boolean isFocusOwner() {
        return !this.isCustomRendering() && super.isFocusOwner();
    }

    public void setVisibleRows(int n) {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        dimension.height = n * this.getRowHeight();
        this.setPreferredScrollableViewportSize(dimension);
    }

    final boolean isCustomRendering() {
        return this.isCustomRendering;
    }

    public String getStringValue(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        TableCellRenderer tableCellRenderer = this.getCellRenderer(n, n2);
        if (tableCellRenderer instanceof ProfilerRenderer) {
            ((ProfilerRenderer)((Object)tableCellRenderer)).setValue(object, this.convertRowIndexToModel(n));
        } else {
            tableCellRenderer.getTableCellRendererComponent(this, object, false, false, n, n2);
        }
        return tableCellRenderer.toString();
    }

    public String getModelStringValue(int n, int n2) {
        int n3 = this.convertColumnIndexToView(n2);
        Object object = this.getModel().getValueAt(n, n2);
        TableCellRenderer tableCellRenderer = this.getCellRenderer(n, n3);
        if (tableCellRenderer instanceof ProfilerRenderer) {
            ((ProfilerRenderer)((Object)tableCellRenderer)).setValue(object, n);
        } else {
            tableCellRenderer.getTableCellRendererComponent(this, object, false, false, this.convertRowIndexToView(n), n3);
        }
        return tableCellRenderer.toString();
    }

    public final void setMainColumn(int n) {
        this.mainColumn = n;
    }

    public final int getMainColumn() {
        return this.mainColumn;
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        ListSelectionModel listSelectionModel2 = this.getSelectionModel();
        if (listSelectionModel2 != null && this.selectionListener != null) {
            listSelectionModel2.removeListSelectionListener(this.selectionListener);
        }
        super.setSelectionModel(listSelectionModel);
        if (listSelectionModel != null) {
            if (this.selectionListener == null) {
                this.selectionListener = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        if (!ProfilerTable.this.internal) {
                            ProfilerTable.this.saveSelection();
                        }
                    }
                };
            }
            listSelectionModel.addListSelectionListener(this.selectionListener);
        }
    }

    protected void saveSelection() {
        int n = this.getSelectionModel().getSelectionMode();
        this.selection = n == 0 ? this.getSelectedValue(this.mainColumn) : this.getSelectedValues(this.mainColumn).toArray();
    }

    protected void restoreSelection() {
        try {
            this.selection = !(this.selection instanceof Object[]) ? this.selectValue(this.selection, this.mainColumn, false) : this.selectValues((Object[])this.selection, this.mainColumn, false);
        }
        catch (Exception exception) {
            System.err.println(">>> Exception in ProfilerTable.restoreSelection: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectRow(int n, boolean bl) {
        this.internal = true;
        try {
            this.setRowSelectionInterval(n, n);
            this.saveSelection();
        }
        catch (Exception exception) {
            System.err.println(">>> Exception in ProfilerTable.selectRow: " + exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            this.internal = false;
        }
        if (bl) {
            this.scrollRectToVisible(this.getCellRect(n, this.getSelectedColumn(), true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectColumn(int n, boolean bl) {
        this.internal = true;
        try {
            this.setColumnSelectionInterval(n, n);
        }
        catch (Exception exception) {
            System.err.println(">>> Exception in ProfilerTable.selectColumn: " + exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            this.internal = false;
        }
        if (bl) {
            this.scrollRectToVisible(this.getCellRect(this.getSelectedRow(), n, true));
        }
    }

    public void setFixedColumnSelection(final int n) {
        if (this.fixedSelectionColumn == n) {
            return;
        }
        if (n == -1) {
            this.getColumnModel().setSelectionModel(new DefaultListSelectionModel());
        } else {
            this.getColumnModel().setSelectionModel(new DefaultListSelectionModel(){

                @Override
                public void setSelectionInterval(int n4, int n2) {
                    int n3 = ProfilerTable.this.convertColumnIndexToView(n);
                    super.setSelectionInterval(n3, n3);
                }
            });
        }
        this.fixedSelectionColumn = n;
    }

    public Object selectValue(Object object, int n, boolean bl) {
        if (object == null) {
            return null;
        }
        int n2 = this.convertColumnIndexToView(n);
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object2 = this.getValueAt(i, n2);
            if (!object.equals(object2)) continue;
            this.selectRow(i, bl);
            return object2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] selectValues(Object[] objectArray, int n, boolean bl) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList(objectArray));
        ArrayList<Object> arrayList = new ArrayList<Object>(hashSet.size());
        this.internal = true;
        try {
            int n2 = this.convertColumnIndexToView(n);
            for (int i = 0; i < this.getRowCount(); ++i) {
                Object object = this.getValueAt(i, n2);
                if (!hashSet.remove(object)) continue;
                if (arrayList.isEmpty()) {
                    this.setRowSelectionInterval(i, i);
                    if (bl) {
                        this.scrollRectToVisible(this.getCellRect(i, n2, true));
                    }
                } else {
                    this.addRowSelectionInterval(i, i);
                }
                arrayList.add(object);
                if (!hashSet.isEmpty()) continue;
                break;
            }
        }
        finally {
            this.internal = false;
        }
        return arrayList.isEmpty() ? null : arrayList.toArray();
    }

    public Object getSelectedValue(int n) {
        int n2 = this.getSelectedRow();
        if (n2 == -1) {
            return null;
        }
        if (n2 >= this.getModel().getRowCount()) {
            return null;
        }
        return this.getValueAt(n2, this.convertColumnIndexToView(n));
    }

    public List getSelectedValues(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = this.convertColumnIndexToView(n);
        int n3 = this.getModel().getRowCount();
        for (int n4 : this.getSelectedRows()) {
            if (n4 >= n3) continue;
            arrayList.add(this.getValueAt(n4, n2));
        }
        return arrayList;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.internal = true;
        try {
            super.tableChanged(tableModelEvent);
        }
        finally {
            this.internal = false;
        }
        this.restoreSelection();
    }

    public final void setShadeUnfocusedSelection(boolean bl) {
        this.shadeUnfocusedSelection = bl;
    }

    public final boolean shadesUnfocusedSelection() {
        return this.shadeUnfocusedSelection;
    }

    public final void setSelectionOnMiddlePress(boolean bl) {
        this.selectionOnMiddlePress = bl;
    }

    public final boolean isSelectionOnMiddlePress() {
        return this.selectionOnMiddlePress;
    }

    int getNextRow(int n) {
        return ++n == this.getRowCount() ? 0 : n;
    }

    int getPreviousRow(int n) {
        return --n == -1 ? this.getRowCount() - 1 : n;
    }

    ProfilerColumnModel _getColumnModel() {
        return (ProfilerColumnModel)this.getColumnModel();
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new ProfilerColumnModel();
    }

    public void setFitWidthColumn(int n) {
        this._getColumnModel().setFitWidthColumn(n);
    }

    public void setDefaultColumnWidth(int n) {
        this._getColumnModel().setDefaultColumnWidth(n);
    }

    public void setDefaultColumnWidth(int n, int n2) {
        this._getColumnModel().setDefaultColumnWidth(n, n2);
    }

    public void setColumnToolTips(String[] stringArray) {
        this._getColumnModel().setColumnToolTips(stringArray);
    }

    public void setColumnVisibility(int n, boolean bl) {
        ProfilerColumnModel profilerColumnModel = this._getColumnModel();
        TableColumn tableColumn = profilerColumnModel.getColumn(this.convertColumnIndexToView(n));
        profilerColumnModel.setColumnVisibility(tableColumn, bl, this);
    }

    public boolean isColumnVisible(int n) {
        int n2 = this.convertColumnIndexToView(n);
        return this._getColumnModel().isColumnVisible(n2);
    }

    public void setColumnOffset(int n, int n2) {
        if (this._getColumnModel().setColumnOffset(n, n2)) {
            n = this.convertColumnIndexToView(n);
            Rectangle rectangle = this.getCellRect(0, n, true);
            this.repaint(rectangle.x, 0, rectangle.width, this.getHeight());
        }
    }

    public Set<Integer> getScrollableColumns() {
        return this.scrollableColumns;
    }

    public boolean isScrollableColumn(int n) {
        return this.scrollableColumns != null && this.scrollableColumns.contains(n);
    }

    public int getColumnOffset(int n) {
        return this._getColumnModel().getColumnOffset(n);
    }

    protected void updateColumnsPreferredWidth() {
        if (this.scrolling || this.scrollableColumns == null) {
            return;
        }
        ProfilerColumnModel profilerColumnModel = this._getColumnModel();
        int n = this.getRowCount();
        if (n == 0) {
            for (int n2 : this.scrollableColumns) {
                profilerColumnModel.setColumnPreferredWidth(n2, 0);
            }
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        if (rectangle.isEmpty()) {
            return;
        }
        Point point = rectangle.getLocation();
        int n3 = this.rowAtPoint(point);
        point.translate(0, rectangle.height - 1);
        int n4 = this.rowAtPoint(point);
        if (n4 == -1) {
            n4 = n - 1;
        }
        for (int n5 : this.scrollableColumns) {
            int n6 = this.convertColumnIndexToView(n5);
            int n7 = this.computeColumnPreferredWidth(n5, n6, n3, n4);
            profilerColumnModel.setColumnPreferredWidth(n5, n7);
        }
        this.columnWidthsValid = true;
    }

    public void updateColumnPreferredWidth(int n) {
        Rectangle rectangle = this.getVisibleRect();
        if (rectangle.isEmpty()) {
            return;
        }
        Point point = rectangle.getLocation();
        int n2 = this.rowAtPoint(rectangle.getLocation());
        point.translate(0, rectangle.height - 1);
        int n3 = this.rowAtPoint(point);
        int n4 = this.convertColumnIndexToView(n);
        int n5 = this.computeColumnPreferredWidth(n, n4, n2, n3);
        this._getColumnModel().setColumnPreferredWidth(n, n5);
    }

    protected int computeColumnPreferredWidth(int n, int n2, int n3, int n4) {
        int n5 = 0;
        for (int i = n3; i <= n4; ++i) {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(i, n2);
            Component component = this.getRenderer(tableCellRenderer, i, n2, false);
            n5 = Math.max(component.getPreferredSize().width, n5);
        }
        return n5;
    }

    public int getColumnPreferredWidth(int n) {
        if (!this.columnWidthsValid) {
            this.updateColumnsPreferredWidth();
        }
        return this._getColumnModel().getColumnPreferredWidth(n);
    }

    private void initScrollableColumns(int[] nArray) {
        this.scrollableColumns = new HashSet<Integer>(nArray.length);
        for (int n : nArray) {
            this.scrollableColumns.add(n);
        }
        this.columnWidthsValid = false;
        if (this.isSortable()) {
            this.getRowSorter().addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent rowSorterEvent) {
                    if (RowSorterEvent.Type.SORTED.equals((Object)rowSorterEvent.getType())) {
                        ProfilerTable.this.updateColumnsPreferredWidth();
                    }
                }
            });
        } else {
            this.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    ProfilerTable.this.updateColumnsPreferredWidth();
                }
            });
        }
    }

    boolean isLeadingAlign(int n) {
        if (this.getRowCount() == 0) {
            return true;
        }
        int n2 = this.convertColumnIndexToView(n);
        TableCellRenderer tableCellRenderer = this.getCellRenderer(0, n2);
        return ProfilerTable.isLeadingAlign(this.getRenderer(tableCellRenderer, 0, n2, false));
    }

    static boolean isLeadingAlign(Component component) {
        int n = component instanceof ProfilerRenderer ? ((ProfilerRenderer)((Object)component)).getHorizontalAlignment() : (component instanceof JLabel ? ((JLabel)component).getHorizontalAlignment() : 10);
        return n == 10 || n == 2 || n == 0;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        JScrollPane jScrollPane = this.getEnclosingScrollPane();
        if (jScrollPane != null) {
            HeaderComponent headerComponent;
            boolean bl = this.hideableColums && !UIUtils.isAquaLookAndFeel();
            ActionListener actionListener = !bl ? null : new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProfilerTable.this.chooseColumns((Component)actionEvent.getSource(), null);
                }
            };
            HeaderComponent headerComponent2 = headerComponent = !bl ? new HeaderComponent(actionListener) : new HeaderComponent(actionListener){
                private final int offsetX;
                private final Icon icon;
                {
                    this.offsetX = UIUtils.isWindowsClassicLookAndFeel() ? 0 : -1;
                    this.icon = Icons.getIcon((String)"GeneralIcons.PopupArrow");
                }

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    int n = (this.getWidth() - this.icon.getIconWidth()) / 2 + this.offsetX;
                    int n2 = (this.getHeight() - this.icon.getIconHeight()) / 2;
                    this.icon.paintIcon(this, graphics, n, n2);
                }
            };
            if (bl) {
                headerComponent.setToolTipText(ProfilerTable.BUNDLE().getString("ProfilerTable_ShowHideColumns"));
            }
            jScrollPane.setCorner("UPPER_RIGHT_CORNER", headerComponent);
            if (this.scrollableColumns != null && !this.scrollableColumns.isEmpty()) {
                jScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ProfilerTable.this.scrolling = adjustmentEvent.getValueIsAdjusting();
                        ProfilerTable.this.updateColumnsPreferredWidth();
                    }
                });
            }
        }
    }

    private JScrollPane getEnclosingScrollPane() {
        Container container = SwingUtilities.getUnwrappedParent(this);
        if (!(container instanceof JViewport)) {
            return null;
        }
        Container container2 = ((JViewport)container).getParent();
        return container2 instanceof JScrollPane ? (JScrollPane)container2 : null;
    }

    private void chooseColumns(Component component, Point point) {
        final ProfilerColumnModel profilerColumnModel = this._getColumnModel();
        ArrayList<TableColumn> arrayList = Collections.list(profilerColumnModel.getColumns());
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (final TableColumn tableColumn : arrayList) {
            jPopupMenu.add(new JCheckBoxMenuItem(tableColumn.getHeaderValue().toString(), tableColumn.getWidth() > 0){
                {
                    super(string, bl);
                    this.setEnabled(tableColumn.getModelIndex() != ProfilerTable.this.mainColumn);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    profilerColumnModel.setColumnVisibility(tableColumn, this.isSelected(), ProfilerTable.this);
                }
            });
        }
        if (point == null) {
            point = new Point(component.getSize().width - jPopupMenu.getPreferredSize().width - 1, component.getHeight() - 1);
        }
        jPopupMenu.show(component, point.x, point.y);
    }

    @Override
    public void doLayout() {
        TableColumn tableColumn;
        ProfilerColumnModel profilerColumnModel = this._getColumnModel();
        JTableHeader jTableHeader = this.getTableHeader();
        TableColumn tableColumn2 = tableColumn = jTableHeader == null ? null : jTableHeader.getResizingColumn();
        if (tableColumn != null) {
            int n = this.getWidth() - profilerColumnModel.getTotalColumnWidth();
            TableColumn tableColumn3 = profilerColumnModel.getNextVisibleColumn(tableColumn);
            if (tableColumn == tableColumn3) {
                tableColumn.setWidth(tableColumn.getWidth() + n);
            } else {
                tableColumn3.setWidth(tableColumn3.getWidth() + n);
            }
        } else {
            int n = profilerColumnModel.getFitWidthColumn();
            if (n == -1) {
                super.doLayout();
            } else {
                Enumeration<TableColumn> enumeration = profilerColumnModel.getColumns();
                TableColumn tableColumn4 = null;
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    TableColumn tableColumn5 = enumeration.nextElement();
                    if (tableColumn5.getModelIndex() == n) {
                        if (!profilerColumnModel.isColumnVisible(tableColumn5)) {
                            super.doLayout();
                            return;
                        }
                        tableColumn4 = tableColumn5;
                        continue;
                    }
                    n2 += tableColumn5.getWidth();
                }
                if (tableColumn4 != null) {
                    tableColumn4.setWidth(this.getWidth() - n2);
                }
                this.layout();
            }
        }
    }

    boolean isSortable() {
        return this.getRowSorter() != null;
    }

    ProfilerRowSorter _getRowSorter() {
        return (ProfilerRowSorter)this.getRowSorter();
    }

    protected TableRowSorter createRowSorter() {
        ProfilerRowSorter profilerRowSorter = new ProfilerRowSorter(this.getModel());
        profilerRowSorter.setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel tableModel, int n, int n2) {
                return ProfilerTable.this.getModelStringValue(n, n2);
            }
        });
        profilerRowSorter.setDefaultSortOrder(SortOrder.DESCENDING);
        profilerRowSorter.setSortColumn(0);
        return profilerRowSorter;
    }

    public void disableColumnSorting(int n) {
        ProfilerRowSorter profilerRowSorter = this._getRowSorter();
        if (profilerRowSorter == null) {
            return;
        }
        int n2 = this.convertColumnIndexToView(n);
        profilerRowSorter.setSortable(n2, false);
    }

    public void setSortColumn(int n) {
        if (this.isSortable()) {
            this._getRowSorter().setSortColumn(n);
        }
    }

    public int getSortColumn() {
        return this.isSortable() ? this._getRowSorter().getSortColumn() : -1;
    }

    public void setSecondarySortColumn(int n) {
        if (this.isSortable()) {
            this._getRowSorter().setSecondarySortColumn(n);
        }
    }

    public void setDefaultSortOrder(SortOrder sortOrder) {
        if (this.isSortable()) {
            this._getRowSorter().setDefaultSortOrder(sortOrder);
        }
    }

    public void setDefaultSortOrder(int n, SortOrder sortOrder) {
        if (this.isSortable()) {
            this._getRowSorter().setDefaultSortOrder(n, sortOrder);
        }
    }

    public void setAllowsThreeStateColumns(boolean bl) {
        this._getRowSorter().setAllowsThreeStateColumns(bl);
    }

    public boolean allowsThreeStateColumns() {
        return this._getRowSorter().allowsThreeStateColumns();
    }

    public void setFiltersMode(boolean bl) {
        this._getRowSorter().setFiltersMode(bl);
    }

    public boolean getFiltersMode() {
        return this._getRowSorter().getFiltersMode();
    }

    public void addRowFilter(RowFilter rowFilter) {
        this._getRowSorter().addRowFilter(rowFilter);
    }

    public void removeRowFilter(RowFilter rowFilter) {
        this._getRowSorter().removeRowFilter(rowFilter);
    }

    public void setRowFilter(RowFilter rowFilter) {
        this._getRowSorter().setRowFilter(rowFilter);
    }

    public RowFilter getRowFilter() {
        return this._getRowSorter().getRowFilter();
    }

    public void setDefaultAction(Action action) {
        this.defaultAction = action;
    }

    public void performDefaultAction(ActionEvent actionEvent) {
        if (this.defaultAction != null) {
            this.defaultAction.actionPerformed(null);
        }
    }

    public final void providePopupMenu(boolean bl) {
        this.providesPopupMenu = bl;
    }

    public final boolean providesPopupMenu() {
        return this.providesPopupMenu;
    }

    protected void populatePopup(JPopupMenu jPopupMenu, Object object, Object object2) {
    }

    public final JMenuItem createCopyMenuItem() {
        final int n = this.getSelectedRow();
        JMenu jMenu = new JMenu(ProfilerTable.BUNDLE().getString("ProfilerTable_CopyMenu"));
        JMenuItem jMenuItem = new JMenuItem(ProfilerTable.BUNDLE().getString("ProfilerTable_CopyRowItem")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                StringBuilder stringBuilder = new StringBuilder();
                ArrayList<TableColumn> arrayList = Collections.list(ProfilerTable.this._getColumnModel().getColumns());
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (((TableColumn)arrayList.get(i)).getWidth() <= 0) continue;
                    stringBuilder.append("\t").append(ProfilerTable.this.getStringValue(n, i));
                }
                StringSelection stringSelection = new StringSelection(stringBuilder.toString().trim());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
        };
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        String string = ProfilerTable.BUNDLE().getString("ProfilerTable_CopyColumnItem");
        ArrayList<TableColumn> arrayList = Collections.list(this._getColumnModel().getColumns());
        for (int i = 0; i < arrayList.size(); ++i) {
            final int n2 = i;
            TableColumn tableColumn = (TableColumn)arrayList.get(i);
            if (tableColumn.getWidth() <= 0) continue;
            String string2 = tableColumn.getHeaderValue().toString();
            if (string2.toLowerCase().startsWith("<html>")) {
                string2 = string2.replaceAll("<[^>]*>", "");
            }
            jMenu.add(new JMenuItem(MessageFormat.format(string, string2)){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    StringSelection stringSelection = new StringSelection(ProfilerTable.this.getStringValue(n, n2));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                }
            });
        }
        return jMenu;
    }

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    public Object getValueForRow(int n) {
        if (n == -1) {
            return null;
        }
        if (n >= this.getModel().getRowCount()) {
            return null;
        }
        return this.getValueAt(n, this.convertColumnIndexToView(this.mainColumn));
    }

    public Object getUserValueForRow(int n) {
        return this.getValueForRow(n);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        ListSelectionModel listSelectionModel;
        MouseEvent mouseEvent2 = null;
        if (mouseEvent.getID() == 501) {
            this.pressedWhen = mouseEvent.getWhen();
            this.pressedPoint = null;
        } else if (mouseEvent.getID() == 502) {
            if (mouseEvent.getWhen() - this.pressedWhen == 1L) {
                this.pressedPoint = mouseEvent.getPoint();
                super.processMouseEvent(mouseEvent);
                return;
            }
            if (mouseEvent.getPoint().equals(this.pressedPoint)) {
                this.pressedPoint = null;
                mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), 500, mouseEvent.getWhen() + 1L, mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
            this.pressedWhen = 0L;
        }
        boolean bl = this.providesPopupMenu && SwingUtilities.isRightMouseButton(mouseEvent);
        boolean bl2 = mouseEvent.getID() == 500 && SwingUtilities.isLeftMouseButton(mouseEvent);
        int n = this.rowAtPoint(mouseEvent.getPoint());
        if (bl2 && n != -1 && mouseEvent.getClickCount() > 1 && this.isCellEditable(n, this.columnAtPoint(mouseEvent.getPoint()))) {
            mouseEvent = ProfilerTable.clearClicks(mouseEvent);
        }
        if (mouseEvent.getID() == 501 && n != -1 && (bl || this.selectionOnMiddlePress && SwingUtilities.isMiddleMouseButton(mouseEvent)) && ((listSelectionModel = this.getSelectionModel()).getSelectionMode() == 0 || !listSelectionModel.isSelectedIndex(n))) {
            this.selectRow(n, true);
            this.requestFocusInWindow();
        }
        super.processMouseEvent(mouseEvent);
        if (bl && mouseEvent.getID() == 500 && n != -1) {
            listSelectionModel = this.getSelectionModel();
            if (listSelectionModel.getSelectionMode() == 0 || !listSelectionModel.isSelectedIndex(n)) {
                this.selectRow(n, true);
            }
            final MouseEvent mouseEvent3 = mouseEvent;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilerTable.this.showPopupMenu(mouseEvent3);
                }
            });
        }
        if (!mouseEvent.isConsumed() && bl2 && mouseEvent.getClickCount() == 2) {
            this.performDefaultAction(new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), "default action", mouseEvent.getWhen(), mouseEvent.getModifiers()));
        }
        if (mouseEvent2 != null) {
            this.processMouseEvent(mouseEvent2);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 525 || n == 121 && keyEvent.getModifiers() == 1) {
            keyEvent.consume();
            this.showPopupMenu(null);
        }
        super.processKeyEvent(keyEvent);
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu(){

            @Override
            public void setVisible(boolean bl) {
                if (bl) {
                    ProfilerTable.this.popupShowing();
                }
                super.setVisible(bl);
                if (!bl) {
                    ProfilerTable.this.popupHidden();
                }
            }
        };
        int n = this.getSelectedRow();
        Object object = this.getValueForRow(n);
        Object object2 = this.getUserValueForRow(n);
        this.populatePopup(jPopupMenu, object, object2);
        if (jPopupMenu.getComponentCount() > 0) {
            if (mouseEvent == null) {
                boolean bl = n == -1;
                int n2 = bl ? -1 : this.convertColumnIndexToView(this.mainColumn);
                Rectangle rectangle = bl ? this.getVisibleRect() : this.getCellRect(n, n2, false);
                Dimension dimension = jPopupMenu.getPreferredSize();
                int n3 = rectangle.x + (rectangle.width - dimension.width) / 2;
                int n4 = rectangle.y + (bl ? (rectangle.height - dimension.height) / 2 : this.getRowHeight() - 4);
                jPopupMenu.show(this, Math.max(n3, 0), Math.max(n4, 0));
            } else {
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void loadColumns(Properties properties) {
        this._getColumnModel().loadFromStorage(properties, this);
        if (this.isSortable()) {
            this._getRowSorter().loadFromStorage(properties, this);
        }
    }

    public void saveColumns(Properties properties) {
        this._getColumnModel().saveToStorage(properties, this);
        if (this.isSortable()) {
            this._getRowSorter().saveToStorage(properties, this);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.columnAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    return null;
                }
                ProfilerColumnModel profilerColumnModel = ProfilerTable.this._getColumnModel();
                TableColumn tableColumn = profilerColumnModel.getColumn(n);
                String string = profilerColumnModel.getColumnToolTip(tableColumn.getModelIndex());
                return string;
            }

            @Override
            protected void processMouseEvent(MouseEvent mouseEvent) {
                if (ProfilerTable.this.hideableColums && UIUtils.isAquaLookAndFeel() && mouseEvent.isPopupTrigger()) {
                    ProfilerTable.this.chooseColumns((Component)mouseEvent.getSource(), mouseEvent.getPoint());
                }
                super.processMouseEvent(mouseEvent.getClickCount() > 1 ? ProfilerTable.clearClicks(mouseEvent) : mouseEvent);
            }

            @Override
            public void setResizingColumn(TableColumn tableColumn) {
                ProfilerTable.this._getColumnModel().setResizingColumn(tableColumn);
                super.setResizingColumn(tableColumn);
            }
        };
    }

    protected static MouseEvent clearClicks(MouseEvent mouseEvent) {
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), 1, mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    public static interface Tweaker {
        public void tweak(ProfilerTable var1);
    }

    private class ScrollableRenderer
    extends Component {
        private Component impl;
        private Movable implM;
        private int offset;
        private int prefWidth;
        private int marginOffset;

        private ScrollableRenderer() {
        }

        void setRenderer(Component component, int n, int n2) {
            this.impl = component;
            this.offset = n;
            this.prefWidth = n2;
            this.marginOffset = ProfilerTable.isLeadingAlign(this.impl) ? 0 : ProfilerTable.this.getColumnModel().getColumnMargin();
            this.implM = component instanceof Movable ? (Movable)((Object)component) : null;
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.prefWidth > n3) {
                this.offset += this.marginOffset;
            }
            this.impl.setSize(Math.max(n3, this.prefWidth), n4);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.impl.getPreferredSize();
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.implM != null) {
                this.implM.move(-this.offset, 0);
                this.impl.paint(graphics);
            } else {
                graphics.translate(-this.offset, 0);
                this.impl.paint(graphics);
            }
        }
    }

    private static class ProfilerRendererWrapper
    implements TableCellRenderer,
    ProfilerRenderer {
        private final ProfilerRenderer renderer;

        ProfilerRendererWrapper(ProfilerRenderer profilerRenderer) {
            this.renderer = profilerRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setValue(object, n != -1 ? jTable.convertRowIndexToModel(n) : -1);
            return this.getComponent();
        }

        @Override
        public void setValue(Object object, int n) {
            this.renderer.setValue(object, n);
        }

        @Override
        public int getHorizontalAlignment() {
            return this.renderer.getHorizontalAlignment();
        }

        @Override
        public JComponent getComponent() {
            return this.renderer.getComponent();
        }

        @Override
        public void move(int n, int n2) {
            this.renderer.move(n, n2);
        }

        public String toString() {
            return this.renderer.toString();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this.renderer.getAccessibleContext();
        }
    }
}

