/* _NVRM_COPYRIGHT_BEGIN_
 *
 * Copyright 2008-2015 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 *
 * _NVRM_COPYRIGHT_END_
 */

/* Hide XAPIGEN helpers used in sdk headers from the C compiler.               */
/* See also:                                                                   */
/*    $NV_ROOT/tools/xapi/inc/xapi-sdk-support.h                               */
/* which overrides these #defines when actually using xapigen.                 */

#ifndef XAPI_SDK_H
#define XAPI_SDK_H

/* XAPI envelope size & payload size */
/* Use hard-code header & trailer size to minimize header file burden on nvtypes.h. */
/* The layout is verified by tests. */
#define XAPI_ENVELOPE_SIZE                 16384
#define XAPI_ENVELOPE_MAX_PAYLOAD_SIZE     (XAPI_ENVELOPE_SIZE - 32 /*header*/ - 4 /*trailer*/)

/* Default max size for an XAPI field  */
#define XAPI_MAX_FIELD_SIZE XAPI_ENVELOPE_MAX_PAYLOAD_SIZE

#define XAPI_CASE(x)
#define XAPI_CASE_EMPTY(x) unsigned int : 0        /* hack to safely consume semicolon */
#define XAPI_SWITCH(x)
#define XAPI_HIDDEN(x) x
#define XAPI_FIELD_PTR_AS_VALUE(TYPE, FIELD_NAME) \
    TYPE    *FIELD_NAME
#define XAPI_FIELD_HIDDEN(FIELD_NAME) \
    FIELD_NAME
#define XAPI_FIELD_FUNCTION_PTR(TYPE, FIELD_NAME)                  \
    TYPE     FIELD_NAME
#define XAPI_FIELD_STRING(FIELD_NAME, MAXCHARS) \
    char    FIELD_NAME[MAXCHARS]
#define XAPI_FIELD_PTR_TO_STRING(FIELD_NAME, MAXCHARS) \
    char    *FIELD_NAME
#define XAPI_FIELD_NVP64_PTR_TO_STRING(FIELD_NAME, MAXCHARS) \
    NvP64   FIELD_NAME NV_ALIGN_BYTES(8)
#define XAPI_FIELD_NVP64_PTR_TO_STRING_CI(FIELD_NAME, MAXCHARS) \
    NvP64   FIELD_NAME NV_ALIGN_BYTES(8)
#define XAPI_FIELD_NVP64_PTR_TO_STRING_CO(FIELD_NAME, MAXCHARS) \
    NvP64   FIELD_NAME NV_ALIGN_BYTES(8)

#define XAPI_FIELD_FIXED_BYTE_ARRAY(FIELD_NAME, MAXELEMENTS) \
    NvU8    FIELD_NAME[MAXELEMENTS]
#define XAPI_FIELD_FIXED_BYTE_ARRAY_CI(FIELD_NAME, MAXELEMENTS) \
    NvU8    FIELD_NAME[MAXELEMENTS]
#define XAPI_FIELD_FIXED_BYTE_ARRAY_CO(FIELD_NAME, MAXELEMENTS) \
    NvU8    FIELD_NAME[MAXELEMENTS]

#define XAPI_FIELD_COUNTED_BYTE_ARRAY(FIELD_NAME, FIELD_COUNT, MAXELEMENTS) \
    NvU8    FIELD_NAME[MAXELEMENTS]
#define XAPI_FIELD_COUNTED_BYTE_ARRAY_CI(FIELD_NAME, FIELD_COUNT, MAXELEMENTS) \
    NvU8    FIELD_NAME[MAXELEMENTS]
#define XAPI_FIELD_COUNTED_BYTE_ARRAY_CO(FIELD_NAME, FIELD_COUNT, MAXELEMENTS) \
    NvU8    FIELD_NAME[MAXELEMENTS]

#define XAPI_FIELD_PTR_TO_COUNTED_BYTE_ARRAY(FIELD_NAME, FIELD_COUNT, MAXELEMENTS) \
    NvU8    *FIELD_NAME
#define XAPI_FIELD_PTR_TO_COUNTED_BYTE_ARRAY_CI(FIELD_NAME, FIELD_COUNT, MAXELEMENTS) \
    NvU8    *FIELD_NAME
#define XAPI_FIELD_PTR_TO_COUNTED_BYTE_ARRAY_CO(FIELD_NAME, FIELD_COUNT, MAXELEMENTS) \
    NvU8    *FIELD_NAME

#define XAPI_FIELD_NVP64_PTR_TO_COUNTED_BYTE_ARRAY(FIELD_NAME, FIELD_COUNT, MAXELEMENTS) \
    NvP64   FIELD_NAME NV_ALIGN_BYTES(8)
#define XAPI_FIELD_NVP64_PTR_TO_COUNTED_BYTE_ARRAY_CI(FIELD_NAME, FIELD_COUNT, MAXELEMENTS) \
    NvP64   FIELD_NAME NV_ALIGN_BYTES(8)
#define XAPI_FIELD_NVP64_PTR_TO_COUNTED_BYTE_ARRAY_CO(FIELD_NAME, FIELD_COUNT, MAXELEMENTS) \
    NvP64   FIELD_NAME NV_ALIGN_BYTES(8)

#define XAPI_FIELD_PTR_TO_ARRAY(TYPE, PTR_FIELD_NAME, FIELD_COUNT, MAXELEMENTS) \
    TYPE    *PTR_FIELD_NAME
#define XAPI_FIELD_PTR_TO_ARRAY_CI(TYPE, PTR_FIELD_NAME, FIELD_COUNT, MAXELEMENTS) \
    TYPE    *PTR_FIELD_NAME
#define XAPI_FIELD_PTR_TO_ARRAY_CO(TYPE, PTR_FIELD_NAME, FIELD_COUNT, MAXELEMENTS) \
    TYPE    *PTR_FIELD_NAME

#define XAPI_FIELD_NVP64_PTR_TO_ARRAY(TYPE, PTR_FIELD_NAME, FIELD_COUNT, MAXELEMENTS)  \
    NvP64   PTR_FIELD_NAME NV_ALIGN_BYTES(8)
#define XAPI_FIELD_NVP64_PTR_TO_ARRAY_CI(TYPE, PTR_FIELD_NAME, FIELD_COUNT, MAXELEMENTS)  \
    NvP64   PTR_FIELD_NAME NV_ALIGN_BYTES(8)
#define XAPI_FIELD_NVP64_PTR_TO_ARRAY_CO(TYPE, PTR_FIELD_NAME, FIELD_COUNT, MAXELEMENTS)  \
    NvP64   PTR_FIELD_NAME NV_ALIGN_BYTES(8)

#define XAPI_FIELD_ARRAY(TYPE, INLINE_ARRAY_FIELD_NAME, FIELD_COUNT, MAXELEMENTS)  \
    TYPE    INLINE_ARRAY_FIELD_NAME[MAXELEMENTS]
#define XAPI_FIELD_ARRAY_CI(TYPE, INLINE_ARRAY_FIELD_NAME, FIELD_COUNT, MAXELEMENTS)  \
    TYPE    INLINE_ARRAY_FIELD_NAME[MAXELEMENTS]
#define XAPI_FIELD_ARRAY_CO(TYPE, INLINE_ARRAY_FIELD_NAME, FIELD_COUNT, MAXELEMENTS)  \
    TYPE    INLINE_ARRAY_FIELD_NAME[MAXELEMENTS]

#define XAPI_FIELD_UNION(TYPE, INLINE_UNION_FIELD_NAME, DISCRIMINANT_FIELD)  \
    TYPE INLINE_UNION_FIELD_NAME 
#define XAPI_FIELD_UNION_CI(TYPE, INLINE_UNION_FIELD_NAME, DISCRIMINANT_FIELD)  \
    TYPE INLINE_UNION_FIELD_NAME 
#define XAPI_FIELD_UNION_CO(TYPE, INLINE_UNION_FIELD_NAME, DISCRIMINANT_FIELD)  \
    TYPE INLINE_UNION_FIELD_NAME 

#define XAPI_FIELD_NVP64_PTR(TYPE, FIELD_NAME) \
    NvP64   FIELD_NAME NV_ALIGN_BYTES(8)
#define XAPI_FIELD_NVP64_PTR_CI(TYPE, FIELD_NAME) \
    NvP64   FIELD_NAME NV_ALIGN_BYTES(8)
#define XAPI_FIELD_NVP64_PTR_CO(TYPE, FIELD_NAME) \
    NvP64   FIELD_NAME NV_ALIGN_BYTES(8)

#define XAPI_NYI 


#endif // XAPI_SDK_H
