/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.zaproxy.zap.db.sql.DbSQL;

public class SqlPreparedStatementWrapper {
    private String key;
    private PreparedStatement ps;
    private PreparedStatement psLastInsert;
    private Date created;

    public SqlPreparedStatementWrapper(String key, PreparedStatement ps) {
        this.key = key;
        this.ps = ps;
        this.created = new Date();
    }

    public String getKey() {
        return this.key;
    }

    public PreparedStatement getPs() {
        return this.ps;
    }

    public ResultSet getLastInsertedId() throws SQLException {
        if (this.psLastInsert == null) {
            this.psLastInsert = this.ps.getConnection().prepareStatement(DbSQL.getSQL("table.ps.lastinsert"));
        }
        return this.psLastInsert.executeQuery();
    }

    public void close() throws SQLException {
        this.ps.getConnection().close();
    }

    public long getTimeTaken() {
        return new Date().getTime() - this.created.getTime();
    }
}

