"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var path = require("path");
var fileUrl = require("file-url");
var eventType_1 = require("../lib/eventType");
var locale = require("../locale/locale");
var config = require("../settings/config");
var pkg = require('../../package.json');
var webappVersion;
var APP_PATH = electron_1.app.getAppPath();
var ABOUT_HTML = fileUrl(path.join(APP_PATH, 'html/about.html'));
var ABOUT_WINDOW_WHITELIST = [
    ABOUT_HTML,
    fileUrl(path.join(APP_PATH, 'img/logo.256.png')),
    fileUrl(path.join(APP_PATH, 'css/about.css')),
];
var PRELOAD_JS = path.join(APP_PATH, 'dist/renderer/menu/preload-about.js');
var WINDOW_SIZE = {
    HEIGHT: 256,
    WIDTH: 304,
};
electron_1.ipcMain.once(eventType_1.EVENT_TYPE.UI.WEBAPP_VERSION, function (event, version) { return (webappVersion = version); });
var showWindow = function () {
    var aboutWindow;
    if (!aboutWindow) {
        aboutWindow = new electron_1.BrowserWindow({
            alwaysOnTop: true,
            backgroundColor: '#ececec',
            fullscreen: false,
            height: WINDOW_SIZE.HEIGHT,
            maximizable: false,
            minimizable: false,
            resizable: false,
            show: false,
            title: config.NAME,
            webPreferences: {
                javascript: false,
                nodeIntegration: false,
                nodeIntegrationInWorker: false,
                preload: PRELOAD_JS,
                session: electron_1.session.fromPartition('about-window'),
                webviewTag: false,
            },
            width: WINDOW_SIZE.WIDTH,
        });
        aboutWindow.setMenuBarVisibility(false);
        aboutWindow.webContents.session.webRequest.onBeforeRequest({
            urls: ['*'],
        }, function (details, callback) {
            var url = details.url;
            if (ABOUT_WINDOW_WHITELIST.includes(url)) {
                return callback({ cancel: false });
            }
            if (url.startsWith('https://')) {
                electron_1.shell.openExternal(url);
            }
            else {
                console.log('Attempt to open URL in window prevented, url: %s', url);
            }
            callback({ redirectURL: ABOUT_HTML });
        });
        electron_1.ipcMain.on(eventType_1.EVENT_TYPE.ABOUT.LOCALE_VALUES, function (event, labels) {
            if (aboutWindow) {
                var isExpected = event.sender.id === aboutWindow.webContents.id;
                if (isExpected) {
                    var resultLabels_1 = {};
                    labels.forEach(function (label) { return (resultLabels_1[label] = locale.getText(label)); });
                    event.sender.send(eventType_1.EVENT_TYPE.ABOUT.LOCALE_RENDER, resultLabels_1);
                }
            }
        });
        aboutWindow.webContents.on('before-input-event', function (event, input) {
            if (input.type === 'keyDown' && input.key === 'Escape') {
                if (aboutWindow) {
                    aboutWindow.close();
                }
            }
        });
        aboutWindow.on('closed', function () { return (aboutWindow = undefined); });
        aboutWindow.loadURL(ABOUT_HTML);
        aboutWindow.webContents.on('dom-ready', function () {
            if (aboutWindow) {
                aboutWindow.webContents.send(eventType_1.EVENT_TYPE.ABOUT.LOADED, {
                    copyright: pkg.copyright,
                    electronVersion: pkg.version,
                    environment: pkg.environment,
                    productName: pkg.productName,
                    webappVersion: webappVersion,
                });
            }
        });
    }
    aboutWindow.show();
};
exports.AboutWindow = { showWindow: showWindow };
//# sourceMappingURL=AboutWindow.js.map