/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.core.IntersectionState;
import org.sunflow.core.ShadingCache;
import org.sunflow.system.UI;

public class Statistics {
    private long numEyeRays;
    private long numShadowRays;
    private long numReflectionRays;
    private long numGlossyRays;
    private long numRefractionRays;
    private long numRays;
    private long numPixels;
    private long cacheHits;
    private long cacheMisses;
    private long cacheSumDepth;
    private long cacheNumCaches;

    Statistics() {
        this.reset();
    }

    void reset() {
        this.numEyeRays = 0L;
        this.numShadowRays = 0L;
        this.numReflectionRays = 0L;
        this.numGlossyRays = 0L;
        this.numRefractionRays = 0L;
        this.numRays = 0L;
        this.numPixels = 0L;
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.cacheSumDepth = 0L;
        this.cacheNumCaches = 0L;
    }

    void accumulate(IntersectionState intersectionState) {
        this.numEyeRays += intersectionState.numEyeRays;
        this.numShadowRays += intersectionState.numShadowRays;
        this.numReflectionRays += intersectionState.numReflectionRays;
        this.numGlossyRays += intersectionState.numGlossyRays;
        this.numRefractionRays += intersectionState.numRefractionRays;
        this.numRays += intersectionState.numRays;
    }

    void accumulate(ShadingCache shadingCache) {
        this.cacheHits += shadingCache.hits;
        this.cacheMisses += shadingCache.misses;
        this.cacheSumDepth += shadingCache.sumDepth;
        this.cacheNumCaches += shadingCache.numCaches;
    }

    void setResolution(int n, int n2) {
        this.numPixels = n * n2;
    }

    void displayStats() {
        UI.printInfo(UI.Module.SCENE, "Raytracing stats:", new Object[0]);
        UI.printInfo(UI.Module.SCENE, "  * Rays traced:              (per pixel) (per eye ray) (percentage)", this.numRays);
        this.printRayTypeStats("eye", this.numEyeRays);
        this.printRayTypeStats("shadow", this.numShadowRays);
        this.printRayTypeStats("reflection", this.numReflectionRays);
        this.printRayTypeStats("glossy", this.numGlossyRays);
        this.printRayTypeStats("refraction", this.numRefractionRays);
        this.printRayTypeStats("other", this.numRays - this.numEyeRays - this.numShadowRays - this.numReflectionRays - this.numGlossyRays - this.numRefractionRays);
        this.printRayTypeStats("total", this.numRays);
        if (this.cacheHits + this.cacheMisses > 0L) {
            UI.printInfo(UI.Module.LIGHT, "Shading cache stats:", new Object[0]);
            UI.printInfo(UI.Module.LIGHT, "  * Lookups:             %d", this.cacheHits + this.cacheMisses);
            UI.printInfo(UI.Module.LIGHT, "  * Hits:                %d", this.cacheHits);
            UI.printInfo(UI.Module.LIGHT, "  * Hit rate:            %d%%", 100L * this.cacheHits / (this.cacheHits + this.cacheMisses));
            UI.printInfo(UI.Module.LIGHT, "  * Average cache depth: %.2f", (double)this.cacheSumDepth / (double)this.cacheNumCaches);
        }
    }

    private void printRayTypeStats(String string, long l) {
        if (l > 0L) {
            UI.printInfo(UI.Module.SCENE, "      %-10s  %11d   %7.2f      %7.2f      %6.2f%%", string, l, (double)l / (double)this.numPixels, (double)l / (double)this.numEyeRays, (double)(l * 100L) / (double)this.numRays);
        }
    }
}

