/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.io.Serializable;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.List;
import java.util.concurrent.TimeUnit;
import sbt.io.Unregisterable;
import sbt.io.WatchService$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ms!B\u0001\u0003\u0011\u00039\u0011\u0001D,bi\u000eD7+\u001a:wS\u000e,'BA\u0002\u0005\u0003\tIwNC\u0001\u0006\u0003\r\u0019(\r^\u0002\u0001!\tA\u0011\"D\u0001\u0003\r\u0015Q!\u0001#\u0001\f\u000519\u0016\r^2i'\u0016\u0014h/[2f'\tIA\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'%!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d1AAF\u0005\u0004/\t\u0019r+\u0019;dQN+'O^5dK\u0006#\u0017\r\u001d;feN!Q\u0003\u0004\rh!\tA\u0011DB\u0004\u000b\u0005A\u0005\u0019\u0013\u0001\u000e\u0014\u0005ea\u0001\"\u0002\u000f\u001a\r\u0003i\u0012\u0001B5oSR$\u0012A\b\t\u0003\u001b}I!\u0001\t\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006Ee1\taI\u0001\u000ba>dG.\u0012<f]R\u001cH#\u0001\u0013\u0011\t\u0015bs&\u000f\b\u0003M)\u0002\"a\n\b\u000e\u0003!R!!\u000b\u0004\u0002\rq\u0012xn\u001c;?\u0013\tYc\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u00121!T1q\u0015\tYc\u0002\u0005\u00021o5\t\u0011G\u0003\u00023g\u0005!a-\u001b7f\u0015\t!T'A\u0002oS>T\u0011AN\u0001\u0005U\u00064\u0018-\u0003\u00029c\tAq+\u0019;dQ.+\u0017\u0010E\u0002;\u007f\u0005k\u0011a\u000f\u0006\u0003yu\n\u0011\"[7nkR\f'\r\\3\u000b\u0005yr\u0011AC2pY2,7\r^5p]&\u0011\u0001i\u000f\u0002\u0004'\u0016\f\bc\u0001\u0019C\t&\u00111)\r\u0002\u000b/\u0006$8\r[#wK:$\bC\u0001\u0019F\u0013\t1\u0015G\u0001\u0003QCRD\u0007\"\u0002%\u001a\r\u0003I\u0015\u0001\u00029pY2$\"a\f&\t\u000b-;\u0005\u0019\u0001'\u0002\u000fQLW.Z8viB\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\tIV\u0014\u0018\r^5p]*\u0011\u0011KD\u0001\u000bG>t7-\u001e:sK:$\u0018BA*O\u0005!!UO]1uS>t\u0007\"B+\u001a\r\u00031\u0016\u0001\u0003:fO&\u001cH/\u001a:\u0015\u0007=:\u0016\fC\u0003Y)\u0002\u0007A)\u0001\u0003qCRD\u0007\"\u0002.U\u0001\u0004Y\u0016AB3wK:$8\u000fE\u0002\u000e9zK!!\u0018\b\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0002`E\u0012s!\u0001\r1\n\u0005\u0005\f\u0014AC,bi\u000eDWI^3oi&\u00111\r\u001a\u0002\u0005\u0017&tGM\u0003\u0002bc!)a-\u0007D\u0001;\u0005)1\r\\8tKB\u0011\u0001\u0002[\u0005\u0003S\n\u0011a\"\u00168sK\u001eL7\u000f^3sC\ndW\r\u0003\u0005l+\t\u0005\t\u0015!\u0003m\u0003\u001d\u0019XM\u001d<jG\u0016\u0004\"\u0001M7\n\u0005)\t\u0004\"B\n\u0016\t\u0003yGC\u00019s!\t\tX#D\u0001\n\u0011\u0015Yg\u000e1\u0001m\u0011\u001d!X\u00031A\u0005\nU\faa\u00197pg\u0016$W#\u0001<\u0011\u000559\u0018B\u0001=\u000f\u0005\u001d\u0011un\u001c7fC:DqA_\u000bA\u0002\u0013%10\u0001\u0006dY>\u001cX\rZ0%KF$\"A\b?\t\u000fuL\u0018\u0011!a\u0001m\u0006\u0019\u0001\u0010J\u0019\t\r},\u0002\u0015)\u0003w\u0003\u001d\u0019Gn\\:fI\u0002B\u0011\"a\u0001\u0016\u0005\u0004%I!!\u0002\u0002\u0015I,w-[:uKJ,G-\u0006\u0002\u0002\bA1\u0011\u0011BA\b\t>j!!a\u0003\u000b\u0007\u00055Q(A\u0004nkR\f'\r\\3\n\u00075\nY\u0001\u0003\u0005\u0002\u0014U\u0001\u000b\u0011BA\u0004\u0003-\u0011XmZ5ti\u0016\u0014X\r\u001a\u0011\t\u000bq)B\u0011I\u000f\t\u000b\t*B\u0011I\u0012\t\r!+B\u0011IA\u000e)\ry\u0013Q\u0004\u0005\u0007\u0017\u0006e\u0001\u0019\u0001')\t\u0005e\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002,\u0005\u0015\"a\u0002;bS2\u0014Xm\u0019\u0005\u0007+V!\t%a\f\u0015\u000b=\n\t$a\r\t\ra\u000bi\u00031\u0001E\u0011\u0019Q\u0016Q\u0006a\u00017\"9\u0011qG\u000b\u0005B\u0005e\u0012AC;oe\u0016<\u0017n\u001d;feR\u0019a$a\u000f\t\ra\u000b)\u00041\u0001E\u0011\u00151W\u0003\"\u0011\u001e\u0011\u001d\t\t%\u0006C!\u0003\u0007\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000b\u00022!JA$\u0013\r\tIE\f\u0002\u0007'R\u0014\u0018N\\4\t\u0013\u00055\u0013\"!A\u0005\u0004\u0005=\u0013aE,bi\u000eD7+\u001a:wS\u000e,\u0017\tZ1qi\u0016\u0014Hc\u00019\u0002R!11.a\u0013A\u00021\u0004")
public interface WatchService {
    public static WatchServiceAdapter WatchServiceAdapter(java.nio.file.WatchService watchService) {
        return WatchService$.MODULE$.WatchServiceAdapter(watchService);
    }

    public void init();

    public Map<WatchKey, scala.collection.immutable.Seq<WatchEvent<Path>>> pollEvents();

    public WatchKey poll(Duration var1);

    public WatchKey register(Path var1, Seq<WatchEvent.Kind<Path>> var2);

    public void close();

    public static final class WatchServiceAdapter
    implements WatchService,
    Unregisterable {
        private final java.nio.file.WatchService service;
        private boolean closed;
        private final scala.collection.mutable.Map<Path, WatchKey> registered;

        private boolean closed() {
            return this.closed;
        }

        private void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        private scala.collection.mutable.Map<Path, WatchKey> registered() {
            return this.registered;
        }

        @Override
        public void init() {
        }

        @Override
        public Map<WatchKey, scala.collection.immutable.Seq<WatchEvent<Path>>> pollEvents() {
            IndexedSeq indexedSeq;
            scala.collection.mutable.Map<Path, WatchKey> map = this.registered();
            synchronized (map) {
                indexedSeq = this.registered().values().toIndexedSeq();
            }
            IndexedSeq values = indexedSeq;
            return ((TraversableOnce)values.flatMap((Function1 & Serializable & scala.Serializable)k -> {
                List<WatchEvent<?>> events = k.pollEvents();
                return events.isEmpty() ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2(k, (Object)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(events).asScala()).toIndexedSeq())));
            }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }

        @Override
        public WatchKey poll(Duration timeout) {
            WatchKey watchKey;
            block1: {
                WatchKey watchKey2;
                WatchKey watchKey3;
                do {
                    if (!timeout.isFinite()) continue;
                    watchKey = this.service.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
                    break block1;
                } while ((watchKey3 = this.service.poll(1000L, TimeUnit.MILLISECONDS)) == null);
                watchKey = watchKey2 = watchKey3;
            }
            return watchKey;
        }

        @Override
        public WatchKey register(Path path, Seq<WatchEvent.Kind<Path>> events) {
            WatchKey watchKey;
            if (this.closed()) {
                throw new ClosedWatchServiceException();
            }
            scala.collection.mutable.Map<Path, WatchKey> map = this.registered();
            synchronized (map) {
                WatchKey watchKey2;
                Option option = this.registered().get((Object)path);
                if (None$.MODULE$.equals(option)) {
                    WatchKey key = path.register(this.service, (WatchEvent.Kind[])events.toArray(ClassTag$.MODULE$.apply(WatchEvent.Kind.class)));
                    this.registered().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)key));
                    watchKey2 = key;
                } else if (option instanceof Some) {
                    WatchKey key;
                    Some some = (Some)option;
                    watchKey2 = key = (WatchKey)some.value();
                } else {
                    throw new MatchError((Object)option);
                }
                watchKey = watchKey2;
            }
            return watchKey;
        }

        @Override
        public void unregister(Path path) {
            if (this.closed()) {
                throw new ClosedWatchServiceException();
            }
            scala.collection.mutable.Map<Path, WatchKey> map = this.registered();
            synchronized (map) {
                BoxedUnit boxedUnit;
                Option option = this.registered().get((Object)path);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    WatchKey key = (WatchKey)some.value();
                    key.cancel();
                    boxedUnit = this.registered().$minus$eq((Object)path);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }

        @Override
        public void close() {
            this.closed_$eq(true);
            this.service.close();
        }

        public String toString() {
            return this.service.toString();
        }

        public WatchServiceAdapter(java.nio.file.WatchService service) {
            this.service = service;
            this.closed = false;
            this.registered = Map$.MODULE$.empty();
        }
    }
}

