/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Function;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeTokenTypes;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.psi.types._PyTypeLexer;
import com.jetbrains.python.psi.types.functionalParser.ForwardDeclaration;
import com.jetbrains.python.psi.types.functionalParser.FunctionalParser;
import com.jetbrains.python.psi.types.functionalParser.FunctionalParserBase;
import com.jetbrains.python.psi.types.functionalParser.ParserException;
import com.jetbrains.python.psi.types.functionalParser.Token;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeParser {
    private static final ParseResult EMPTY_RESULT = new ParseResult(null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());

    @Nullable
    public static PyType getTypeByName(@Nullable PsiElement anchor, @NotNull String type) {
        if (type == null) {
            PyTypeParser.$$$reportNull$$$0(0);
        }
        if (anchor == null) {
            return EMPTY_RESULT.getType();
        }
        return PyTypeParser.parse(anchor, type).getType();
    }

    @Nullable
    public static PyType getTypeByName(@Nullable PsiElement anchor, @NotNull String type, @NotNull TypeEvalContext context) {
        if (type == null) {
            PyTypeParser.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyTypeParser.$$$reportNull$$$0(2);
        }
        if (anchor == null) {
            return EMPTY_RESULT.getType();
        }
        return PyTypeParser.parse(anchor, type, context).getType();
    }

    @NotNull
    public static ParseResult parse(@NotNull PsiElement anchor, @NotNull String type) {
        if (anchor == null) {
            PyTypeParser.$$$reportNull$$$0(3);
        }
        if (type == null) {
            PyTypeParser.$$$reportNull$$$0(4);
        }
        ParseResult parseResult = PyTypeParser.parse(anchor, type, TypeEvalContext.codeInsightFallback(anchor.getProject()));
        if (parseResult == null) {
            PyTypeParser.$$$reportNull$$$0(5);
        }
        return parseResult;
    }

    @NotNull
    public static ParseResult parse(@NotNull PsiElement anchor, @NotNull String type, @NotNull TypeEvalContext context) {
        ParseResult parseResult;
        if (anchor == null) {
            PyTypeParser.$$$reportNull$$$0(6);
        }
        if (type == null) {
            PyTypeParser.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PyTypeParser.$$$reportNull$$$0(8);
        }
        PyPsiUtils.assertValid(anchor);
        ForwardDeclaration typeExpr = ForwardDeclaration.create();
        FunctionalParser<ParseResult, PyElementType> classType = FunctionalParserBase.token(PyTypeTokenTypes.IDENTIFIER).then(FunctionalParserBase.many(PyTypeParser.op(".").skipThen(FunctionalParserBase.token(PyTypeTokenTypes.IDENTIFIER)))).map(new MakeSimpleType(anchor, context)).cached().named("class-type");
        FunctionalParser tupleType = PyTypeParser.op("(").skipThen(typeExpr).then(FunctionalParserBase.many(PyTypeParser.op(",").skipThen(typeExpr))).thenSkip(PyTypeParser.op(")")).map(value -> {
            ParseResult result = (ParseResult)value.getFirst();
            List rest = (List)value.getSecond();
            if (rest.isEmpty()) {
                return result;
            }
            ArrayList<PyType> types = new ArrayList<PyType>();
            types.add(result.getType());
            for (ParseResult r : rest) {
                result = result.merge(r);
                types.add(r.getType());
            }
            return result.withType(PyTupleType.create(anchor, types));
        }).named("tuple-type");
        FunctionalParser typeParameter = FunctionalParserBase.token(PyTypeTokenTypes.PARAMETER).then(FunctionalParserBase.maybe(PyTypeParser.op("<=").skipThen(typeExpr))).map(value -> {
            Token token = (Token)value.getFirst();
            String name = token.getText().toString();
            TextRange range = token.getRange();
            ParseResult boundResult = (ParseResult)value.getSecond();
            if (boundResult != null) {
                PyGenericType type1 = new PyGenericType(name, boundResult.getType());
                ParseResult result = new ParseResult(type1, range);
                return result.merge(boundResult).withType(type1);
            }
            return new ParseResult(new PyGenericType(name, null), range);
        }).named("type-parameter");
        FunctionalParser<ParseResult, PyElementType> simpleExpr = classType.or(tupleType).or(typeParameter).named("simple-expr");
        FunctionalParser paramExpr = classType.thenSkip(PyTypeParser.op("[")).then(typeExpr).then(FunctionalParserBase.many(PyTypeParser.op(",").skipThen(typeExpr))).thenSkip(PyTypeParser.op("]")).map(value -> {
            ArrayList<PyType> elementTypes;
            Pair firstPair = (Pair)value.getFirst();
            ParseResult first = (ParseResult)firstPair.getFirst();
            ParseResult second = (ParseResult)firstPair.getSecond();
            List third = (List)value.getSecond();
            PyType firstType = first.getType();
            ArrayList<PyType> typesInBrackets = new ArrayList<PyType>();
            typesInBrackets.add(second.getType());
            ParseResult result = first;
            result = result.merge(second);
            for (ParseResult r : third) {
                typesInBrackets.add(r.getType());
                result = result.merge(r);
            }
            List<PyType> list = elementTypes = third.isEmpty() ? Collections.singletonList(second.getType()) : typesInBrackets;
            if (firstType instanceof PyClassType) {
                PyCollectionTypeImpl type1 = new PyCollectionTypeImpl(((PyClassType)firstType).getPyClass(), false, elementTypes);
                return result.withType(type1);
            }
            return EMPTY_RESULT;
        }).or(classType.thenSkip(PyTypeParser.op("of")).then(simpleExpr).map(value -> {
            ParseResult firstResult = (ParseResult)value.getFirst();
            ParseResult secondResult = (ParseResult)value.getSecond();
            ParseResult result = firstResult.merge(secondResult);
            PyType firstType = firstResult.getType();
            PyType secondType = secondResult.getType();
            if (firstType != null) {
                if (firstType instanceof PyClassType && secondType != null) {
                    return result.withType(new PyCollectionTypeImpl(((PyClassType)firstType).getPyClass(), false, Collections.singletonList(secondType)));
                }
                return result.withType(firstType);
            }
            return EMPTY_RESULT;
        })).or(classType.thenSkip(PyTypeParser.op("from")).then(simpleExpr).thenSkip(PyTypeParser.op("to")).then(simpleExpr).map(value -> {
            Pair firstPair = (Pair)value.getFirst();
            ParseResult first = (ParseResult)firstPair.getFirst();
            ParseResult second = (ParseResult)firstPair.getSecond();
            ParseResult third = (ParseResult)value.getSecond();
            PyType firstType = first.getType();
            if (firstType instanceof PyClassType) {
                List<PyType> elementTypes = Arrays.asList(second.getType(), third.getType());
                PyCollectionTypeImpl type1 = new PyCollectionTypeImpl(((PyClassType)firstType).getPyClass(), false, elementTypes);
                return first.merge(second).merge(third).withType(type1);
            }
            return EMPTY_RESULT;
        })).named("param-expr");
        FunctionalParser callableExpr = PyTypeParser.op("(").skipThen(FunctionalParserBase.maybe(typeExpr.then(FunctionalParserBase.many(PyTypeParser.op(",").skipThen(typeExpr))))).thenSkip(PyTypeParser.op(")")).thenSkip(PyTypeParser.op("->")).then(typeExpr).map(value -> {
            ParseResult result;
            ArrayList<PyCallableParameter> parameters2 = new ArrayList<PyCallableParameter>();
            ParseResult returnResult = (ParseResult)value.getSecond();
            Pair firstPair = (Pair)value.getFirst();
            if (firstPair != null) {
                ParseResult first = (ParseResult)firstPair.getFirst();
                List second = (List)firstPair.getSecond();
                result = first;
                parameters2.add(PyCallableParameterImpl.nonPsi(first.getType()));
                for (ParseResult r : second) {
                    result = result.merge(r);
                    parameters2.add(PyCallableParameterImpl.nonPsi(r.getType()));
                }
                result = result.merge(returnResult);
            } else {
                result = returnResult;
            }
            return result.withType(new PyCallableTypeImpl(parameters2, returnResult.getType()));
        }).named("callable-expr");
        FunctionalParser<ParseResult, PyElementType> singleExpr = paramExpr.or(callableExpr).or(simpleExpr).named("single-expr");
        FunctionalParser unionExpr = singleExpr.then(FunctionalParserBase.many(PyTypeParser.op("or").or(PyTypeParser.op("|")).skipThen(singleExpr))).map(value -> {
            ParseResult first = (ParseResult)value.getFirst();
            List rest = (List)value.getSecond();
            if (rest.isEmpty()) {
                return first;
            }
            ArrayList<PyType> types = new ArrayList<PyType>();
            types.add(first.getType());
            ParseResult result = first;
            for (ParseResult r : rest) {
                types.add(r.getType());
                result = result.merge(r);
            }
            return result.withType(PyUnionType.union(types));
        }).named("union-expr");
        typeExpr.define(unionExpr).named("type-expr");
        FunctionalParser typeFile = typeExpr.endOfInput().named("type-file");
        try {
            parseResult = (ParseResult)typeFile.parse(PyTypeParser.tokenize(type));
        }
        catch (ParserException e) {
            ParseResult parseResult2 = EMPTY_RESULT;
            if (parseResult2 == null) {
                PyTypeParser.$$$reportNull$$$0(10);
            }
            return parseResult2;
        }
        if (parseResult == null) {
            PyTypeParser.$$$reportNull$$$0(9);
        }
        return parseResult;
    }

    private static FunctionalParser<Token<PyElementType>, PyElementType> op(@Nullable String text2) {
        return FunctionalParserBase.token(PyTypeTokenTypes.OP, text2);
    }

    private static List<Token<PyElementType>> tokenize(@NotNull String s) {
        if (s == null) {
            PyTypeParser.$$$reportNull$$$0(11);
        }
        ArrayList<Token<PyElementType>> tokens = new ArrayList<Token<PyElementType>>();
        _PyTypeLexer lexer = new _PyTypeLexer(new StringReader(s));
        lexer.reset(s, 0, s.length(), lexer.yystate());
        try {
            PyElementType type;
            while ((type = lexer.advance()) != null) {
                if (type == PyTypeTokenTypes.SPACE || type == PyTypeTokenTypes.MARKUP) continue;
                TextRange range = TextRange.create((int)lexer.getTokenStart(), (int)lexer.getTokenEnd());
                Token<PyElementType> token = new Token<PyElementType>(type, lexer.yytext(), range);
                tokens.add(token);
            }
        }
        catch (IOException | Error e) {
            return Collections.emptyList();
        }
        return tokens;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeParser";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeParser";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByName";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MakeSimpleType
    implements Function<Pair<Token<PyElementType>, List<Token<PyElementType>>>, ParseResult> {
        @NotNull
        private final PsiElement myAnchor;
        @NotNull
        private final TypeEvalContext myContext;

        MakeSimpleType(@NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
            if (anchor == null) {
                MakeSimpleType.$$$reportNull$$$0(0);
            }
            if (context == null) {
                MakeSimpleType.$$$reportNull$$$0(1);
            }
            this.myAnchor = anchor;
            this.myContext = context;
        }

        @Nullable
        public ParseResult fun(@NotNull Pair<Token<PyElementType>, List<Token<PyElementType>>> value) {
            HashMap imports;
            HashMap fullRanges;
            HashMap types;
            PyFile pyFile;
            PyType type;
            ParseResult result;
            if (value == null) {
                MakeSimpleType.$$$reportNull$$$0(2);
            }
            Token first = (Token)value.getFirst();
            List rest = (List)value.getSecond();
            TextRange firstRange = first.getRange();
            boolean unqualified = rest.isEmpty();
            if (unqualified && (result = this.parseBuiltinType(first)) != null) {
                return result;
            }
            PsiFile file = this.myAnchor.getContainingFile();
            ArrayList<Token<PyElementType>> tokens = new ArrayList<Token<PyElementType>>();
            tokens.add(first);
            tokens.addAll(rest);
            if (file instanceof PyFile && (type = this.resolveQualifierType(tokens, pyFile = (PyFile)file, this.myContext, (Map<TextRange, PyType>)(types = new HashMap()), (Map<PyType, TextRange>)(fullRanges = new HashMap()), (Map<PyType, PyImportElement>)(imports = new HashMap()))) != null) {
                PyResolveContext resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(this.myContext);
                PyExpression expression = this.myAnchor instanceof PyExpression ? (PyExpression)this.myAnchor : null;
                for (Token token : tokens) {
                    PsiElement resolved;
                    PyType qualifierType = type;
                    type = null;
                    List<? extends RatedResolveResult> results = qualifierType.resolveMember(token.getText().toString(), expression, AccessDirection.READ, resolveContext);
                    if (results != null && !results.isEmpty() && (resolved = results.get(0).getElement()) instanceof PyTypedElement) {
                        type = this.myContext.getType((PyTypedElement)resolved);
                        if (type != null && !MakeSimpleType.allowResolveToType(type)) {
                            type = null;
                            break;
                        }
                        if (type instanceof PyClassLikeType) {
                            type = ((PyClassLikeType)type).toInstance();
                        }
                    }
                    if (type == null) break;
                    types.put(token.getRange(), type);
                    fullRanges.put(type, TextRange.create((int)firstRange.getStartOffset(), (int)token.getRange().getEndOffset()));
                }
                if (type != null) {
                    return new ParseResult(type, (Map<TextRange, ? extends PyType>)types, (Map<? extends PyType, TextRange>)fullRanges, (Map<? extends PyType, PyImportElement>)imports);
                }
            }
            return EMPTY_RESULT;
        }

        @Nullable
        private PyType resolveQualifierType(@NotNull List<Token<PyElementType>> tokens, @NotNull PyFile file, @NotNull TypeEvalContext context, @NotNull Map<TextRange, PyType> types, @NotNull Map<PyType, TextRange> fullRanges, @NotNull Map<PyType, PyImportElement> imports) {
            if (tokens == null) {
                MakeSimpleType.$$$reportNull$$$0(3);
            }
            if (file == null) {
                MakeSimpleType.$$$reportNull$$$0(4);
            }
            if (context == null) {
                MakeSimpleType.$$$reportNull$$$0(5);
            }
            if (types == null) {
                MakeSimpleType.$$$reportNull$$$0(6);
            }
            if (fullRanges == null) {
                MakeSimpleType.$$$reportNull$$$0(7);
            }
            if (imports == null) {
                MakeSimpleType.$$$reportNull$$$0(8);
            }
            if (tokens.isEmpty()) {
                return null;
            }
            Token<PyElementType> firstToken = tokens.get(0);
            String firstText = firstToken.getText().toString();
            TextRange firstRange = firstToken.getRange();
            List<RatedResolveResult> resolveResults = file.multiResolveName(firstText);
            if (resolveResults.isEmpty()) {
                return this.getImplicitlyResolvedType(tokens, context, types, fullRanges, firstRange);
            }
            ArrayList members = Lists.newArrayList();
            for (RatedResolveResult result : resolveResults) {
                PsiElement resolved = result.getElement();
                PyType type = null;
                if (resolved instanceof PyTypedElement) {
                    type = context.getType((PyTypedElement)resolved);
                }
                if (type != null) {
                    if (!MakeSimpleType.allowResolveToType(type)) continue;
                    if (type instanceof PyClassLikeType) {
                        type = ((PyClassLikeType)type).toInstance();
                    }
                    types.put(firstRange, type);
                    fullRanges.put(type, firstRange);
                    for (PyFromImportStatement fromImportStatement : file.getFromImports()) {
                        for (PyImportElement importElement : fromImportStatement.getImportElements()) {
                            if (!firstText.equals(importElement.getVisibleName())) continue;
                            imports.put(type, importElement);
                        }
                    }
                    for (PyImportElement importElement : file.getImportTargets()) {
                        if (!firstText.equals(importElement.getVisibleName())) continue;
                        imports.put(type, importElement);
                    }
                }
                members.add(type);
            }
            if (!members.isEmpty()) {
                tokens.remove(0);
            }
            return PyUnionType.union(members);
        }

        @Nullable
        private PyType getImplicitlyResolvedType(@NotNull List<Token<PyElementType>> tokens, @NotNull TypeEvalContext context, @NotNull Map<TextRange, PyType> types, @NotNull Map<PyType, TextRange> fullRanges, TextRange firstRange) {
            if (tokens == null) {
                MakeSimpleType.$$$reportNull$$$0(9);
            }
            if (context == null) {
                MakeSimpleType.$$$reportNull$$$0(10);
            }
            if (types == null) {
                MakeSimpleType.$$$reportNull$$$0(11);
            }
            if (fullRanges == null) {
                MakeSimpleType.$$$reportNull$$$0(12);
            }
            PyType type = null;
            QualifiedName qName = null;
            while (!tokens.isEmpty()) {
                PyType moduleType;
                PsiElement module2;
                Token<PyElementType> token = tokens.get(0);
                String name = token.getText().toString();
                qName = qName != null ? qName.append(name) : QualifiedName.fromComponents((String[])new String[]{name});
                List<PsiElement> modules = PyResolveImportUtil.resolveQualifiedName(qName, PyResolveImportUtil.fromFoothold(this.myAnchor));
                PsiElement psiElement = module2 = !modules.isEmpty() ? modules.get(0) : null;
                if (module2 == null) break;
                if (module2 instanceof PsiDirectory) {
                    module2 = PyUtil.getPackageElement((PsiDirectory)module2, this.myAnchor);
                }
                if (module2 instanceof PyTypedElement && (moduleType = context.getType((PyTypedElement)module2)) != null) {
                    type = moduleType;
                    types.put(token.getRange(), type);
                    fullRanges.put(type, TextRange.create((int)firstRange.getStartOffset(), (int)token.getRange().getEndOffset()));
                }
                tokens.remove(0);
            }
            return type;
        }

        private static boolean allowResolveToType(@NotNull PyType type) {
            if (type == null) {
                MakeSimpleType.$$$reportNull$$$0(13);
            }
            return type instanceof PyClassLikeType || type instanceof PyModuleType || type instanceof PyImportedModuleType || type instanceof PyGenericType;
        }

        @Nullable
        private ParseResult parseBuiltinType(@NotNull Token<PyElementType> token) {
            if (token == null) {
                MakeSimpleType.$$$reportNull$$$0(14);
            }
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(this.myAnchor);
            String name = token.getText().toString();
            TextRange range = token.getRange();
            if ("Any".equals(name)) {
                return EMPTY_RESULT;
            }
            if ("None".equals(name)) {
                return new ParseResult(PyNoneType.INSTANCE, range);
            }
            if ("integer".equals(name) || "long".equals(name)) {
                PyClassType type = builtinCache.getIntType();
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("string".equals(name)) {
                PyType type = builtinCache.getStringType(LanguageLevel.forElement(this.myAnchor));
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("bytestring".equals(name)) {
                PyType type = builtinCache.getByteStringType(LanguageLevel.forElement(this.myAnchor));
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("bytes".equals(name)) {
                PyClassType type = builtinCache.getBytesType(LanguageLevel.forElement(this.myAnchor));
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("unicode".equals(name)) {
                PyClassType type = builtinCache.getUnicodeType(LanguageLevel.forElement(this.myAnchor));
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("boolean".equals(name)) {
                PyClassType type = builtinCache.getBoolType();
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("dictionary".equals(name)) {
                PyClassType type = builtinCache.getDictType();
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("basestring".equals(name)) {
                PyType type = builtinCache.getStrOrUnicodeType();
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            PyClassTypeImpl builtinType = builtinCache.getObjectType(name);
            if (builtinType != null) {
                return new ParseResult(builtinType, range);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 1: 
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokens";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 6: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullRanges";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "imports";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "token";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeParser$MakeSimpleType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fun";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveQualifierType";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getImplicitlyResolvedType";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "allowResolveToType";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseBuiltinType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ParseResult {
        @Nullable
        private final PyType myType;
        @NotNull
        private final Map<TextRange, ? extends PyType> myTypes;
        @NotNull
        private final Map<? extends PyType, TextRange> myFullRanges;
        @NotNull
        private final Map<? extends PyType, PyImportElement> myImports;

        ParseResult(@Nullable PyType type, @NotNull Map<TextRange, ? extends PyType> types, @NotNull Map<? extends PyType, TextRange> fullRanges, @NotNull Map<? extends PyType, PyImportElement> imports) {
            if (types == null) {
                ParseResult.$$$reportNull$$$0(0);
            }
            if (fullRanges == null) {
                ParseResult.$$$reportNull$$$0(1);
            }
            if (imports == null) {
                ParseResult.$$$reportNull$$$0(2);
            }
            this.myType = type;
            this.myTypes = types;
            this.myFullRanges = fullRanges;
            this.myImports = imports;
        }

        ParseResult(@NotNull PyType type, @NotNull TextRange range) {
            if (type == null) {
                ParseResult.$$$reportNull$$$0(3);
            }
            if (range == null) {
                ParseResult.$$$reportNull$$$0(4);
            }
            this(type, (Map<TextRange, ? extends PyType>)ImmutableMap.of((Object)range, (Object)type), (Map<? extends PyType, TextRange>)ImmutableMap.of((Object)type, (Object)range), (Map<? extends PyType, PyImportElement>)ImmutableMap.of());
        }

        @Nullable
        public PyType getType() {
            return this.myType;
        }

        @NotNull
        public Map<TextRange, ? extends PyType> getTypes() {
            Map<TextRange, ? extends PyType> map2 = this.myTypes;
            if (map2 == null) {
                ParseResult.$$$reportNull$$$0(5);
            }
            return map2;
        }

        @NotNull
        public Map<? extends PyType, TextRange> getFullRanges() {
            Map<? extends PyType, TextRange> map2 = this.myFullRanges;
            if (map2 == null) {
                ParseResult.$$$reportNull$$$0(6);
            }
            return map2;
        }

        @NotNull
        public Map<? extends PyType, PyImportElement> getImports() {
            Map<? extends PyType, PyImportElement> map2 = this.myImports;
            if (map2 == null) {
                ParseResult.$$$reportNull$$$0(7);
            }
            return map2;
        }

        private ParseResult merge(@NotNull ParseResult result) {
            if (result == null) {
                ParseResult.$$$reportNull$$$0(8);
            }
            HashMap types = new HashMap();
            HashMap fullRanges = new HashMap();
            HashMap imports = new HashMap();
            types.putAll(this.myTypes);
            types.putAll(result.getTypes());
            fullRanges.putAll(this.myFullRanges);
            fullRanges.putAll(result.getFullRanges());
            imports.putAll(this.myImports);
            imports.putAll(result.getImports());
            return new ParseResult(this.myType, (Map<TextRange, ? extends PyType>)types, (Map<? extends PyType, TextRange>)fullRanges, (Map<? extends PyType, PyImportElement>)imports);
        }

        private ParseResult withType(@Nullable PyType type) {
            return new ParseResult(type, this.myTypes, this.myFullRanges, this.myImports);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullRanges";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "imports";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeParser$ParseResult";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeParser$ParseResult";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypes";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullRanges";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImports";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

