/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.NullableFunction;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class EditSdkDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextField myNameTextField;
    private TextFieldWithBrowseButton myInterpreterPathTextField;
    private JBCheckBox myAssociateCheckbox;
    private JBLabel myRemoveAssociationLabel;
    private final boolean myWasAssociated;
    private boolean myAssociationRemoved = false;

    protected EditSdkDialog(Project project, SdkModificator sdk, final NullableFunction<String, String> nameValidator) {
        super(project, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(PyBundle.message("sdk.edit.dialog.title", objectArray));
        this.myNameTextField.setText(sdk.getName());
        this.myNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String nameError = (String)nameValidator.fun((Object)EditSdkDialog.this.getName());
                EditSdkDialog.this.setErrorText(nameError, EditSdkDialog.this.myNameTextField);
                EditSdkDialog.this.setOKActionEnabled(nameError == null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/configuration/EditSdkDialog$1", "textChanged"));
            }
        });
        String homePath = sdk.getHomePath();
        this.myInterpreterPathTextField.setText(homePath);
        this.myInterpreterPathTextField.addBrowseFolderListener(PyBundle.message("sdk.edit.dialog.specify.interpreter.path", new Object[0]), null, project, PythonSdkType.getInstance().getHomeChooserDescriptor());
        this.myRemoveAssociationLabel.setVisible(false);
        PythonSdkFlavor sdkFlavor = PythonSdkFlavor.getPlatformIndependentFlavor(homePath);
        if (sdkFlavor instanceof VirtualEnvSdkFlavor || sdkFlavor instanceof CondaEnvSdkFlavor) {
            String path;
            PythonSdkAdditionalData data = (PythonSdkAdditionalData)sdk.getSdkAdditionalData();
            if (data != null && (path = data.getAssociatedModulePath()) != null) {
                this.myAssociateCheckbox.setSelected(true);
                String basePath = project.getBasePath();
                if (basePath != null && !path.equals(FileUtil.toSystemIndependentName((String)basePath))) {
                    this.myAssociateCheckbox.setEnabled(false);
                    this.myAssociateCheckbox.setText(PyBundle.message("sdk.edit.dialog.associate.virtual.env.with.path", FileUtil.toSystemDependentName((String)path)));
                    this.myRemoveAssociationLabel.setVisible(true);
                }
            }
        } else {
            this.myAssociateCheckbox.setVisible(false);
        }
        this.myWasAssociated = this.myAssociateCheckbox.isSelected();
        this.init();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                EditSdkDialog.this.myAssociateCheckbox.setSelected(false);
                EditSdkDialog.this.myAssociateCheckbox.setEnabled(true);
                EditSdkDialog.this.myAssociateCheckbox.setText(PyBundle.message("sdk.edit.dialog.associate.virtual.env.current.project", new Object[0]));
                EditSdkDialog.this.myRemoveAssociationLabel.setVisible(false);
                EditSdkDialog.this.myAssociationRemoved = true;
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/configuration/EditSdkDialog$2", "onClick"));
            }
        }.installOn((Component)this.myRemoveAssociationLabel);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    public String getName() {
        return this.myNameTextField.getText();
    }

    public String getHomePath() {
        return this.myInterpreterPathTextField.getText();
    }

    public boolean associateWithProject() {
        return this.myAssociateCheckbox.isSelected();
    }

    public boolean isAssociateChanged() {
        return this.myWasAssociated != this.associateWithProject() || this.myAssociationRemoved;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNameTextField = jTextField = new JTextField();
        jTextField.setColumns(100);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Interpreter path:");
        jLabel2.setDisplayedMnemonic('I');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInterpreterPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myAssociateCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(false);
        jBCheckBox.setText("Associate this virtual environment with current project");
        jBCheckBox.setMnemonic('A');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myRemoveAssociationLabel = jBLabel = new JBLabel();
        jBLabel.setText("<html><a href=\"#\">Remove association</a>");
        jBLabel.setVisible(true);
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

