/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.wizard.Wizard;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.axiom.FreshActionStrategySelector;
import org.protege.editor.owl.model.axiom.FreshAxiomLocationPreferences;
import org.protege.editor.owl.model.axiom.FreshAxiomLocationStrategy;
import org.protege.editor.owl.model.inference.VacuousAxiomVisitor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditorHandler;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOWLFrameSection<R, A extends OWLAxiom, E>
extends OWLAxiomVisitorAdapter
implements OWLFrameSection<R, A, E>,
OWLObjectEditorHandler<E> {
    private final Logger logger = LoggerFactory.getLogger(AbstractOWLFrameSection.class);
    private static int inconsistentOntologyWarnings = 0;
    private OWLEditorKit owlEditorKit;
    private OWLFrame<? extends R> frame;
    private List<OWLFrameSectionRow<R, A, E>> rows;
    private String label;
    private String rowLabel;
    private OWLObjectEditor<E> editor;
    private boolean cacheEditor = true;
    private OWLOntologyChangeListener listener = changes -> this.processOntologyChanges(changes);

    protected AbstractOWLFrameSection(OWLEditorKit editorKit, String label, String rowLabel, OWLFrame<? extends R> frame) {
        this.owlEditorKit = editorKit;
        this.label = label;
        this.rowLabel = rowLabel;
        this.frame = frame;
        this.rows = new ArrayList<OWLFrameSectionRow<R, A, E>>();
        this.getOWLModelManager().addOntologyChangeListener(this.listener);
    }

    protected AbstractOWLFrameSection(OWLEditorKit editorKit, String label, OWLFrame<? extends R> frame) {
        this(editorKit, label, null, frame);
    }

    protected void setCacheEditor(boolean cacheEditor) {
        this.cacheEditor = cacheEditor;
    }

    public List<MListButton> getAdditionalButtons() {
        return Collections.emptyList();
    }

    private void processOntologyChanges(List<? extends OWLOntologyChange> changes) {
        if (this.getRootObject() == null) {
            return;
        }
        this.handleChanges(changes);
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!this.isResettingChange(oWLOntologyChange)) continue;
            this.reset();
            break;
        }
        this.handleOntologyChanges(changes);
    }

    @Deprecated
    protected void handleChanges(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange()) continue;
            oWLOntologyChange.getAxiom().accept((OWLAxiomVisitor)this);
        }
    }

    protected boolean isResettingChange(OWLOntologyChange change) {
        return false;
    }

    protected void handleOntologyChanges(List<? extends OWLOntologyChange> changes) {
    }

    @Override
    public final void dispose() {
        this.getOWLModelManager().removeOntologyChangeListener(this.listener);
        this.disposeOfSection();
        if (this.editor != null) {
            this.editor.dispose();
        }
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    protected OWLReasoner getReasoner() {
        return this.getOWLModelManager().getReasoner();
    }

    protected void disposeOfSection() {
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getRowLabel(OWLFrameSectionRow row) {
        return this.rowLabel;
    }

    @Override
    public final OWLObjectEditor<E> getEditor() {
        if (!this.cacheEditor && this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        if (this.editor == null) {
            OWLObjectEditor<E> ed = this.getObjectEditor();
            if (ed != null) {
                ed.setHandler(this);
            }
            if (ed instanceof Wizard) {
                return ed;
            }
            this.editor = ed;
        }
        if (this.editor != null) {
            this.editor.clear();
        }
        return this.editor;
    }

    @Override
    public void handleEditingFinished(Set<E> editedObjects) {
        if (editedObjects == null) {
            return;
        }
        HashSet<A> axioms = new HashSet<A>();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (E editedObject : editedObjects) {
            A ax = this.createAxiom(editedObject);
            FreshAxiomLocationPreferences prefs = FreshAxiomLocationPreferences.getPreferences();
            FreshActionStrategySelector strategySelector = new FreshActionStrategySelector(prefs, this.owlEditorKit);
            FreshAxiomLocationStrategy strategy = strategySelector.getFreshAxiomLocationStrategy();
            OWLOntology ontology = strategy.getFreshAxiomLocation((OWLAxiom)ax, this.getOWLModelManager());
            changes.add(new AddAxiom(ontology, ax));
            axioms.add(ax);
        }
        this.getOWLModelManager().applyChanges(changes);
        for (OWLAxiom axiom : axioms) {
            if (this.getOWLModelManager().getActiveOntology().containsAxiom(axiom)) continue;
            this.logger.warn("Editing of an axiom finished, but the axiom was not added to the active ontology. Axiom: {}.", (Object)axiom);
        }
    }

    protected abstract A createAxiom(E var1);

    public abstract OWLObjectEditor<E> getObjectEditor();

    @Override
    public boolean checkEditorResults(OWLObjectEditor<E> editor) {
        return true;
    }

    @Override
    public int getRowIndex(OWLFrameSectionRow row) {
        return this.rows.indexOf(row);
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public OWLModelManager getOWLModelManager() {
        return this.owlEditorKit.getModelManager();
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.getOWLModelManager().getOWLOntologyManager();
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.getOWLModelManager().getOWLDataFactory();
    }

    public OWLReasoner getCurrentReasoner() {
        return this.getOWLModelManager().getOWLReasonerManager().getCurrentReasoner();
    }

    @Override
    public OWLFrame<? extends R> getFrame() {
        return this.frame;
    }

    @Override
    public R getRootObject() {
        return this.frame.getRootObject();
    }

    @Override
    public void setRootObject(R rootObject) {
        Comparator comparator;
        this.rows.clear();
        this.clear();
        if (rootObject != null) {
            for (OWLOntology ontology : this.getOntologies()) {
                this.refill(ontology);
            }
            try {
                this.refillInferred();
            }
            catch (InconsistentOntologyException ioe) {
                this.logger.error("An InconsistentOntologyException was thrown when refilling the inferred information in a frame section.  The frame section implementation should take care of this.", (Throwable)ioe);
            }
            catch (Exception e) {
                this.logger.warn("An error occurred whilst filling the {} frame with inferred information: {}", (Object)this.getClass().getName(), (Object)e);
            }
        }
        if ((comparator = this.getRowComparator()) != null) {
            Collections.sort(this.rows, comparator);
        }
        this.fireContentChanged();
    }

    protected Set<OWLOntology> getOntologies() {
        return this.getOWLModelManager().getActiveOntologies();
    }

    protected abstract void refill(OWLOntology var1);

    protected abstract void clear();

    protected void refillInferred() {
    }

    protected void addRow(OWLFrameSectionRow<R, A, E> row) {
        this.rows.add(row);
    }

    protected void addInferredRowIfNontrivial(OWLFrameSectionRow<R, A, E> row) {
        if (row.isInferred() && (VacuousAxiomVisitor.isVacuousAxiom(row.getAxiom()) || VacuousAxiomVisitor.involvesInverseSquared(row.getAxiom()))) {
            return;
        }
        this.addRow(row);
    }

    protected void reset() {
        this.setRootObject(this.getRootObject());
        this.fireContentChanged();
    }

    private void fireContentChanged() {
        this.getFrame().fireContentChanged();
    }

    @Override
    public List<OWLFrameSectionRow<R, A, E>> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    @Override
    public List<A> getAxioms() {
        ArrayList<A> axioms = new ArrayList<A>();
        for (OWLFrameSectionRow<R, A, E> row : this.rows) {
            axioms.add(row.getAxiom());
        }
        return axioms;
    }

    public String getRendering() {
        return this.label;
    }

    public boolean canAdd() {
        return this.getOWLModelManager().isActiveOntologyMutable();
    }

    @Override
    public boolean canAcceptDrop(List<OWLObject> objects) {
        return false;
    }

    @Override
    public boolean dropObjects(List<OWLObject> objects) {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRendering());
        sb.append(":\n");
        for (OWLFrameSectionRow<R, A, E> row : this.getRows()) {
            sb.append("\t");
            sb.append(row);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getName() {
        return this.getLabel();
    }

    @Deprecated
    public void visit(OWLDeclarationAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLSubClassOfAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLDisjointClassesAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLDataPropertyDomainAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLDifferentIndividualsAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLDisjointUnionAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLDataPropertyRangeAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLClassAssertionAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLEquivalentClassesAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLSameIndividualAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLHasKeyAxiom axiom) {
    }

    @Deprecated
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
    }

    @Deprecated
    public void visit(SWRLRule rule) {
    }
}

