/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.access;

import java.io.InvalidObjectException;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.truffle.TruffleDebugManager;
import org.netbeans.modules.debugger.jpda.truffle.access.Bundle;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.openide.util.Exceptions;

public class TruffleEval {
    private static final String METHOD_EVALUATE = "evaluate";
    private static final String METHOD_EVALUATE_ON_FRAME_SIG = "(Lcom/oracle/truffle/api/debug/DebugStackFrame;Ljava/lang/String;)Ljava/lang/Object;";

    private TruffleEval() {
    }

    public static Variable evaluate(JPDADebugger debugger, String expression) throws InvalidExpressionException {
        JPDAThread currentThread = debugger.getCurrentThread();
        CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(currentThread);
        if (currentPCInfo == null) {
            throw new InvalidExpressionException(Bundle.MSG_NoSuspend());
        }
        ObjectVariable stackFrameInstance = currentPCInfo.getSelectedStackFrame().getStackFrameInstance();
        JPDAClassType debugAccessor = TruffleDebugManager.getDebugAccessorJPDAClass(debugger);
        try {
            Variable mirrorExpression = debugger.createMirrorVar((Object)expression);
            Variable valueVar = debugAccessor.invokeMethod(METHOD_EVALUATE, METHOD_EVALUATE_ON_FRAME_SIG, new Variable[]{stackFrameInstance, mirrorExpression});
            return valueVar;
        }
        catch (InvalidObjectException | NoSuchMethodException ex) {
            try {
                return debugger.createMirrorVar((Object)ex.getLocalizedMessage());
            }
            catch (InvalidObjectException iex) {
                Exceptions.printStackTrace((Throwable)iex);
                return null;
            }
        }
    }
}

