/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public class CompositeMessageConverter
implements MessageConverter {
    private final List<MessageConverter> converters;
    private ContentTypeResolver contentTypeResolver;

    public CompositeMessageConverter(Collection<MessageConverter> converters) {
        this(new ArrayList<MessageConverter>(converters), new DefaultContentTypeResolver());
    }

    public CompositeMessageConverter(Collection<MessageConverter> converters, ContentTypeResolver resolver) {
        Assert.notEmpty(converters, (String)"Converters must not be null");
        Assert.notNull((Object)resolver, (String)"ContentTypeResolver must not be null");
        this.converters = new ArrayList<MessageConverter>(converters);
        this.contentTypeResolver = resolver;
        CompositeMessageConverter.applyContentTypeResolver(converters, resolver);
    }

    private static void applyContentTypeResolver(Collection<MessageConverter> converters, ContentTypeResolver resolver) {
        for (MessageConverter converter : converters) {
            if (!(converter instanceof AbstractMessageConverter)) continue;
            ((AbstractMessageConverter)converter).setContentTypeResolver(resolver);
        }
    }

    public void setContentTypeResolver(ContentTypeResolver resolver) {
        this.contentTypeResolver = resolver;
        CompositeMessageConverter.applyContentTypeResolver(this.getConverters(), resolver);
    }

    public ContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public Collection<MessageConverter> getConverters() {
        return this.converters;
    }

    @Override
    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        for (MessageConverter converter : this.converters) {
            Object result = converter.fromMessage(message, targetClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        for (MessageConverter converter : this.converters) {
            Message<?> result = converter.toMessage(payload, headers);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

