/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.ddl.CommandNotSupportedException;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.node.CatalogNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MakeDefaultCatalogAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(MakeDefaultCatalogAction.class.getName());

    public String getName() {
        return NbBundle.getMessage(MakeDefaultCatalogAction.class, (String)"MakeDefaultCatalog");
    }

    protected boolean enable(Node[] activatedNodes) {
        CatalogNode node;
        boolean result = false;
        if (activatedNodes.length == 1 && (node = (CatalogNode)activatedNodes[0].getLookup().lookup(CatalogNode.class)) != null) {
            DatabaseConnector connector = ((DatabaseConnection)node.getLookup().lookup(DatabaseConnection.class)).getConnector();
            result = connector.supportsCommand("SetDefaultDatabaseCommand");
        }
        return result;
    }

    protected void performAction(final Node[] activatedNodes) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                DatabaseConnection connection = (DatabaseConnection)activatedNodes[0].getLookup().lookup(DatabaseConnection.class);
                String name = ((CatalogNode)activatedNodes[0].getLookup().lookup(CatalogNode.class)).getName();
                try {
                    connection.setDefaultCatalog(name);
                }
                catch (CommandNotSupportedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (DDLException e) {
                    try {
                        MakeDefaultCatalogAction.this.handleDLLException(connection, e);
                    }
                    catch (SQLException ex) {
                        Exceptions.printStackTrace((Throwable)e);
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
    }

    private void handleDLLException(DatabaseConnection dbConn, DDLException e) throws SQLException, MissingResourceException {
        Connection conn;
        Connection connection = conn = dbConn == null ? null : dbConn.getJDBCConnection();
        if (conn != null && !conn.isValid(1000)) {
            LOGGER.log(Level.INFO, e.getMessage(), e);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(MakeDefaultCatalogAction.class, (String)"ERR_ConnectionToServerClosed"), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        } else {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MakeDefaultCatalogAction.class);
    }
}

