/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.hints.infrastructure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.core.CancelSupportImplementation;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.core.SchedulerTaskCancelSupportImpl;
import org.netbeans.modules.csl.core.SpiSupportAccessor;
import org.netbeans.modules.csl.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

public final class HintsTask
extends ParserResultTask<ParserResult> {
    private static final Logger LOG = Logger.getLogger(HintsTask.class.getName());
    private final CancelSupportImplementation cancel = SchedulerTaskCancelSupportImpl.create((SchedulerTask)this);
    private volatile HintsProvider pendingProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ParserResult result, SchedulerEvent event) {
        final ArrayList descriptions = new ArrayList();
        SpiSupportAccessor.getInstance().setCancelSupport(this.cancel);
        try {
            ParserManager.parse(Collections.singleton(result.getSnapshot().getSource()), (UserTask)new UserTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(ResultIterator resultIterator) throws ParseException {
                    if (resultIterator == null) {
                        return;
                    }
                    for (Embedding e : resultIterator.getEmbeddings()) {
                        this.run(resultIterator.getResultIterator(e));
                    }
                    Language language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType());
                    if (language == null) {
                        return;
                    }
                    HintsProvider provider = language.getHintsProvider();
                    if (provider == null) {
                        return;
                    }
                    GsfHintsManager manager = language.getHintsManager();
                    if (manager == null) {
                        return;
                    }
                    Parser.Result r = resultIterator.getParserResult();
                    if (!(r instanceof ParserResult)) {
                        return;
                    }
                    ParserResult parserResult = (ParserResult)r;
                    RuleContext ruleContext = manager.createRuleContext(parserResult, language, -1, -1, -1);
                    if (ruleContext == null) {
                        return;
                    }
                    ArrayList<Hint> hints = new ArrayList<Hint>();
                    try {
                        HintsTask hintsTask = HintsTask.this;
                        synchronized (hintsTask) {
                            HintsTask.this.pendingProvider = provider;
                            if (HintsTask.this.cancel.isCancelled()) {
                                return;
                            }
                        }
                        provider.computeHints(manager, ruleContext, hints);
                    }
                    finally {
                        HintsTask.this.pendingProvider = null;
                    }
                    if (HintsTask.this.cancel.isCancelled()) {
                        return;
                    }
                    int i = 0;
                    while (i < hints.size()) {
                        Hint hint = (Hint)hints.get(i);
                        ErrorDescription desc = manager.createDescription(hint, ruleContext, false, i == hints.size() - 1);
                        descriptions.add(desc);
                        ++i;
                    }
                }
            });
        }
        catch (ParseException e) {
            LOG.log(Level.WARNING, null, e);
        }
        finally {
            SpiSupportAccessor.getInstance().removeCancelSupport(this.cancel);
        }
        HintsController.setErrors((FileObject)result.getSnapshot().getSource().getFileObject(), (String)HintsTask.class.getName(), descriptions);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        HintsProvider proc = this.pendingProvider;
        if (proc != null) {
            proc.cancel();
        }
    }
}

