/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.module.graph;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.java.graph.DependencyGraphScene;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.netbeans.modules.java.module.graph.Bundle;
import org.netbeans.modules.java.module.graph.DependencyCalculator;
import org.netbeans.modules.java.module.graph.DependencyEdge;
import org.netbeans.modules.java.module.graph.ModuleNode;
import org.openide.awt.Mnemonics;
import org.openide.awt.Toolbar;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

final class GraphTopComponent
extends TopComponent
implements MultiViewElement,
Runnable {
    private static final String ZOOM_IN_ICON = "org/netbeans/modules/java/module/graph/resources/zoomin.gif";
    private static final String ZOOM_OUT_ICON = "org/netbeans/modules/java/module/graph/resources/zoomout.gif";
    private static final String PUBLIC_ICON = "org/netbeans/modules/java/module/graph/resources/public.gif";
    private static final RequestProcessor RP = new RequestProcessor(GraphTopComponent.class);
    private final RequestProcessor.Task refreshTask = RP.create((Runnable)this);
    private final JScrollPane pane = new JScrollPane();
    private final ChangeSupport changeSupport;
    private boolean alreadyShown;
    private boolean needsRefresh;
    private MultiViewElementCallback callback;
    private EditorToolbar toolbar;
    private DependencyGraphScene<ModuleNode> scene;
    private Collection<? extends DependencyEdge> edges;
    private Timer timer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GraphTopComponent.this.checkFindValue();
        }
    });
    private JComboBox<String> jComboBox1;
    private JPanel jPanel1;
    private JToolBar jToolBar1;
    private JComboBox<String> jdkComboBox;
    private JLabel jdkLabel;
    private JLabel lblFind;
    private JLabel lblPath;
    private JSpinner maxPathSpinner;
    private JCheckBox transitiveCheckBox;
    private JTextField txtFind;
    private JButton zoomIn;
    private JButton zoomOut;
    private static final BasicStroke TRANSITIVE_STROKE = new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{5.0f, 5.0f}, 0.0f);

    GraphTopComponent(@NonNull Lookup lkp) {
        Parameters.notNull((CharSequence)"lkp", (Object)lkp);
        this.changeSupport = new ChangeSupport((FileObject)lkp.lookup(FileObject.class), () -> {
            this.needsRefresh = true;
        });
        this.associateLookup(lkp);
        this.initComponents();
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.txtFind.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                GraphTopComponent.this.timer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                GraphTopComponent.this.timer.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                GraphTopComponent.this.timer.restart();
            }
        });
        this.jdkComboBox.setModel(new DefaultComboBoxModel<JDKVisibility>(JDKVisibility.values()));
        this.jdkComboBox.setRenderer(new JDKRenderer());
        this.timer.setDelay(500);
        this.timer.setRepeats(false);
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new EditorToolbar();
            this.toolbar.setFloatable(false);
            this.toolbar.setRollover(true);
            this.toolbar.addSeparator();
            Dimension space = new Dimension(3, 0);
            this.toolbar.add(this.zoomIn);
            this.toolbar.addSeparator(space);
            this.toolbar.add(this.zoomOut);
            this.toolbar.addSeparator(space);
            this.toolbar.add(this.lblFind);
            this.toolbar.add(this.txtFind);
            this.toolbar.addSeparator(space);
            this.toolbar.add(this.lblPath);
            this.toolbar.add(this.maxPathSpinner);
            this.toolbar.addSeparator();
            this.toolbar.add(this.jdkLabel);
            this.toolbar.add(this.jdkComboBox);
            this.toolbar.addSeparator(space);
            this.toolbar.add(this.transitiveCheckBox);
        }
        return this.toolbar;
    }

    public void componentOpened() {
        super.componentOpened();
        this.pane.setWheelScrollingEnabled(true);
        this.add(this.pane, "Center");
        this.alreadyShown = false;
        this.needsRefresh = true;
    }

    public void componentActivated() {
        super.componentActivated();
        if (this.needsRefresh) {
            this.refreshModel();
            this.needsRefresh = false;
            this.alreadyShown = true;
        }
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentShowing() {
        super.componentShowing();
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    @Override
    public void run() {
        FileObject moduleInfo = (FileObject)this.getLookup().lookup(FileObject.class);
        assert (moduleInfo != null);
        DependencyCalculator calc = new DependencyCalculator(moduleInfo);
        Collection<? extends ModuleNode> nodes = calc.getNodes();
        Collection<DependencyEdge> edges = calc.getEdges();
        SwingUtilities.invokeLater(() -> this.displayScene(nodes, edges));
    }

    @NonNull
    JScrollPane getScrollPane() {
        return this.pane;
    }

    private void initComponents() {
        this.jComboBox1 = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.zoomIn = new JButton();
        this.zoomOut = new JButton();
        this.lblFind = new JLabel();
        this.txtFind = new JTextField();
        this.lblPath = new JLabel();
        this.maxPathSpinner = new JSpinner();
        this.jdkLabel = new JLabel();
        this.jdkComboBox = new JComboBox();
        this.transitiveCheckBox = new JCheckBox();
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.zoomIn.setIcon(ImageUtilities.loadImageIcon((String)ZOOM_IN_ICON, (boolean)true));
        Mnemonics.setLocalizedText((AbstractButton)this.zoomIn, (String)NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.zoomIn.text"));
        this.zoomIn.setFocusable(false);
        this.zoomIn.setHorizontalTextPosition(0);
        this.zoomIn.setVerticalTextPosition(3);
        this.zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.zoomIn(evt);
            }
        });
        this.jToolBar1.add(this.zoomIn);
        this.zoomOut.setIcon(ImageUtilities.loadImageIcon((String)ZOOM_OUT_ICON, (boolean)true));
        Mnemonics.setLocalizedText((AbstractButton)this.zoomOut, (String)NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.zoomOut.text"));
        this.zoomOut.setFocusable(false);
        this.zoomOut.setHorizontalTextPosition(0);
        this.zoomOut.setVerticalTextPosition(3);
        this.zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.zoomOut(evt);
            }
        });
        this.jToolBar1.add(this.zoomOut);
        this.jPanel1.add(this.jToolBar1);
        Mnemonics.setLocalizedText((JLabel)this.lblFind, (String)NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.lblFind.text"));
        this.jPanel1.add(this.lblFind);
        this.txtFind.setMaximumSize(new Dimension(200, 22));
        this.txtFind.setMinimumSize(new Dimension(50, 19));
        this.txtFind.setPreferredSize(new Dimension(150, 22));
        this.txtFind.setFont(new Font("Arial", 0, 11));
        this.jPanel1.add(this.txtFind);
        Mnemonics.setLocalizedText((JLabel)this.lblPath, (String)NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.lblPath.text"));
        this.lblPath.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.lblPath.toolTipText"));
        this.jPanel1.add(this.lblPath);
        this.maxPathSpinner.setModel(new SpinnerNumberModel(1, 1, 5, 1));
        this.maxPathSpinner.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.maxPathSpinner.toolTipText"));
        this.maxPathSpinner.setMaximumSize(new Dimension(60, Short.MAX_VALUE));
        this.maxPathSpinner.setRequestFocusEnabled(false);
        this.maxPathSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GraphTopComponent.this.maxPathSpinnerStateChanged(evt);
            }
        });
        this.jPanel1.add(this.maxPathSpinner);
        Mnemonics.setLocalizedText((JLabel)this.jdkLabel, (String)NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jdkLabel.text"));
        this.jdkLabel.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jdkLabel.toolTipText"));
        this.jPanel1.add(this.jdkLabel);
        this.jdkComboBox.setMaximumSize(new Dimension(300, Short.MAX_VALUE));
        this.jdkComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GraphTopComponent.this.jdkComboBoxItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.jdkComboBox);
        Mnemonics.setLocalizedText((AbstractButton)this.transitiveCheckBox, (String)NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.transitiveCheckBox.text"));
        this.transitiveCheckBox.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.transitiveCheckBox.toolTipText"));
        this.transitiveCheckBox.setIcon(ImageUtilities.loadImageIcon((String)PUBLIC_ICON, (boolean)true));
        this.transitiveCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.transitiveCheckBoxActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.transitiveCheckBox);
        this.add(this.jPanel1, "North");
    }

    private void zoomIn(ActionEvent evt) {
        this.scene.setMyZoomFactor(this.scene.getZoomFactor() * 1.2);
        this.scene.validate();
        this.scene.repaint();
        if (this.pane.getHorizontalScrollBar().isVisible() || this.pane.getVerticalScrollBar().isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    private void zoomOut(ActionEvent evt) {
        this.scene.setMyZoomFactor(this.scene.getZoomFactor() * 0.8);
        this.scene.validate();
        this.scene.repaint();
        if (!this.pane.getHorizontalScrollBar().isVisible() && !this.pane.getVerticalScrollBar().isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    private void maxPathSpinnerStateChanged(ChangeEvent evt) {
        this.scene.highlightDepth(this.getSelectedDepth());
    }

    private void jdkComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.scene != null) {
            this.scene.updateVisibility();
        }
    }

    private void transitiveCheckBoxActionPerformed(ActionEvent evt) {
        if (this.scene != null) {
            this.scene.updateVisibility();
        }
    }

    private void checkFindValue() {
        String val = this.txtFind.getText().trim();
        if ("".equals(val)) {
            val = null;
        }
        this.scene.setSearchString(val);
    }

    private void refreshModel() {
        this.setPaneText(this.alreadyShown ? Bundle.TXT_RefreshingDependencies() : Bundle.TXT_ComputingDependencies());
        this.enableControls(false);
        this.refreshTask.schedule(0);
    }

    private void enableControls(boolean enable) {
        this.zoomIn.setEnabled(enable);
        this.zoomOut.setEnabled(enable);
    }

    private void setPaneText(@NonNull String text) {
        JLabel lbl = new JLabel(text);
        lbl.setHorizontalAlignment(0);
        lbl.setVerticalAlignment(0);
        this.pane.setViewportView(lbl);
    }

    private void displayScene(@NonNull Collection<? extends ModuleNode> nodes, @NonNull Collection<? extends DependencyEdge> edges) {
        this.edges = edges;
        DependencyGraphScene.PaintingProvider<ModuleNode> paintingProvider = new DependencyGraphScene.PaintingProvider<ModuleNode>(){

            public boolean isVisible(ModuleNode node) {
                switch ((JDKVisibility)((Object)GraphTopComponent.this.jdkComboBox.getSelectedItem())) {
                    case ALL: {
                        return true;
                    }
                    case DIRECT: {
                        if (!node.isJdk()) {
                            return true;
                        }
                        Collection edges = GraphTopComponent.this.scene.findNodeEdges((Object)GraphTopComponent.this.scene.getGraphNodeRepresentant((GraphNodeImplementation)node), true, true);
                        return edges.stream().anyMatch(e -> !((ModuleNode)e.getSource()).isJdk() && !GraphTopComponent.this.getEdge((ModuleNode)e.getSource(), (ModuleNode)e.getTarget()).isTrasitive());
                    }
                    case NONE: {
                        return !node.isJdk();
                    }
                }
                assert (false);
                return true;
            }

            public boolean isVisible(ModuleNode source, ModuleNode target) {
                DependencyEdge edge = GraphTopComponent.this.getEdge(source, target);
                assert (edge != null);
                if (edge.isTrasitive() && !GraphTopComponent.this.transitiveCheckBox.isSelected()) {
                    return false;
                }
                switch ((JDKVisibility)((Object)GraphTopComponent.this.jdkComboBox.getSelectedItem())) {
                    case ALL: {
                        return true;
                    }
                    case DIRECT: 
                    case NONE: {
                        return this.isVisible(source) && this.isVisible(target);
                    }
                }
                assert (false);
                return true;
            }

            public Stroke getStroke(ModuleNode source, ModuleNode target) {
                if (!GraphTopComponent.this.transitiveCheckBox.isSelected()) {
                    return null;
                }
                DependencyEdge edge = GraphTopComponent.this.getEdge(source, target);
                assert (edge != null);
                BasicStroke s = null;
                if (edge.isTrasitive()) {
                    s = TRANSITIVE_STROKE;
                }
                return s;
            }

            public Icon getIcon(ModuleNode node) {
                return null;
            }

            public Color getColor(ModuleNode node) {
                return null;
            }
        };
        this.scene = new DependencyGraphScene(null, this::getSelectedDepth, null, (DependencyGraphScene.PaintingProvider)paintingProvider);
        nodes.stream().forEach(n -> this.scene.addGraphNodeImpl((GraphNodeImplementation)n));
        edges.stream().forEach(e -> this.scene.addEdge((GraphNodeImplementation)e.getSource(), (GraphNodeImplementation)e.getTarget()));
        this.scene.calculatePrimaryPathsAndLevels();
        JComponent sceneView = this.scene.getView();
        if (sceneView == null) {
            sceneView = this.scene.createView();
            sceneView.putClientProperty("print.printable", true);
        }
        this.pane.setViewportView(sceneView);
        this.scene.setSurroundingScrollPane(this.pane);
        this.scene.initialLayout();
        this.scene.setSelectedObjects(Collections.singleton(this.scene.getRootGraphNode()));
        if (this.scene.getMaxNodeDepth() > 1) {
            this.lblPath.setVisible(true);
            ((SpinnerNumberModel)this.maxPathSpinner.getModel()).setMaximum(Integer.valueOf(this.scene.getMaxNodeDepth()));
            this.maxPathSpinner.setEnabled(true);
            this.maxPathSpinner.setVisible(true);
        }
        this.scene.highlightDepth(this.getSelectedDepth());
        this.enableControls(true);
    }

    private DependencyEdge getEdge(ModuleNode source, ModuleNode target) {
        for (DependencyEdge dependencyEdge : this.edges) {
            if (!dependencyEdge.getSource().equals(source) || !dependencyEdge.getTarget().equals(target)) continue;
            return dependencyEdge;
        }
        return null;
    }

    private int getSelectedDepth() {
        return ((SpinnerNumberModel)this.maxPathSpinner.getModel()).getNumber().intValue();
    }

    private static class JDKRenderer
    extends DefaultListCellRenderer {
        private JDKRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JDKVisibility) {
                value = ((JDKVisibility)((Object)value)).displayName;
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static enum JDKVisibility {
        ALL(Bundle.LBL_All()),
        DIRECT(Bundle.LBL_Direct()),
        NONE(Bundle.LBL_None());

        final String displayName;

        private JDKVisibility(String displayName) {
            this.displayName = displayName;
        }
    }

    private static class ChangeSupport
    extends FileChangeAdapter
    implements PropertyChangeListener,
    DocumentListener {
        private final Runnable resetAction;
        private final FileObject file;
        private final EditorCookie.Observable ec;
        private Document currentDoc;

        ChangeSupport(@NonNull FileObject file, @NonNull Runnable resetAction) {
            Parameters.notNull((CharSequence)"file", (Object)file);
            Parameters.notNull((CharSequence)"resetAction", (Object)resetAction);
            this.resetAction = resetAction;
            this.file = file;
            this.file.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)this.file));
            EditorCookie.Observable cookie = null;
            try {
                DataObject dobj = DataObject.find((FileObject)file);
                cookie = (EditorCookie.Observable)dobj.getLookup().lookup(EditorCookie.Observable.class);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            this.ec = cookie;
            if (this.ec != null) {
                this.ec.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.ec));
                this.assignDocListener((EditorCookie)this.ec);
            }
        }

        public void fileDataCreated(FileEvent fe) {
            this.reset();
        }

        public void fileChanged(FileEvent fe) {
            this.reset();
        }

        public void fileDeleted(FileEvent fe) {
            this.reset();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.reset();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("document".equals(evt.getPropertyName())) {
                this.assignDocListener((EditorCookie)this.ec);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.reset();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.reset();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void reset() {
            this.resetAction.run();
        }

        private void assignDocListener(@NonNull EditorCookie ec) {
            if (this.currentDoc != null) {
                this.currentDoc.removeDocumentListener(this);
            }
            this.currentDoc = ec.getDocument();
            if (this.currentDoc != null) {
                this.currentDoc.addDocumentListener(this);
            }
        }
    }

    private static class EditorToolbar
    extends Toolbar {
        public EditorToolbar() {
            Border b = UIManager.getBorder("Nb.Editor.Toolbar.border");
            this.setBorder(b);
            if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                this.setBackground(UIManager.getColor("NbExplorerView.background"));
            }
        }

        public String getUIClassID() {
            if (UIManager.get("Nb.Toolbar.ui") != null) {
                return "Nb.Toolbar.ui";
            }
            return super.getUIClassID();
        }

        public String getName() {
            return "editorToolbar";
        }
    }
}

