/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.RenameAction;
import org.openide.cookies.OpenCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;

public class BookmarkNode
extends AbstractNode {
    private static final Action DEFAULT_ACTION = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof BookmarkNode) {
                BookmarkNode node = (BookmarkNode)((Object)source);
                node.openInEditor();
            }
        }
    };
    private final BookmarkInfo bookmarkInfo;
    private static Image bookmarkIcon;

    public BookmarkNode(BookmarkInfo bookmarkInfo) {
        super(Children.LEAF);
        assert (bookmarkInfo != null);
        this.bookmarkInfo = bookmarkInfo;
        this.setShortDescription(bookmarkInfo.getFullPathDescription());
    }

    public String getName() {
        return this.bookmarkInfo.getName();
    }

    public void setName(String name) {
        String origName = this.getName();
        if (!name.equals(origName)) {
            BookmarkUtils.setBookmarkNameUnderLock(this.bookmarkInfo, name);
            this.fireNameChange(origName, name);
            this.fireDisplayNameChange(null, null);
        }
    }

    void notifyBookmarkChanged() {
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
    }

    public String getDisplayName() {
        return this.bookmarkInfo.getDisplayName();
    }

    public Action getPreferredAction() {
        return DEFAULT_ACTION;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(OpenAction.class), SystemAction.get(RenameAction.class), SystemAction.get(DeleteAction.class)};
    }

    public Image getIcon(int type) {
        if (bookmarkIcon == null) {
            bookmarkIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/editor/bookmarks/resources/bookmark_16.png", (boolean)false);
        }
        return bookmarkIcon;
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        if (type == OpenCookie.class) {
            OpenCookieImpl impl = new OpenCookieImpl();
            return (T)impl;
        }
        return (T)super.getCookie(type);
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        super.destroy();
        BookmarkUtils.removeBookmarkUnderLock(this.bookmarkInfo);
    }

    void openInEditor() {
        BookmarkUtils.postOpenEditor(this.bookmarkInfo);
    }

    public BookmarkInfo getBookmarkInfo() {
        return this.bookmarkInfo;
    }

    private final class OpenCookieImpl
    implements OpenCookie {
        private OpenCookieImpl() {
        }

        public void open() {
            BookmarkNode.this.openInEditor();
        }
    }
}

