/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.convertor;

import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.spi.project.ui.ProjectConvertor;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class ProjectConvertorAcceptor {
    static final String ATTR_PATTERN = "requiredPattern";
    static final String ATTR_DELEGATE = "delegate";
    private final Map<String, Object> params;
    private final Pattern requiredPattern;

    public ProjectConvertorAcceptor(@NonNull Map<String, Object> params) {
        Parameters.notNull((CharSequence)"params", params);
        this.params = params;
        String pattern = (String)params.get(ATTR_PATTERN);
        Parameters.notNull((CharSequence)ATTR_PATTERN, (Object)pattern);
        this.requiredPattern = Pattern.compile(pattern);
    }

    @CheckForNull
    ProjectConvertor.Result isProject(@NonNull FileObject folder) {
        for (FileObject fo : folder.getChildren()) {
            if (!this.requiredPattern.matcher(fo.getNameExt()).matches()) continue;
            return this.getProjectConvertor().isProject(folder);
        }
        return null;
    }

    @NonNull
    private ProjectConvertor getProjectConvertor() {
        Object convertor = this.params.get(ATTR_DELEGATE);
        if (!(convertor instanceof ProjectConvertor)) {
            throw new IllegalStateException(String.format("Invalid ProjectConvertor:  %s", convertor));
        }
        return (ProjectConvertor)convertor;
    }
}

