/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.installations.ui;

import java.awt.EventQueue;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.db.mysql.impl.Installation;
import org.netbeans.modules.db.mysql.impl.InstallationManager;
import org.netbeans.modules.db.mysql.impl.ServerNodeProvider;
import org.netbeans.modules.db.mysql.installations.ui.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.RequestProcessor;

public class SelectInstallationPanel
extends JPanel {
    private DialogDescriptor dialogDescriptor = null;
    private JList installationList;
    private JScrollPane scrollPane;

    private SelectInstallationPanel() {
        this.initComponents();
    }

    private void initList() {
        this.installationList.setListData(new Object[]{Bundle.MSG_Detecting_Wait()});
        this.installationList.setSelectionMode(0);
        this.installationList.setEnabled(false);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                final List<Installation> installations = InstallationManager.detectAllInstallations();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelectInstallationPanel.this.updateListForDetectedInstallations(installations);
                    }
                });
            }
        });
    }

    private void updateListForDetectedInstallations(List<Installation> insts) {
        if (insts.isEmpty()) {
            this.installationList.setListData(new Object[]{Bundle.MSG_NoInstallationFound()});
        } else {
            this.installationList.setListData(insts.toArray());
            this.installationList.setEnabled(true);
            this.dialogDescriptor.setValid(true);
        }
    }

    private void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        if (this.dialogDescriptor != null) {
            throw new IllegalStateException("DialogDescriptor has been already set.");
        }
        this.dialogDescriptor = dialogDescriptor;
        dialogDescriptor.setValid(false);
        this.initList();
    }

    public static void showSelectInstallationDialog() {
        Object val;
        SelectInstallationPanel sip = new SelectInstallationPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)sip, Bundle.selectInstalllation_title(), true, 2, DialogDescriptor.OK_OPTION, null);
        sip.setDialogDescriptor(dd);
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dd.getValue()) && (val = sip.installationList.getSelectedValue()) instanceof Installation) {
            ServerNodeProvider.getDefault().registerInstallation((Installation)val);
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.installationList = new JList();
        this.installationList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.scrollPane.setViewportView(this.installationList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 532, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 103, Short.MAX_VALUE).addContainerGap()));
    }
}

