/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import com.android.dx.io.instructions.DecodedInstruction;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.CallMthInterface;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;

public class InvokeNode
extends InsnNode
implements CallMthInterface {
    private final InvokeType type;
    private final MethodInfo mth;

    public InvokeNode(MethodInfo mth, DecodedInstruction insn, InvokeType type, boolean isRange, int resReg) {
        super(InsnType.INVOKE, mth.getArgsCount() + (type != InvokeType.STATIC ? 1 : 0));
        int k;
        this.mth = mth;
        this.type = type;
        if (resReg >= 0) {
            this.setResult(InsnArg.reg(resReg, mth.getReturnType()));
        }
        int n = k = isRange ? insn.getA() : 0;
        if (type != InvokeType.STATIC) {
            int r = isRange ? k : InsnUtils.getArg(insn, k);
            this.addReg(r, mth.getDeclClass().getType());
            ++k;
        }
        for (ArgType arg : mth.getArgumentsTypes()) {
            this.addReg(isRange ? k : InsnUtils.getArg(insn, k), arg);
            k += arg.getRegCount();
        }
    }

    private InvokeNode(MethodInfo mth, InvokeType invokeType, int argsCount) {
        super(InsnType.INVOKE, argsCount);
        this.mth = mth;
        this.type = invokeType;
    }

    public InvokeType getInvokeType() {
        return this.type;
    }

    @Override
    public MethodInfo getCallMth() {
        return this.mth;
    }

    @Override
    public InsnNode copy() {
        return this.copyCommonParams(new InvokeNode(this.mth, this.type, this.getArgsCount()));
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvokeNode) || !super.isSame(obj)) {
            return false;
        }
        InvokeNode other = (InvokeNode)obj;
        return this.type == other.type && this.mth.equals(other.mth);
    }

    @Override
    public String toString() {
        return InsnUtils.formatOffset(this.offset) + ": " + InsnUtils.insnTypeToString(this.insnType) + (this.getResult() == null ? "" : this.getResult() + " = ") + Utils.listToString(this.getArguments()) + " " + this.mth + " type: " + (Object)((Object)this.type);
    }
}

