#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tasty-rerun
version: 1.1.14
id: tasty-rerun-1.1.14-JS6i7yr2jqOAwY9WFOzo84
key: tasty-rerun-1.1.14-JS6i7yr2jqOAwY9WFOzo84
license: BSD-3-Clause
copyright: Oliver Charles (c) 2014
maintainer: ollie@ocharles.org.uk
author: Oliver Charles
homepage: http://github.com/ocharles/tasty-rerun
synopsis: Run tests by filtering the test tree depending on the result of previous test
          runs
description:
    This ingredient adds the ability to run tests by first filtering the test tree
    based on the result of a previous test run. For example, you can use this to
    run only those tests that failed in the last run, or to run only tests that
    have been added since tests were last ran.
    .
    This ingredient is specifically an ingredient *transformer* - given a list of
    '\''Tasty.Ingredient'\''s, '\''rerunningTests'\'' adds the ability for all of these
    ingredients to run against a filtered test tree. This transformer can be
    applied as follows:
    .
    > import Test.Tasty
    > import Test.Tasty.Runners
    >
    > main :: IO ()
    > main =
    >   defaultMainWithIngredients
    >     [ rerunningTests [ listingTests, consoleTestReporter ] ]
    >     tests
    >
    > tests :: TestTree
    > tests = undefined
    .
    This ingredient adds three command line parameters:
    .
    [@--rerun-update@] If specified the results of this test run will be saved to
    the log file at @--rerun-log-file@. If the ingredient does not execute tests
    (for example, @--list-tests@ is used) then the log file will not be
    updated. This option is not enabled by default.  This option does not require
    a value.
    .
    [@--rerun-log-file@] The path to the log file to read previous test
    information from, and where to write new information to (if @--rerun-update@
    is specified). This option defaults to @.tasty-rerun-log@.
    .
    [@--rerun-filter@] Which filters to apply to the '\''Tasty.TestTree'\'' based on
    previous test runs. The value of this option is a comma separated list of the
    following options:
    .
    * @failures@: Only run tests that failed on the previous run.
    .
    * @exceptions@: Only run tests that threw an exception on the previous run.
    .
    * @new@: Only run tests that are new since the previous test run.
    .
    * @successful@: Only run tests that were successful in the previous run.
    .
    Multiple options can be combined and will be taken under disjunction - so
    @--rerun-filter=failures,exceptions@ will run only tests that failed *or*
    threw an exception on the last run.
    .
    Defaults to all filters, which means all tests will be ran.
category: Testing
abi: f02a81d6683d69e1b2cdf29dda67df57
exposed: True
exposed-modules:
    Test.Tasty.Ingredients.Rerun
import-dirs: /usr/lib/ghc-8.6.4/site-local/tasty-rerun-1.1.14
library-dirs: /usr/lib/ghc-8.6.4/site-local/tasty-rerun-1.1.14
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.4/tasty-rerun-1.1.14
hs-libraries: HStasty-rerun-1.1.14-JS6i7yr2jqOAwY9WFOzo84
depends:
    base-4.12.0.0 containers-0.6.0.1 mtl-2.2.2
    optparse-applicative-0.14.3.0-6K67dnjFISmWjyySSwRel
    reducers-3.12.3-HkB9ibLWxlb8ctZV1Vw8JL
    split-0.2.3.3-DmDMlgWSMW26OczFIiZ5Gr stm-2.5.0.0
    tagged-0.8.6-AoE7RQX12AwJxLvAxGYxtP
    tasty-1.2-7U7pobVPBj2AeWtnevypzS transformers-0.5.6.2
haddock-interfaces: /usr/share/doc/haskell-tasty-rerun/html/tasty-rerun.haddock
haddock-html: /usr/share/doc/haskell-tasty-rerun/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

