/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.InciteTradeItem;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTradeItem;

public final class NegotiationDialog
extends FreeColDialog<DiplomaticTrade> {
    private static final Logger logger = Logger.getLogger(NegotiationDialog.class.getName());
    private static final int HUGE_DEMAND = 100000;
    private static final String ADD = "add";
    private static final String CLEAR = "clear";
    private final Player otherPlayer;
    private final DiplomaticTrade agreement;
    private final StringTemplate comment;
    private StanceTradeItemPanel stancePanel;
    private GoldTradeItemPanel goldOfferPanel;
    private GoldTradeItemPanel goldDemandPanel;
    private ColonyTradeItemPanel colonyOfferPanel;
    private ColonyTradeItemPanel colonyDemandPanel;
    private GoodsTradeItemPanel goodsOfferPanel;
    private GoodsTradeItemPanel goodsDemandPanel;
    private InciteTradeItemPanel inciteOfferPanel;
    private InciteTradeItemPanel inciteDemandPanel;
    private UnitTradeItemPanel unitOfferPanel;
    private UnitTradeItemPanel unitDemandPanel;
    private JPanel summary;
    private StringTemplate demand;
    private StringTemplate offer;
    private String exchangeMessage;
    private ChoiceItem<DiplomaticTrade> send = null;
    private ChoiceItem<DiplomaticTrade> accept = null;

    public NegotiationDialog(FreeColClient freeColClient, JFrame frame, FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement, StringTemplate comment) {
        super(freeColClient, frame);
        String str;
        Player player = this.getMyPlayer();
        Unit ourUnit = our instanceof Unit ? (Unit)our : null;
        Colony ourColony = our instanceof Colony ? (Colony)our : null;
        Unit otherUnit = other instanceof Unit ? (Unit)other : null;
        Colony otherColony = other instanceof Colony ? (Colony)other : null;
        this.otherPlayer = ((Ownable)((Object)other)).getOwner();
        this.agreement = agreement;
        this.comment = comment;
        StringTemplate nation = player.getNationLabel();
        StringTemplate otherNation = this.otherPlayer.getNationLabel();
        this.demand = StringTemplate.template("negotiationDialog.demand").addStringTemplate("%nation%", nation).addStringTemplate("%otherNation%", otherNation);
        this.offer = StringTemplate.template("negotiationDialog.offer").addStringTemplate("%nation%", nation).addStringTemplate("%otherNation%", otherNation);
        this.exchangeMessage = Messages.message("negotiationDialog.exchange");
        NationSummary ns = this.igc().getNationSummary(this.otherPlayer);
        int gold = ns == null || ns.getGold() == Integer.MIN_VALUE ? 100000 : ns.getGold();
        this.goldDemandPanel = new GoldTradeItemPanel(this.otherPlayer, gold);
        gold = player.getGold() == Integer.MIN_VALUE ? 100000 : player.getGold();
        this.goldOfferPanel = new GoldTradeItemPanel(player, gold);
        StringTemplate tutorial = null;
        DiplomaticTrade.TradeContext context = agreement.getContext();
        switch (context) {
            case CONTACT: {
                if (freeColClient.tutorialMode()) {
                    tutorial = StringTemplate.key("negotiationDialog.contact.tutorial");
                }
                this.stancePanel = new StanceTradeItemPanel(player, this.otherPlayer);
                this.inciteOfferPanel = new InciteTradeItemPanel(player, this.otherPlayer);
                this.inciteDemandPanel = new InciteTradeItemPanel(this.otherPlayer, player);
                break;
            }
            case DIPLOMATIC: {
                this.stancePanel = new StanceTradeItemPanel(player, this.otherPlayer);
                this.colonyDemandPanel = new ColonyTradeItemPanel(this.otherPlayer);
                this.colonyOfferPanel = new ColonyTradeItemPanel(player);
                this.goodsOfferPanel = null;
                this.goodsDemandPanel = null;
                this.inciteOfferPanel = new InciteTradeItemPanel(player, this.otherPlayer);
                this.inciteDemandPanel = new InciteTradeItemPanel(this.otherPlayer, player);
                this.unitDemandPanel = null;
                this.unitOfferPanel = null;
                break;
            }
            case TRADE: {
                this.stancePanel = null;
                this.colonyOfferPanel = null;
                this.colonyDemandPanel = null;
                GoodsLocation gl = otherUnit != null ? otherUnit : otherColony;
                List<Goods> goods = this.getAnyGoods(gl);
                this.goodsDemandPanel = new GoodsTradeItemPanel(this.otherPlayer, goods);
                gl = ourUnit != null ? ourUnit : ourColony;
                goods = ourUnit != null ? ourUnit.getGoodsList() : ourColony.getCompactGoods();
                for (Goods g : goods) {
                    if (g.getAmount() > 100) {
                        g.setAmount(100);
                    }
                    g.setLocation(gl);
                }
                this.goodsOfferPanel = new GoodsTradeItemPanel(player, goods);
                this.inciteDemandPanel = null;
                this.inciteOfferPanel = null;
                this.unitDemandPanel = new UnitTradeItemPanel(this.otherPlayer, this.getUnitUnitList(null));
                this.unitOfferPanel = new UnitTradeItemPanel(player, ourUnit != null ? this.getUnitUnitList(ourUnit) : ourColony.getUnitList());
                break;
            }
            case TRIBUTE: {
                this.stancePanel = new StanceTradeItemPanel(player, this.otherPlayer);
                this.colonyOfferPanel = null;
                this.colonyDemandPanel = null;
                this.goodsOfferPanel = null;
                this.goodsDemandPanel = null;
                this.inciteOfferPanel = new InciteTradeItemPanel(player, this.otherPlayer);
                this.inciteDemandPanel = new InciteTradeItemPanel(this.otherPlayer, player);
                this.unitDemandPanel = null;
                this.unitOfferPanel = null;
                break;
            }
            default: {
                throw new IllegalStateException("Bogus trade context: " + (Object)((Object)context));
            }
        }
        this.summary = new MigPanel(new MigLayout("wrap 2", "[20px:n:n][]"));
        this.summary.setOpaque(false);
        this.summary.add((Component)Utility.localizedTextArea(comment), "center, span 2");
        MigPanel panel = new MigPanel(new MigLayout("wrap 3", "[30%|40%|30%]", ""));
        panel.add((Component)Utility.localizedHeader("negotiationDialog.title." + agreement.getContext().getKey(), false), "span 3, center");
        JTextArea labelDemandMessage = Utility.localizedTextArea(this.demand);
        Font font = FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, 1, this.getImageLibrary().getScaleFactor());
        labelDemandMessage.setFont(font);
        panel.add(labelDemandMessage);
        JTextArea blank = new JTextArea(" ");
        blank.setVisible(false);
        panel.add((Component)blank, "");
        JTextArea labelOfferMessage = Utility.localizedTextArea(this.offer);
        labelOfferMessage.setFont(font);
        panel.add(labelOfferMessage);
        panel.add(this.goldDemandPanel);
        MigPanel centerPanel = new MigPanel();
        centerPanel.setLayout(new MigLayout("wrap 1"));
        if (tutorial != null) {
            JTextArea tutArea = Utility.localizedTextArea(tutorial, 30);
            centerPanel.add((Component)tutArea, "center");
        }
        centerPanel.add((Component)this.summary, "top");
        panel.add((Component)centerPanel, "spany, top");
        panel.add(this.goldOfferPanel);
        if (this.colonyDemandPanel != null) {
            panel.add(this.colonyDemandPanel);
            panel.add(this.colonyOfferPanel);
        }
        if (this.stancePanel != null) {
            panel.add((Component)this.stancePanel, "skip");
        }
        if (this.goodsDemandPanel != null) {
            panel.add(this.goodsDemandPanel);
            panel.add(this.goodsOfferPanel);
        }
        if (this.inciteDemandPanel != null) {
            panel.add(this.inciteDemandPanel);
            panel.add(this.inciteOfferPanel);
        }
        if (this.unitDemandPanel != null) {
            panel.add(this.unitDemandPanel);
            panel.add(this.unitOfferPanel);
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            panel.add(new JLabel("Version = " + agreement.getVersion()));
        }
        panel.setPreferredSize(panel.getPreferredSize());
        Object bogus = null;
        List c = NegotiationDialog.choices();
        if (agreement.getVersion() > 0) {
            str = Messages.message("negotiationDialog.accept");
            this.accept = new ChoiceItem<Object>(str, bogus);
            c.add(this.accept);
        }
        str = Messages.message("negotiationDialog.send");
        this.send = new ChoiceItem<Object>(str, bogus).okOption();
        c.add(this.send);
        if (agreement.getVersion() > 0 || context != DiplomaticTrade.TradeContext.CONTACT) {
            str = Messages.message("negotiationDialog.cancel");
            c.add(new ChoiceItem<Object>(str, bogus).cancelOption().defaultOption());
        }
        this.updateDialog();
        ImageIcon icon = new ImageIcon(otherColony != null ? this.getImageLibrary().getSettlementImage(otherColony) : this.getImageLibrary().getUnitImage(otherUnit));
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, true, panel, icon, c);
    }

    @Override
    public DiplomaticTrade getResponse() {
        Object value = this.getValue();
        DiplomaticTrade.TradeStatus s = value == null ? DiplomaticTrade.TradeStatus.REJECT_TRADE : (value == this.accept ? DiplomaticTrade.TradeStatus.ACCEPT_TRADE : (value == this.send ? DiplomaticTrade.TradeStatus.PROPOSE_TRADE : DiplomaticTrade.TradeStatus.REJECT_TRADE));
        this.agreement.setStatus(s);
        return this.agreement;
    }

    private List<Goods> getAnyGoods(GoodsLocation gl) {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (GoodsType type : this.getSpecification().getStorableGoodsTypeList()) {
            Goods g = new Goods(this.getGame(), null, type, 100);
            g.setLocation(gl);
            goodsList.add(g);
        }
        return goodsList;
    }

    private List<Unit> getUnitUnitList(Unit unit) {
        ArrayList<Unit> ul = new ArrayList<Unit>();
        if (unit != null) {
            if (unit.isCarrier()) {
                ul.addAll(unit.getUnitList());
            } else if (unit.isOnCarrier()) {
                ul.addAll(unit.getCarrier().getUnitList());
            } else {
                ul.add(unit);
            }
        }
        return ul;
    }

    private void updateDialog() {
        if (this.goldOfferPanel != null) {
            this.goldOfferPanel.update(this.agreement);
        }
        if (this.stancePanel != null) {
            this.stancePanel.update(this.agreement);
        }
        if (this.colonyOfferPanel != null) {
            this.colonyOfferPanel.update(this.agreement);
        }
        if (this.colonyDemandPanel != null) {
            this.colonyDemandPanel.update(this.agreement);
        }
        if (this.goodsOfferPanel != null) {
            this.goodsOfferPanel.update(this.agreement);
        }
        if (this.goodsDemandPanel != null) {
            this.goodsDemandPanel.update(this.agreement);
        }
        if (this.inciteOfferPanel != null) {
            this.inciteOfferPanel.update(this.agreement);
        }
        if (this.inciteDemandPanel != null) {
            this.inciteDemandPanel.update(this.agreement);
        }
        if (this.unitOfferPanel != null) {
            this.unitOfferPanel.update(this.agreement);
        }
        if (this.unitDemandPanel != null) {
            this.unitDemandPanel.update(this.agreement);
        }
        this.updateSummary();
    }

    private JButton getTradeItemButton(TradeItem item) {
        JButton button = new JButton(new RemoveAction(item));
        button.setText(Messages.message(item.getLabel()));
        button.setMargin(Utility.EMPTY_MARGIN);
        button.setOpaque(false);
        button.setForeground(Utility.LINK_COLOR);
        button.setBorder(Utility.blankBorder(0, 0, 0, 0));
        button.setCursor(Cursor.getPredefinedCursor(12));
        return button;
    }

    private void updateSummary() {
        List<TradeItem> demands;
        Player player = this.getMyPlayer();
        this.summary.removeAll();
        this.summary.add((Component)Utility.localizedTextArea(this.comment), "center, span 2");
        List<TradeItem> offers = this.agreement.getItemsGivenBy(player);
        if (!offers.isEmpty()) {
            this.summary.add((Component)Utility.localizedLabel(this.offer), "span");
            for (TradeItem item : offers) {
                this.summary.add((Component)this.getTradeItemButton(item), "skip");
            }
        }
        if (!(demands = this.agreement.getItemsGivenBy(this.otherPlayer)).isEmpty()) {
            if (offers.isEmpty()) {
                this.summary.add((Component)Utility.localizedLabel(this.demand), "span");
            } else {
                this.summary.add((Component)new JLabel(this.exchangeMessage), "newline 20, span");
            }
            for (TradeItem item : demands) {
                this.summary.add((Component)this.getTradeItemButton(item), "skip");
            }
        }
    }

    public void removeTradeItems(Class<? extends TradeItem> itemClass) {
        this.agreement.removeType(itemClass);
        this.updateDialog();
    }

    public void addColonyTradeItem(Player source, Colony colony) {
        Player player = this.getMyPlayer();
        Player destination = source == this.otherPlayer ? player : this.otherPlayer;
        this.agreement.add(new ColonyTradeItem(this.getGame(), source, destination, colony));
        this.updateDialog();
    }

    public void addGoldTradeItem(Player source, int amount) {
        Player player = this.getMyPlayer();
        Player destination = source == this.otherPlayer ? player : this.otherPlayer;
        this.agreement.add(new GoldTradeItem(this.getGame(), source, destination, amount));
        this.updateDialog();
    }

    public void addGoodsTradeItem(Player source, Goods goods) {
        Player player = this.getMyPlayer();
        Player destination = source == this.otherPlayer ? player : this.otherPlayer;
        this.agreement.add(new GoodsTradeItem(this.getGame(), source, destination, goods));
        this.updateDialog();
    }

    public void addInciteTradeItem(Player source, Player victim) {
        Player player = this.getMyPlayer();
        Player destination = source == this.otherPlayer ? player : this.otherPlayer;
        this.agreement.add(new InciteTradeItem(this.getGame(), source, destination, victim));
        this.updateDialog();
    }

    public void addStanceTradeItem(Stance stance) {
        Player player = this.getMyPlayer();
        this.agreement.add(new StanceTradeItem(this.getGame(), this.otherPlayer, player, stance));
        this.updateDialog();
    }

    public void addUnitTradeItem(Player source, Unit unit) {
        Player player = this.getMyPlayer();
        Player destination = source == this.otherPlayer ? player : this.otherPlayer;
        this.agreement.add(new UnitTradeItem(this.getGame(), source, destination, unit));
        this.updateDialog();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.stancePanel = null;
        this.goldDemandPanel = null;
        this.goldOfferPanel = null;
        this.colonyDemandPanel = null;
        this.colonyOfferPanel = null;
        this.goodsDemandPanel = null;
        this.goodsOfferPanel = null;
        this.inciteDemandPanel = null;
        this.inciteOfferPanel = null;
        this.unitDemandPanel = null;
        this.unitOfferPanel = null;
        this.summary = null;
        this.offer = null;
        this.demand = null;
        this.exchangeMessage = null;
    }

    private class UnitTradeItemPanel
    extends JPanel
    implements ActionListener {
        private final Player source;
        private final JComboBox<Unit> unitBox;
        private final JButton clearButton;
        private final JButton addButton;
        private final JLabel label;
        private final List<Unit> allUnits;

        public UnitTradeItemPanel(Player source, List<Unit> allUnits) {
            this.source = source;
            this.unitBox = new JComboBox(new DefaultComboBoxModel());
            this.unitBox.setRenderer(new UnitBoxRenderer());
            this.clearButton = Utility.localizedButton("negotiationDialog.clear");
            this.clearButton.addActionListener(this);
            this.clearButton.setActionCommand(NegotiationDialog.CLEAR);
            this.addButton = Utility.localizedButton("negotiationDialog.add");
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand(NegotiationDialog.ADD);
            this.label = Utility.localizedLabel(Messages.nameKey("model.tradeItem.unit"));
            this.allUnits = allUnits;
            this.setLayout(new MigLayout("wrap 1", "", ""));
            this.setBorder(Utility.SIMPLE_LINE_BORDER);
            this.add(this.label);
            this.add(this.unitBox);
            this.add((Component)this.clearButton, "split 2");
            this.add(this.addButton);
            this.setSize(this.getPreferredSize());
        }

        private void update(DiplomaticTrade dt) {
            ActionListener[] listeners;
            for (ActionListener al : listeners = this.unitBox.getActionListeners()) {
                this.unitBox.removeActionListener(al);
            }
            ArrayList<Unit> available = new ArrayList<Unit>(this.allUnits);
            for (Unit u : dt.getUnitsGivenBy(this.source)) {
                if (available.contains(u)) {
                    available.remove(u);
                    continue;
                }
                this.allUnits.add(u);
            }
            this.unitBox.removeAllItems();
            for (Unit u : available) {
                this.unitBox.addItem(u);
            }
            boolean enable = !available.isEmpty();
            this.label.setEnabled(enable);
            this.clearButton.setEnabled(!enable);
            this.addButton.setEnabled(enable);
            this.unitBox.setEnabled(enable);
            for (ActionListener al : listeners) {
                this.unitBox.addActionListener(al);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (null != command) {
                switch (command) {
                    case "add": {
                        NegotiationDialog.this.addUnitTradeItem(this.source, (Unit)this.unitBox.getSelectedItem());
                        break;
                    }
                    case "clear": {
                        NegotiationDialog.this.removeTradeItems(UnitTradeItem.class);
                        break;
                    }
                    default: {
                        logger.warning("Bad command: " + command);
                    }
                }
            }
        }

        private class UnitBoxRenderer
        extends JLabel
        implements ListCellRenderer<Unit> {
            private UnitBoxRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends Unit> list, Unit value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(value == null ? "" : value.getDescription());
                return this;
            }
        }
    }

    public class StanceTradeItemPanel
    extends JPanel
    implements ActionListener {
        private final Player source;
        private final Player target;
        private final JComboBox<Stance> stanceBox;
        private final JButton clearButton;
        private final JButton addButton;

        public StanceTradeItemPanel(Player source, Player target) {
            this.source = source;
            this.target = target;
            this.stanceBox = new JComboBox(new DefaultComboBoxModel());
            this.stanceBox.setRenderer(new StanceBoxRenderer());
            this.clearButton = Utility.localizedButton("negotiationDialog.clear");
            this.clearButton.addActionListener(this);
            this.clearButton.setActionCommand(NegotiationDialog.CLEAR);
            this.addButton = Utility.localizedButton("negotiationDialog.add");
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand(NegotiationDialog.ADD);
            this.setBorder(Utility.SIMPLE_LINE_BORDER);
            this.setLayout(new MigLayout("wrap 1", "", ""));
            this.add(Utility.localizedLabel(Messages.nameKey("model.tradeItem.stance")));
            this.add(this.stanceBox);
            this.add((Component)this.clearButton, "split 2");
            this.add(this.addButton);
        }

        private void setSelectedValue(Stance stance) {
            for (int i = 0; i < this.stanceBox.getItemCount(); ++i) {
                if (this.stanceBox.getItemAt(i) != stance) continue;
                this.stanceBox.setSelectedItem(i);
            }
        }

        public void update(DiplomaticTrade dt) {
            Stance select;
            this.stanceBox.removeAllItems();
            Stance stance = this.source.getStance(this.target);
            if (stance != Stance.WAR) {
                this.stanceBox.addItem(Stance.WAR);
            } else {
                this.stanceBox.addItem(Stance.CEASE_FIRE);
            }
            if (stance != Stance.PEACE && stance != Stance.UNCONTACTED) {
                this.stanceBox.addItem(Stance.PEACE);
            }
            if (stance == Stance.PEACE) {
                this.stanceBox.addItem(Stance.ALLIANCE);
            }
            if ((select = dt.getStance()) != null) {
                this.setSelectedValue(select);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (null != command) {
                switch (command) {
                    case "add": {
                        Stance stance = (Stance)this.stanceBox.getSelectedItem();
                        NegotiationDialog.this.addStanceTradeItem(stance);
                        break;
                    }
                    case "clear": {
                        NegotiationDialog.this.removeTradeItems(StanceTradeItem.class);
                        break;
                    }
                    default: {
                        logger.warning("Bad command: " + command);
                    }
                }
            }
        }

        private class StanceBoxRenderer
        extends JLabel
        implements ListCellRenderer<Stance> {
            private StanceBoxRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends Stance> list, Stance value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(value == null ? "" : Messages.getName(value));
                return this;
            }
        }
    }

    private class InciteTradeItemPanel
    extends JPanel
    implements ActionListener {
        private final Player source;
        private final Player other;
        private final JComboBox<Player> victimBox;
        private final JLabel label;
        private final JButton clearButton;
        private final JButton addButton;
        private final List<Player> available = new ArrayList<Player>();

        public InciteTradeItemPanel(Player source, Player other) {
            this.source = source;
            this.other = other;
            this.victimBox = new JComboBox(new DefaultComboBoxModel());
            this.victimBox.setRenderer(new InciteBoxRenderer());
            this.clearButton = Utility.localizedButton("negotiationDialog.clear");
            this.clearButton.addActionListener(this);
            this.clearButton.setActionCommand(NegotiationDialog.CLEAR);
            this.addButton = Utility.localizedButton("negotiationDialog.add");
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand(NegotiationDialog.ADD);
            this.label = Utility.localizedLabel(Messages.nameKey("model.tradeItem.incite"));
            this.setBorder(Utility.SIMPLE_LINE_BORDER);
            this.setLayout(new MigLayout("wrap 1", "", ""));
            this.available.clear();
            for (Player p : NegotiationDialog.this.getGame().getLivePlayers(this.source)) {
                if (p == this.other || this.source.getStance(p) == Stance.ALLIANCE || this.source.getStance(p) == Stance.WAR) continue;
                this.available.add(p);
            }
            this.add(this.label);
            this.add(this.victimBox);
            this.add((Component)this.clearButton, "split 2");
            this.add(this.addButton);
            this.setSize(this.getPreferredSize());
        }

        public void update(DiplomaticTrade dt) {
            ActionListener[] listeners = this.victimBox.getActionListeners();
            for (ActionListener al : listeners) {
                this.victimBox.removeActionListener(al);
            }
            this.victimBox.removeAllItems();
            for (Player p : this.available) {
                this.victimBox.addItem(p);
            }
            boolean enable = !this.available.isEmpty();
            this.label.setEnabled(enable);
            this.clearButton.setEnabled(!enable);
            this.addButton.setEnabled(enable);
            this.victimBox.setEnabled(enable);
            for (ActionListener al : listeners) {
                this.victimBox.addActionListener(al);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (null != command) {
                switch (command) {
                    case "add": {
                        Player victim = (Player)this.victimBox.getSelectedItem();
                        if (victim == null) break;
                        NegotiationDialog.this.addInciteTradeItem(this.source, victim);
                        break;
                    }
                    case "clear": {
                        NegotiationDialog.this.removeTradeItems(InciteTradeItem.class);
                        break;
                    }
                    default: {
                        logger.warning("Bad command: " + command);
                    }
                }
            }
        }

        private class InciteBoxRenderer
        extends JLabel
        implements ListCellRenderer<Player> {
            private InciteBoxRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends Player> list, Player value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(value == null ? "" : Messages.message(value.getNationLabel()));
                return this;
            }
        }
    }

    private class GoodsTradeItemPanel
    extends JPanel
    implements ActionListener {
        private final Player source;
        private final JComboBox<Goods> goodsBox;
        private final JButton clearButton;
        private final JButton addButton;
        private final JLabel label;
        private final List<Goods> allGoods;

        public GoodsTradeItemPanel(Player source, List<Goods> allGoods) {
            this.source = source;
            this.goodsBox = new JComboBox(new DefaultComboBoxModel());
            this.goodsBox.setRenderer(new GoodsBoxRenderer());
            this.clearButton = Utility.localizedButton("negotiationDialog.clear");
            this.clearButton.addActionListener(this);
            this.clearButton.setActionCommand(NegotiationDialog.CLEAR);
            this.addButton = Utility.localizedButton("negotiationDialog.add");
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand(NegotiationDialog.ADD);
            this.label = Utility.localizedLabel(Messages.nameKey("model.tradeItem.goods"));
            this.allGoods = allGoods;
            this.setLayout(new MigLayout("wrap 1", "", ""));
            this.setBorder(Utility.SIMPLE_LINE_BORDER);
            this.add(this.label);
            this.add(this.goodsBox);
            this.add((Component)this.clearButton, "split 2");
            this.add(this.addButton);
            this.setSize(this.getPreferredSize());
        }

        public void update(DiplomaticTrade dt) {
            ActionListener[] listeners;
            for (ActionListener al : listeners = this.goodsBox.getActionListeners()) {
                this.goodsBox.removeActionListener(al);
            }
            ArrayList<Goods> available = new ArrayList<Goods>(this.allGoods);
            block1: for (Goods goods : dt.getGoodsGivenBy(this.source)) {
                for (int i = 0; i < available.size(); ++i) {
                    Goods g = (Goods)available.get(i);
                    if (g.getType() != goods.getType()) continue;
                    if (g.getAmount() <= goods.getAmount()) {
                        available.remove(i);
                        continue block1;
                    }
                    g.setAmount(g.getAmount() - goods.getAmount());
                    continue block1;
                }
            }
            this.goodsBox.removeAllItems();
            for (Goods g : available) {
                this.goodsBox.addItem(g);
            }
            boolean enable = !available.isEmpty();
            this.label.setEnabled(enable);
            this.clearButton.setEnabled(!enable);
            this.addButton.setEnabled(enable);
            this.goodsBox.setEnabled(enable);
            for (ActionListener al : listeners) {
                this.goodsBox.addActionListener(al);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (null != command) {
                switch (command) {
                    case "add": {
                        NegotiationDialog.this.addGoodsTradeItem(this.source, (Goods)this.goodsBox.getSelectedItem());
                        break;
                    }
                    case "clear": {
                        NegotiationDialog.this.removeTradeItems(GoodsTradeItem.class);
                        break;
                    }
                    default: {
                        logger.warning("Bad command: " + command);
                    }
                }
            }
        }

        private class GoodsBoxRenderer
        extends JLabel
        implements ListCellRenderer<Goods> {
            private GoodsBoxRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends Goods> list, Goods value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(value == null ? "" : Messages.message(value.getLabel(true)));
                return this;
            }
        }
    }

    private class GoldTradeItemPanel
    extends JPanel
    implements ActionListener {
        private final Player source;
        private final JSpinner spinner;

        public GoldTradeItemPanel(Player source, int gold) {
            this.source = source;
            this.spinner = new JSpinner(new SpinnerNumberModel(0, 0, gold, 1));
            JButton clearButton = Utility.localizedButton("negotiationDialog.clear");
            clearButton.addActionListener(this);
            clearButton.setActionCommand(NegotiationDialog.CLEAR);
            JButton addButton = Utility.localizedButton("negotiationDialog.add");
            addButton.addActionListener(this);
            addButton.setActionCommand(NegotiationDialog.ADD);
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setColumns(5);
            this.setBorder(Utility.SIMPLE_LINE_BORDER);
            this.setLayout(new MigLayout("wrap 1", "", ""));
            this.add(Utility.localizedLabel(Messages.getName("model.tradeItem.gold")));
            this.add(Utility.localizedLabel(StringTemplate.template("negotiationDialog.goldAvailable").addAmount("%amount%", gold)));
            this.add(this.spinner);
            this.add((Component)clearButton, "split 2");
            this.add(addButton);
            this.setSize(this.getPreferredSize());
        }

        public void update(DiplomaticTrade dt) {
            int gold = dt.getGoldGivenBy(this.source);
            if (gold >= 0) {
                SpinnerNumberModel model = (SpinnerNumberModel)this.spinner.getModel();
                model.setValue(gold);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (null != command) {
                switch (command) {
                    case "add": {
                        int amount = (Integer)this.spinner.getValue();
                        NegotiationDialog.this.addGoldTradeItem(this.source, amount);
                        break;
                    }
                    case "clear": {
                        NegotiationDialog.this.removeTradeItems(GoldTradeItem.class);
                        break;
                    }
                    default: {
                        logger.warning("Bad command: " + command);
                    }
                }
            }
        }
    }

    private class ColonyTradeItemPanel
    extends JPanel
    implements ActionListener {
        private final Player source;
        private final JComboBox<Colony> colonyBox;
        private final JButton clearButton;
        private final JButton addButton;
        private final JLabel label;
        private final List<Colony> allColonies;

        public ColonyTradeItemPanel(Player source) {
            this.source = source;
            this.colonyBox = new JComboBox();
            this.clearButton = Utility.localizedButton("negotiationDialog.clear");
            this.clearButton.addActionListener(this);
            this.clearButton.setActionCommand(NegotiationDialog.CLEAR);
            this.addButton = Utility.localizedButton("negotiationDialog.add");
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand(NegotiationDialog.ADD);
            this.label = Utility.localizedLabel(Messages.getName("model.tradeItem.colony"));
            this.allColonies = source.getColonies();
            this.setLayout(new MigLayout("wrap 1", "", ""));
            this.setBorder(Utility.SIMPLE_LINE_BORDER);
            this.add(this.label);
            this.add(this.colonyBox);
            this.add((Component)this.clearButton, "split 2");
            this.add(this.addButton);
            this.setSize(this.getPreferredSize());
        }

        private void update(DiplomaticTrade dt) {
            ActionListener[] listeners;
            if (!this.source.isEuropean()) {
                return;
            }
            for (ActionListener al : listeners = this.colonyBox.getActionListeners()) {
                this.colonyBox.removeActionListener(al);
            }
            ArrayList<Colony> available = new ArrayList<Colony>(this.allColonies);
            for (Colony c : dt.getColoniesGivenBy(this.source)) {
                if (available.contains(c)) {
                    available.remove(c);
                    continue;
                }
                this.allColonies.add(c);
            }
            Collections.sort(available, NegotiationDialog.this.getFreeColClient().getClientOptions().getColonyComparator());
            this.colonyBox.removeAllItems();
            for (Colony c : available) {
                this.colonyBox.addItem(c);
            }
            boolean enable = !available.isEmpty();
            this.clearButton.setEnabled(!enable);
            this.addButton.setEnabled(enable);
            this.colonyBox.setEnabled(enable);
            this.label.setEnabled(enable);
            for (ActionListener al : listeners) {
                this.colonyBox.addActionListener(al);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (null != command) {
                switch (command) {
                    case "add": {
                        NegotiationDialog.this.addColonyTradeItem(this.source, (Colony)this.colonyBox.getSelectedItem());
                        break;
                    }
                    case "clear": {
                        NegotiationDialog.this.removeTradeItems(ColonyTradeItem.class);
                        break;
                    }
                    default: {
                        logger.warning("Bad command: " + command);
                    }
                }
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private final TradeItem item;

        public RemoveAction(TradeItem item) {
            this.item = item;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            NegotiationDialog.this.agreement.remove(this.item);
            NegotiationDialog.this.updateDialog();
        }
    }
}

