/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.StandardXYZSolid;
import org.apache.lucene.spatial3d.geom.XYZBounds;
import org.apache.lucene.spatial3d.geom.XYZSolid;
import org.apache.lucene.spatial3d.geom.XYdZSolid;
import org.apache.lucene.spatial3d.geom.XdYZSolid;
import org.apache.lucene.spatial3d.geom.XdYdZSolid;
import org.apache.lucene.spatial3d.geom.dXYZSolid;
import org.apache.lucene.spatial3d.geom.dXYdZSolid;
import org.apache.lucene.spatial3d.geom.dXdYZSolid;
import org.apache.lucene.spatial3d.geom.dXdYdZSolid;

public class XYZSolidFactory {
    private XYZSolidFactory() {
    }

    public static XYZSolid makeXYZSolid(PlanetModel planetModel, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        if (Math.abs(maxX - minX) < 1.0E-12) {
            if (Math.abs(maxY - minY) < 1.0E-12) {
                if (Math.abs(maxZ - minZ) < 1.0E-12) {
                    return new dXdYdZSolid(planetModel, (minX + maxX) * 0.5, (minY + maxY) * 0.5, minZ);
                }
                return new dXdYZSolid(planetModel, (minX + maxX) * 0.5, (minY + maxY) * 0.5, minZ, maxZ);
            }
            if (Math.abs(maxZ - minZ) < 1.0E-12) {
                return new dXYdZSolid(planetModel, (minX + maxX) * 0.5, minY, maxY, (minZ + maxZ) * 0.5);
            }
            return new dXYZSolid(planetModel, (minX + maxX) * 0.5, minY, maxY, minZ, maxZ);
        }
        if (Math.abs(maxY - minY) < 1.0E-12) {
            if (Math.abs(maxZ - minZ) < 1.0E-12) {
                return new XdYdZSolid(planetModel, minX, maxX, (minY + maxY) * 0.5, (minZ + maxZ) * 0.5);
            }
            return new XdYZSolid(planetModel, minX, maxX, (minY + maxY) * 0.5, minZ, maxZ);
        }
        if (Math.abs(maxZ - minZ) < 1.0E-12) {
            return new XYdZSolid(planetModel, minX, maxX, minY, maxY, (minZ + maxZ) * 0.5);
        }
        return new StandardXYZSolid(planetModel, minX, maxX, minY, maxY, minZ, maxZ);
    }

    public static XYZSolid makeXYZSolid(PlanetModel planetModel, XYZBounds bounds) {
        return XYZSolidFactory.makeXYZSolid(planetModel, bounds.getMinimumX(), bounds.getMaximumX(), bounds.getMinimumY(), bounds.getMaximumY(), bounds.getMinimumZ(), bounds.getMaximumZ());
    }
}

