/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.office.handlers;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.data.office.export.DataExporterXLSX;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseProducerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainerOptions;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.utils.CommonUtils;

public class OpenSpreadsheetHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ResultSetDataContainer dataContainer;
        final IResultSetController resultSet = ResultSetHandlerMain.getActiveResultSet((IWorkbenchPart)HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet == null) {
            DBeaverUI.getInstance().showError("Open Excel", "No active results viewer");
            return null;
        }
        ResultSetDataContainerOptions options = new ResultSetDataContainerOptions();
        IResultSetSelection rsSelection = resultSet.getSelection();
        List rsSelectedRows = rsSelection.getSelectedRows();
        if (rsSelectedRows.size() > 1) {
            ArrayList<Long> selectedRows = new ArrayList<Long>();
            for (ResultSetRow selectedRow : rsSelectedRows) {
                selectedRows.add(Long.valueOf(selectedRow.getRowNumber()));
            }
            ArrayList<String> selectedAttributes = new ArrayList<String>();
            for (DBDAttributeBinding attributeBinding : rsSelection.getSelectedAttributes()) {
                selectedAttributes.add(attributeBinding.getName());
            }
            options.setSelectedRows(selectedRows);
            options.setSelectedColumns(selectedAttributes);
        }
        if ((dataContainer = new ResultSetDataContainer(resultSet.getDataContainer(), resultSet.getModel(), options)).getDataSource() == null) {
            DBeaverUI.getInstance().showError("Open Excel", ModelMessages.error_not_connected_to_database);
            return null;
        }
        AbstractJob exportJob = new AbstractJob("Open Excel"){
            {
                super($anonymous0);
                this.setUser(true);
                this.setSystem(false);
            }

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    File tempDir = DBWorkbench.getPlatform().getTempFolder(monitor, "office-files");
                    File tempFile = new File(tempDir, String.valueOf(CommonUtils.escapeFileName((String)CommonUtils.truncateString((String)dataContainer.getName(), (int)32))) + "." + new SimpleDateFormat("yyyyMMdd-HHmmss").format(System.currentTimeMillis()) + ".xlsx");
                    tempFile.deleteOnExit();
                    DataExporterXLSX exporter = new DataExporterXLSX();
                    StreamTransferConsumer consumer = new StreamTransferConsumer();
                    StreamConsumerSettings settings = new StreamConsumerSettings();
                    settings.setOutputEncodingBOM(false);
                    settings.setOpenFolderOnFinish(false);
                    settings.setOutputFolder(tempDir.getAbsolutePath());
                    settings.setOutputFilePattern(tempFile.getName());
                    Map<Object, Object> properties = DataExporterXLSX.getDefaultProperties();
                    consumer.initTransfer((DBSObject)dataContainer, settings, true, (IStreamDataExporter)exporter, properties);
                    DBDDataFilter dataFilter = resultSet.getModel().getDataFilter();
                    DatabaseTransferProducer producer = new DatabaseTransferProducer((DBSDataContainer)dataContainer, dataFilter);
                    DatabaseProducerSettings producerSettings = new DatabaseProducerSettings();
                    producerSettings.setExtractType(DatabaseProducerSettings.ExtractType.SINGLE_QUERY);
                    producerSettings.setQueryRowCount(false);
                    producerSettings.setSelectedRowsOnly(true);
                    producerSettings.setSelectedColumnsOnly(true);
                    producer.transferData(monitor, (IDataTransferConsumer)consumer, null, producerSettings);
                    consumer.finishTransfer(monitor, false);
                    UIUtils.asyncExec(() -> {
                        if (!UIUtils.launchProgram((String)tempFile.getAbsolutePath())) {
                            DBeaverUI.getInstance().showError("Open XLSX", "Can't open XLSX file '" + tempFile.getAbsolutePath() + "'");
                        }
                    });
                }
                catch (Exception e) {
                    DBeaverUI.getInstance().showError("Error opening in Excel", null, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        exportJob.schedule();
        return null;
    }
}

