/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers.gis.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.managers.gis.IGeometryViewer;

public class GeometryViewerDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(GeometryViewerDescriptor.class);
    private final AbstractDescriptor.ObjectType type;
    private final String id;
    private final String label;
    private final DBPImage icon;

    GeometryViewerDescriptor(IConfigurationElement config) {
        super(config);
        this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.icon = this.iconToImage(config.getAttribute("icon"));
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public IGeometryViewer createGeometryViewer(IValueController valueController) throws DBException {
        try {
            return (IGeometryViewer)this.type.getObjectClass().getConstructor(IValueController.class).newInstance(valueController);
        }
        catch (Throwable e) {
            throw new DBException("Error instantiating geometry viewer", e);
        }
    }
}

