/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers.gis;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;
import org.jkiss.dbeaver.ui.data.managers.gis.GeometryTextViewer;
import org.jkiss.dbeaver.ui.data.managers.gis.IGeometryViewer;
import org.jkiss.dbeaver.ui.data.managers.gis.registry.GeometryViewerDescriptor;
import org.jkiss.dbeaver.ui.data.managers.gis.registry.GeometryViewerRegistry;
import org.jkiss.utils.CommonUtils;

public class GeometryPanelEditor
extends BaseValueEditor<Control> {
    private static final Log log = Log.getLog(GeometryPanelEditor.class);
    private static final String PROP_VIEWER_ID = "gis.geometry.viewer.id";
    private static final String DEFAULT_VIEWER_ID = GeometryTextViewer.class.getName();
    private GeometryViewerDescriptor curViewerDescriptor;
    private IGeometryViewer curViewer;

    public GeometryPanelEditor(IValueController controller) {
        super(controller);
        this.setDefaultViewer();
    }

    public void primeEditorValue(Object value) throws DBException {
        if (this.curViewer != null) {
            this.curViewer.primeEditorValue(value);
        }
    }

    public Object extractEditorValue() throws DBException {
        return this.curViewer == null ? null : this.curViewer.extractEditorValue();
    }

    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller) throws DBCException {
        manager.add((IAction)new ViewerSwitchAction());
        if (this.curViewer != null) {
            this.curViewer.contributeActions(manager, controller);
        }
    }

    public void createControl() {
        if (this.curViewer != null) {
            this.curViewer.createControl();
        }
    }

    protected Control createControl(Composite editPlaceholder) {
        if (this.curViewer == null) {
            return new Composite(editPlaceholder, 0);
        }
        this.curViewer.createControl();
        return this.curViewer.getControl();
    }

    private void setViewer(GeometryViewerDescriptor viewerDescriptor) {
        this.curViewerDescriptor = viewerDescriptor;
        try {
            this.curViewer = this.curViewerDescriptor.createGeometryViewer(this.valueController);
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        this.valueController.getExecutionContext().getDataSource().getContainer().getPreferenceStore().setValue(PROP_VIEWER_ID, this.curViewerDescriptor.getId());
    }

    private void setDefaultViewer() {
        GeometryViewerDescriptor viewerDescriptor;
        String viewerId = this.valueController.getExecutionContext().getDataSource().getContainer().getPreferenceStore().getString(PROP_VIEWER_ID);
        if (CommonUtils.isEmpty((String)viewerId)) {
            viewerId = DEFAULT_VIEWER_ID;
        }
        if ((viewerDescriptor = GeometryViewerRegistry.getInstance().getViewer(viewerId)) != null) {
            this.setViewer(viewerDescriptor);
        }
    }

    private class ViewerSwitchAction
    extends Action
    implements SelectionListener {
        private Menu menu;

        ViewerSwitchAction() {
            super(null, 4);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SCRIPTS));
            this.setToolTipText("Geometry viewer settings");
        }

        public void runWithEvent(Event event) {
            if (event.widget instanceof ToolItem) {
                ToolItem toolItem = (ToolItem)event.widget;
                Menu menu = this.createMenu(toolItem);
                Rectangle bounds = toolItem.getBounds();
                Point point = toolItem.getParent().toDisplay(bounds.x, bounds.y + bounds.height);
                menu.setLocation(point.x, point.y);
                menu.setVisible(true);
            }
        }

        private Menu createMenu(ToolItem toolItem) {
            if (this.menu == null) {
                ToolBar toolBar = toolItem.getParent();
                this.menu = new Menu((Control)toolBar);
                List<GeometryViewerDescriptor> viewers = GeometryViewerRegistry.getInstance().getViewers();
                for (GeometryViewerDescriptor viewerDescriptor : viewers) {
                    MenuItem item = new MenuItem(this.menu, 16);
                    item.setText(viewerDescriptor.getLabel());
                    item.setData((Object)viewerDescriptor);
                    item.addSelectionListener((SelectionListener)this);
                }
                if (GeometryPanelEditor.this.curViewer != null) {
                    MenuManager menuManager = new MenuManager();
                    try {
                        GeometryPanelEditor.this.curViewer.contributeActions((IContributionManager)menuManager, GeometryPanelEditor.this.valueController);
                        IContributionItem[] iContributionItemArray = menuManager.getItems();
                        int n = iContributionItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IContributionItem item = iContributionItemArray[n2];
                            item.fill(this.menu, -1);
                            ++n2;
                        }
                    }
                    catch (DBCException e2) {
                        log.error((Object)e2);
                    }
                    toolBar.addDisposeListener(e -> this.menu.dispose());
                }
            }
            MenuItem[] menuItemArray = this.menu.getItems();
            int n = menuItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                MenuItem item = menuItemArray[n3];
                if (item.getData() instanceof GeometryViewerDescriptor) {
                    item.setSelection(item.getData() == GeometryPanelEditor.this.curViewerDescriptor);
                }
                ++n3;
            }
            return this.menu;
        }

        public void widgetSelected(SelectionEvent e) {
            MenuItem[] menuItemArray = this.menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                GeometryViewerDescriptor newManager;
                Object itemData;
                MenuItem item = menuItemArray[n2];
                if (item.getSelection() && (itemData = item.getData()) instanceof GeometryViewerDescriptor && (newManager = (GeometryViewerDescriptor)((Object)itemData)) != GeometryPanelEditor.this.curViewerDescriptor) {
                    GeometryPanelEditor.this.setViewer(newManager);
                    GeometryPanelEditor.this.valueController.refreshEditor();
                }
                ++n2;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

