/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.lightgrid.LightGrid;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingConfigDialog;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingPanel;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsContainer;

public class GroupingResultsDecorator
implements IResultSetDecorator {
    private GroupingResultsContainer container;

    public GroupingResultsDecorator(GroupingResultsContainer container) {
        this.container = container;
    }

    @Override
    public long getDecoratorFeatures() {
        return 0L;
    }

    @Override
    public String getEmptyDataMessage() {
        if (this.container.getGroupAttributes().isEmpty()) {
            return "No Groupings";
        }
        return "Grouping failed";
    }

    @Override
    public String getEmptyDataDescription() {
        DBPDataSource dataSource = this.container.getResultSetController().getDataContainer().getDataSource();
        if (dataSource == null) {
            return "No connected to database";
        }
        SQLDialect dialect = SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
        if (dialect == null || !dialect.supportsSubqueries()) {
            return "Grouping is not supported\nby datasource '" + dataSource.getContainer().getDriver().getFullName() + "'";
        }
        if (this.container.getGroupAttributes().isEmpty()) {
            return "Drag-and-drop results column(s) here to create grouping\nPress CONTROL to configure grouping settings";
        }
        return "Grouping attempt failed. Clear grouping to proceed.";
    }

    @Override
    public void fillContributions(IContributionManager contributionManager) {
        contributionManager.add((IAction)new GroupingPanel.EditColumnsAction(this.container));
        contributionManager.add((IAction)new GroupingPanel.DeleteColumnAction(this.container));
        contributionManager.add((IAction)new GroupingPanel.ClearGroupingAction(this.container));
    }

    @Override
    public void registerDragAndDrop(IResultSetPresentation presentation) {
        Object oldDropTarget = presentation.getControl().getData("DropTarget");
        if (oldDropTarget instanceof DropTarget) {
            ((DropTarget)oldDropTarget).dispose();
        }
        DropTarget dropTarget = new DropTarget(presentation.getControl(), 3);
        dropTarget.setTransfer(new Transfer[]{LightGrid.GridColumnTransfer.INSTANCE, TextTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragLeave(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void drop(DropTargetEvent event) {
                this.handleDragEvent(event);
                if (event.detail == 2 || event.detail == 1) {
                    this.dropColumns(event);
                }
            }

            public void dropAccept(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            private void handleDragEvent(DropTargetEvent event) {
                if (!this.isDropSupported(event)) {
                    event.detail = 0;
                } else if (event.detail == 0) {
                    event.detail = 2;
                }
                event.feedback = 1;
            }

            private boolean isDropSupported(DropTargetEvent event) {
                return true;
            }

            private void dropColumns(DropTargetEvent event) {
                GroupingConfigDialog dialog;
                if (!(event.data instanceof List)) {
                    return;
                }
                List dropElements = (List)event.data;
                ArrayList<String> attributeBindings = new ArrayList<String>();
                for (Object element : dropElements) {
                    if (!(element instanceof DBDAttributeBinding)) continue;
                    DBDAttributeBinding binding = (DBDAttributeBinding)element;
                    if (binding instanceof DBDAttributeBindingMeta && binding.getMetaAttribute() != null) {
                        attributeBindings.add(DBUtils.getQuotedIdentifier((DBPDataSource)binding.getDataSource(), (String)binding.getMetaAttribute().getLabel()));
                        continue;
                    }
                    attributeBindings.add(binding.getFullyQualifiedName(DBPEvaluationContext.DML));
                }
                if (!attributeBindings.isEmpty()) {
                    GroupingResultsDecorator.this.container.addGroupingAttributes(attributeBindings);
                }
                if (event.detail == 1 && (dialog = new GroupingConfigDialog(GroupingResultsDecorator.this.container.getResultSetController().getControl().getShell(), GroupingResultsDecorator.this.container)).open() != 0) {
                    GroupingResultsDecorator.this.container.clearGrouping();
                    return;
                }
                try {
                    GroupingResultsDecorator.this.container.rebuildGrouping();
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Grouping error", "Can't perform grouping query", (Throwable)e);
                }
            }
        });
    }
}

