/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.StreamMergerDelegate;
import org.eclipse.team.internal.ui.mapping.WorkspaceTeamStateProvider;
import org.eclipse.team.internal.ui.synchronize.SynchronizeManager;
import org.eclipse.team.ui.mapping.ITeamStateProvider;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.SubscriberTeamStateProvider;
import org.eclipse.team.ui.synchronize.TeamStateProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.prefs.Preferences;

public class TeamUIPlugin
extends AbstractUIPlugin {
    private static TeamUIPlugin instance;
    public static final String ICON_PATH = "$nl$/icons/full/";
    public static final String ID = "org.eclipse.team.ui";
    public static final String PLUGIN_ID = "org.eclipse.team.ui";
    public static final String TRIGGER_POINT_ID = "org.eclipse.team.ui.activityTriggerPoint";
    private static List<IPropertyChangeListener> propertyChangeListeners;
    private Hashtable<String, ImageDescriptor> imageDescriptors = new Hashtable(20);
    private WorkspaceTeamStateProvider provider;
    private Map<String, TeamStateProvider> decoratedStateProviders = new HashMap<String, TeamStateProvider>();
    private SynchronizeManager synchronizeManager;
    private ServiceRegistration<DebugOptionsListener> debugRegistration;
    public static final String REMOVE_FROM_VIEW_ACTION_ID = "org.eclipse.team.internal.ui.RemoveFromView";
    public static final String FILE_DIRTY_OVR = "ovr/dirty_ov.png";
    public static final String FILE_CHECKEDIN_OVR = "ovr/version_controlled.png";
    public static final String FILE_CHECKEDOUT_OVR = "ovr/checkedout_ov.png";
    public static final String FILE_CONFLICT_OVR = "ovr/confchg_ov.png";
    public static final String FILE_ERROR_OVR = "ovr/error_co.png";
    public static final String FILE_WARNING_OVR = "ovr/warning_co.png";
    public static final String FILE_HOURGLASS_OVR = "ovr/waiting_ovr.png";

    static {
        propertyChangeListeners = new ArrayList<IPropertyChangeListener>(5);
    }

    public TeamUIPlugin() {
        instance = this;
    }

    public static Object createExtension(IConfigurationElement element, String classAttribute) throws CoreException {
        Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
        if (bundle.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        Object[] ret = new Object[1];
        CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, () -> {
            try {
                objectArray[0] = element.createExecutableExtension(classAttribute);
            }
            catch (CoreException e) {
                coreExceptionArray[0] = e;
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = TeamUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static TeamUIPlugin getPlugin() {
        return instance;
    }

    protected void initializeDefaultPluginPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault("org.eclipse.team.ui.view_syncinfo_in_label", false);
        store.setDefault("org.eclipse.team.ui.show_author_in_compare_editor", false);
        store.setDefault("org.eclipse.team.ui.validate_edit_with_no_context", false);
        store.setDefault("org.eclipse.team.ui.reuse_open_compare_editors", true);
        store.setDefault("org.eclipse.team.ui.run_import_in_background_", false);
        store.setDefault("org.eclipse.team.ui.apply_patch_in_sychronize_view", false);
        store.setDefault("org.eclipse.team.ui.compress_folders", true);
        store.setDefault("org.eclipse.team.ui.default_layout", "org.eclipse.team.ui.compressed_layout");
        store.setDefault("org.eclipse.team.ui.syncview_default_perspective", "org.eclipse.team.ui.TeamSynchronizingPerspective");
        store.setDefault("org.eclipse.team.ui.sychronizing_default_participant", "none");
        store.setDefault("org.eclipse.team.ui.sychronizing_default_participant_sec_id", "none");
        store.setDefault("org.eclipse.team.ui.sychronizing_default_perspective_to_show", "prompt");
        store.setDefault("org.eclipse.team.ui.remove_from_view_without_prompt", false);
        store.setDefault("pref_generichistory_view_linking", true);
        if (!store.isDefault("org.eclipse.team.ui.compress_folders") && !store.getBoolean("org.eclipse.team.ui.compress_folders")) {
            store.setToDefault("org.eclipse.team.ui.compress_folders");
            store.setDefault("org.eclipse.team.ui.default_layout", "org.eclipse.team.ui.tree_layout");
        }
    }

    public static void log(IStatus status) {
        TeamUIPlugin.getPlugin().getLog().log(status);
    }

    public static void log(CoreException e) {
        IStatus status = e.getStatus();
        TeamUIPlugin.log(status.getSeverity(), status.getMessage(), e);
    }

    public static void log(int severity, String message, Throwable e) {
        TeamUIPlugin.log((IStatus)new Status(severity, "org.eclipse.team.ui", 0, message, e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", "org.eclipse.team.ui");
        this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)Policy.DEBUG_OPTIONS_LISTENER, properties);
        this.initializeImages(this);
        StreamMergerDelegate.start();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.debugRegistration.unregister();
            this.debugRegistration = null;
            if (this.synchronizeManager != null) {
                this.synchronizeManager.dispose();
            }
        }
        finally {
            super.stop(context);
        }
        if (this.provider != null) {
            this.provider.dispose();
        }
        for (SubscriberTeamStateProvider subscriberTeamStateProvider : this.decoratedStateProviders.values()) {
            subscriberTeamStateProvider.dispose();
        }
    }

    public static void addPropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static void removePropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public static void broadcastPropertyChange(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    private static void createImageDescriptor(TeamUIPlugin plugin, String id) {
        plugin.privateCreateImageDescriptor(id);
    }

    private void privateCreateImageDescriptor(String id) {
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)this.getImageUrl(id));
        this.imageDescriptors.put(id, desc);
    }

    private void privateCreateImageDescriptor(String id, String imageUrl) {
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)this.getImageUrl(imageUrl));
        this.imageDescriptors.put(id, desc);
    }

    public static ImageDescriptor getImageDescriptor(String id) {
        return TeamUIPlugin.getPlugin().privateGetImageDescriptor(id);
    }

    private ImageDescriptor privateGetImageDescriptor(String id) {
        if (!this.imageDescriptors.containsKey(id)) {
            TeamUIPlugin.createImageDescriptor(TeamUIPlugin.getPlugin(), id);
        }
        return this.imageDescriptors.get(id);
    }

    public static ImageDescriptor getImageDescriptorFromExtension(IExtension extension, String subdirectoryAndFilename) {
        URL fullPathString = FileLocator.find((Bundle)Platform.getBundle((String)extension.getContributor().getName()), (IPath)new Path(subdirectoryAndFilename), null);
        return ImageDescriptor.createFromURL((URL)fullPathString);
    }

    private void initializeImages(TeamUIPlugin plugin) {
        this.privateCreateImageDescriptor("ovr/dirty_ov.gif", FILE_DIRTY_OVR);
        this.privateCreateImageDescriptor("ovr/confchg_ov.gif", FILE_CONFLICT_OVR);
        this.privateCreateImageDescriptor("ovr/version_controlled.gif", FILE_CHECKEDIN_OVR);
        this.privateCreateImageDescriptor("ovr/checkedout_ov.gif", FILE_CHECKEDOUT_OVR);
        this.privateCreateImageDescriptor("ovr/error_co.gif", FILE_ERROR_OVR);
        this.privateCreateImageDescriptor("ovr/warning_co.gif", FILE_WARNING_OVR);
        this.privateCreateImageDescriptor("ovr/waiting_ovr.gif", FILE_HOURGLASS_OVR);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/site_element.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/incom_synch.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/outgo_synch.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/conflict_synch.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/refresh.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/change_filter.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/ignorews_edit.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/collapseall.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/collapseall.png");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/incom_synch.png");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/outgo_synch.png");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/conflict_synch.png");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/refresh.png");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/ignorews_edit.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/catchup_rls.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/release_rls.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/catchuprelease_rls.png");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/catchup_rls.png");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/release_rls.png");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/catchuprelease_rls.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/catchup_rls.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/release_rls.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/catchuprelease_rls.png");
        TeamUIPlugin.createImageDescriptor(plugin, "wizban/import_projectset_wizban.png");
        TeamUIPlugin.createImageDescriptor(plugin, "wizban/export_projectset_wizban.png");
        TeamUIPlugin.createImageDescriptor(plugin, "wizban/share_wizban.png");
        TeamUIPlugin.createImageDescriptor(plugin, "obj/compressed_folder_obj.png");
        TeamUIPlugin.createImageDescriptor(plugin, "eview16/synch_synch.png");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/hierarchicalLayout.png");
        TeamUIPlugin.createImageDescriptor(plugin, "obj/dates.png");
        TeamUIPlugin.createImageDescriptor(plugin, "eview16/compare_view.png");
        TeamUIPlugin.createImageDescriptor(plugin, "obj/local_entry_tbl.png");
    }

    private URL getImageUrl(String relative) {
        return FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.team.ui"), (IPath)new Path(ICON_PATH + relative), null);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        return display;
    }

    public Image getImage(String key) {
        Image image = this.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor d = TeamUIPlugin.getImageDescriptor(key);
            image = d.createImage();
            this.getImageRegistry().put(key, image);
        }
        return image;
    }

    public static void run(IRunnableWithProgress runnable) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            Utils.handleError(TeamUIPlugin.getStandardDisplay().getActiveShell(), e, null, null);
        }
        catch (InterruptedException interruptedException) {}
    }

    public Preferences getInstancePreferences() {
        return InstanceScope.INSTANCE.getNode(this.getBundle().getSymbolicName());
    }

    public synchronized TeamStateProvider getDecoratedStateProvider(RepositoryProviderType rpt) {
        TeamStateProvider provider = this.decoratedStateProviders.get(rpt.getID());
        if (provider != null) {
            return provider;
        }
        Subscriber subscriber = rpt.getSubscriber();
        if (subscriber != null) {
            provider = new SubscriberTeamStateProvider(subscriber);
            this.decoratedStateProviders.put(rpt.getID(), provider);
            return provider;
        }
        return null;
    }

    public synchronized ITeamStateProvider getDecoratedStateProvider() {
        if (this.provider == null) {
            this.provider = new WorkspaceTeamStateProvider();
        }
        return this.provider;
    }

    public ISynchronizeManager getSynchronizeManager() {
        if (this.synchronizeManager == null) {
            this.synchronizeManager = new SynchronizeManager();
        }
        return this.synchronizeManager;
    }
}

