/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.jkiss.dbeaver.ui.editors.sql.syntax.rules.SQLDelimiterRule;

public class SQLWordRule
implements IRule {
    private SQLDelimiterRule delimRule;
    private IToken defaultToken;
    private Map<String, IToken> fWords = new HashMap<String, IToken>();
    private StringBuilder fBuffer = new StringBuilder();
    private char[][] delimiters;

    public SQLWordRule(SQLDelimiterRule delimRule, IToken defaultToken) {
        this.delimRule = delimRule;
        this.defaultToken = defaultToken;
    }

    public boolean hasWord(String word) {
        return this.fWords.containsKey(word.toLowerCase());
    }

    public void addWord(String word, IToken token) {
        this.fWords.put(word.toLowerCase(), token);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c != -1 && Character.isUnicodeIdentifierStart(c)) {
            this.fBuffer.setLength(0);
            this.delimiters = this.delimRule.getDelimiters();
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.isWordPart((char)c, scanner));
            scanner.unread();
            String buffer = this.fBuffer.toString().toLowerCase();
            IToken token = this.fWords.get(buffer);
            if (token != null) {
                return token;
            }
            if (this.defaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.defaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private boolean isWordPart(char c, ICharacterScanner scanner) {
        if (!Character.isUnicodeIdentifierPart(c) && c != '$') {
            return false;
        }
        char[][] cArray = this.delimiters;
        int n = this.delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            char[] wordDelimiter = cArray[n2];
            if (!Character.isLetter(c) && c == wordDelimiter[0]) {
                if (wordDelimiter.length == 1) {
                    return false;
                }
                int charsRead = 0;
                boolean matches = true;
                int i = 1;
                while (i < wordDelimiter.length) {
                    int c2 = scanner.read();
                    ++charsRead;
                    if (c2 == -1) break;
                    if (c2 != wordDelimiter[i]) {
                        matches = false;
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < charsRead) {
                    scanner.unread();
                    ++i;
                }
                if (matches) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

