/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SQLQueryParameter {
    private final SQLSyntaxManager syntaxManager;
    private int ordinalPosition;
    private String name;
    private String value;
    private boolean variableSet;
    private final int tokenOffset;
    private final int tokenLength;
    private SQLQueryParameter previous;

    public SQLQueryParameter(SQLSyntaxManager syntaxManager, int ordinalPosition, String name) {
        this(syntaxManager, ordinalPosition, name, 0, 0);
    }

    public SQLQueryParameter(SQLSyntaxManager syntaxManager, int ordinalPosition, String name, int tokenOffset, int tokenLength) {
        this.syntaxManager = syntaxManager;
        if (tokenOffset < 0) {
            throw new IndexOutOfBoundsException("Bad parameter offset: " + tokenOffset);
        }
        if (tokenLength < 0) {
            throw new IndexOutOfBoundsException("Bad parameter length: " + tokenLength);
        }
        this.ordinalPosition = ordinalPosition;
        this.name = name.trim();
        this.tokenOffset = tokenOffset;
        this.tokenLength = tokenLength;
    }

    public boolean isNamed() {
        return !String.valueOf(this.syntaxManager.getAnonymousParameterMark()).equals(this.name);
    }

    public int getTokenOffset() {
        return this.tokenOffset;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public SQLQueryParameter getPrevious() {
        return this.previous;
    }

    public void setPrevious(SQLQueryParameter previous) {
        this.previous = previous;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isVariableSet() {
        return this.variableSet;
    }

    public void setVariableSet(boolean variableSet) {
        this.variableSet = variableSet;
    }

    public String getTitle() {
        if (GeneralUtils.isVariablePattern(this.name)) {
            return GeneralUtils.stripVariablePattern(this.name);
        }
        if (!this.name.isEmpty() && this.name.charAt(0) == this.syntaxManager.getNamedParameterPrefix()) {
            return this.name.substring(1);
        }
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.getTitle()) + "=" + this.value;
    }
}

