/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;

public class DBNRoot
extends DBNNode
implements DBNContainer,
DBPProjectListener {
    private final DBNModel model;
    private DBNProject[] projects = new DBNProject[0];

    public DBNRoot(DBNModel model) {
        this.model = model;
        model.getPlatform().getProjectManager().addProjectListener(this);
    }

    @Override
    void dispose(boolean reflect) {
        DBNProject[] dBNProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            DBNProject project = dBNProjectArray[n2];
            project.dispose(reflect);
            ++n2;
        }
        this.projects = new DBNProject[0];
        this.model.getPlatform().getProjectManager().removeProjectListener(this);
    }

    @Override
    public DBNModel getModel() {
        return this.model;
    }

    @Override
    public String getNodeType() {
        return ModelMessages.model_navigator_Root;
    }

    @Override
    public Object getValueObject() {
        return this;
    }

    @Override
    public String getChildrenType() {
        return ModelMessages.model_navigator_Project;
    }

    public Class<IProject> getChildrenClass() {
        return IProject.class;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    public String getNodeName() {
        return "#root";
    }

    @Override
    public String getNodeDescription() {
        return ModelMessages.model_navigator_Model_root;
    }

    @Override
    public DBPImage getNodeIcon() {
        return null;
    }

    @Override
    public boolean allowsChildren() {
        return this.projects.length > 0;
    }

    public DBNProject[] getChildren(DBRProgressMonitor monitor) {
        return this.projects;
    }

    public DBNProject[] getProjects() {
        return this.projects;
    }

    @Override
    public boolean allowsOpen() {
        return true;
    }

    @Override
    public String getNodeItemPath() {
        return null;
    }

    public DBNProject getProject(IProject project) {
        DBNProject[] dBNProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            DBNProject node = dBNProjectArray[n2];
            if (node.getProject() == project) {
                return node;
            }
            ++n2;
        }
        return null;
    }

    DBNProject addProject(IProject project, boolean reflect) {
        DBNProject projectNode = new DBNProject((DBNNode)this, project, this.model.getPlatform().getProjectManager().getResourceHandler((IResource)project));
        this.projects = (DBNProject[])ArrayUtils.add(DBNProject.class, (Object[])this.projects, (Object)projectNode);
        Arrays.sort(this.projects, new Comparator<DBNProject>(){

            @Override
            public int compare(DBNProject o1, DBNProject o2) {
                return o1.getNodeName().compareTo(o2.getNodeName());
            }
        });
        this.model.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, projectNode));
        return projectNode;
    }

    void removeProject(IProject project) {
        int i = 0;
        while (i < this.projects.length) {
            DBNProject projectNode = this.projects[i];
            if (projectNode.getProject() == project) {
                this.projects = (DBNProject[])ArrayUtils.remove(DBNProject.class, (Object[])this.projects, (int)i);
                this.model.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.REMOVE, projectNode));
                projectNode.dispose(true);
                break;
            }
            ++i;
        }
    }

    @Override
    public void handleActiveProjectChange(IProject oldValue, IProject newValue) {
        DBNProject projectNode = this.getProject(newValue);
        DBNProject oldProjectNode = this.getProject(oldValue);
        if (projectNode != null) {
            this.model.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.UPDATE, projectNode));
        }
        if (oldProjectNode != null) {
            this.model.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.UPDATE, oldProjectNode));
        }
    }
}

