/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.MySQLMessages;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraint;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraintColumn;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLConstraintManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;

public class MySQLConstraintManager
extends SQLConstraintManager<MySQLTableConstraint, MySQLTable> {
    @Nullable
    public DBSObjectCache<MySQLCatalog, MySQLTableConstraint> getObjectsCache(MySQLTableConstraint object) {
        return ((MySQLCatalog)((MySQLTable)object.getTable()).getContainer()).getConstraintCache();
    }

    protected MySQLTableConstraint createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final MySQLTable parent, Object from) {
        return (MySQLTableConstraint)((Object)new UITask<MySQLTableConstraint>(){

            protected MySQLTableConstraint runTask() {
                EditConstraintPage editPage = new EditConstraintPage(MySQLMessages.edit_constraint_manager_title, (DBSEntity)parent, new DBSEntityConstraintType[]{DBSEntityConstraintType.PRIMARY_KEY, DBSEntityConstraintType.UNIQUE_KEY});
                if (!editPage.edit()) {
                    return null;
                }
                MySQLTableConstraint constraint = new MySQLTableConstraint(parent, editPage.getConstraintName(), null, editPage.getConstraintType(), false);
                int colIndex = 1;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    constraint.addColumn(new MySQLTableConstraintColumn((AbstractTableConstraint<MySQLTable>)constraint, (MySQLTableColumn)tableColumn, colIndex++));
                }
                return constraint;
            }
        }.execute());
    }

    protected String getDropConstraintPattern(MySQLTableConstraint constraint) {
        if (constraint.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY) {
            return "ALTER TABLE %TABLE% DROP PRIMARY KEY";
        }
        return "ALTER TABLE %TABLE% DROP KEY %CONSTRAINT%";
    }
}

