/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.debug.ui.internal.DebugConfigurationPanelDescriptor;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;

public class DebugConfigurationPanelRegistry {
    private static DebugConfigurationPanelRegistry instance = null;
    private final List<DebugConfigurationPanelDescriptor> descriptors = new ArrayList<DebugConfigurationPanelDescriptor>();

    public static synchronized DebugConfigurationPanelRegistry getInstance() {
        if (instance == null) {
            instance = new DebugConfigurationPanelRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DebugConfigurationPanelRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.debug.ui.configurationPanels");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            DebugConfigurationPanelDescriptor formatterDescriptor = new DebugConfigurationPanelDescriptor(ext);
            this.descriptors.add(formatterDescriptor);
            ++n2;
        }
    }

    public List<DebugConfigurationPanelDescriptor> getPanels() {
        return this.descriptors;
    }

    public List<DebugConfigurationPanelDescriptor> getPanels(DBPDataSourceContainer dataSource) {
        ArrayList<DebugConfigurationPanelDescriptor> result = new ArrayList<DebugConfigurationPanelDescriptor>();
        for (DebugConfigurationPanelDescriptor desc : this.descriptors) {
            if (!desc.supportsDataSource(dataSource)) continue;
            result.add(desc);
        }
        return result;
    }

    public DebugConfigurationPanelDescriptor getPanel(String id) {
        for (DebugConfigurationPanelDescriptor descriptor : this.descriptors) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }
}

