/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.RendererHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DriverGalleryItemRenderer
extends AbstractGalleryItemRenderer {
    public static final int IMAGE_DRAW_WIDTH = 50;
    public static final int ITEM_MARGIN = 5;
    private Color selectionForegroundColor;
    private Color selectionBackgroundColor;
    private Color foregroundColor = Display.getDefault().getSystemColor(24);
    private Color backgroundColor = Display.getDefault().getSystemColor(25);
    private boolean showRoundedSelectionCorners = true;
    private int selectionRadius = 10;
    private boolean drawBackground = false;
    private Color drawBackgroundColor = null;
    private Color drawForegroundColor = null;
    private Font normalFont;
    private Font boldFont;

    public DriverGalleryItemRenderer(Composite panel) {
        this.selectionForegroundColor = Display.getDefault().getSystemColor(27);
        this.selectionBackgroundColor = Display.getDefault().getSystemColor(26);
        this.normalFont = panel.getFont();
        this.boldFont = UIUtils.makeBoldFont((Font)this.normalFont);
    }

    public void draw(GC gc, GalleryItem item, int index, int x, int y, int width, int height) {
        Image itemImage = item.getImage();
        this.drawForegroundColor = this.getForeground(item);
        gc.setFont(this.getFont(item));
        int useableHeight = height;
        String itemText = item.getText();
        String itemDescription = item.getText(1);
        String itemCategory = item.getText(2);
        this.drawBackground = this.selected;
        this.drawBackgroundColor = null;
        if (!this.drawBackground && item.getBackground(true) != null) {
            this.drawBackgroundColor = this.getBackground(item);
            if (!RendererHelper.isColorsEquals((Color)this.drawBackgroundColor, (Color)this.gallery.getBackground())) {
                this.drawBackground = true;
            }
        }
        if (this.drawBackground) {
            if (this.selected) {
                gc.setBackground(this.selectionBackgroundColor);
                gc.setForeground(this.selectionBackgroundColor);
            } else if (this.drawBackgroundColor != null) {
                gc.setBackground(this.drawBackgroundColor);
            }
            if (this.showRoundedSelectionCorners) {
                gc.fillRoundRectangle(x, y, width, useableHeight, this.selectionRadius, this.selectionRadius);
            } else {
                gc.fillRectangle(x, y, width, height);
            }
        }
        if (itemImage != null) {
            Rectangle itemImageBounds = itemImage.getBounds();
            int imageWidth = itemImageBounds.width;
            int imageHeight = itemImageBounds.height;
            int imageDrawWidth = 50;
            int imageDrawHeight = 50;
            gc.drawImage(itemImage, 0, 0, imageWidth, imageHeight, x + 5, y + 5, imageDrawWidth, imageDrawHeight);
        }
        if (itemText != null && !"".equals(itemText)) {
            if (this.selected) {
                gc.setForeground(this.selectionForegroundColor);
                gc.setBackground(this.selectionBackgroundColor);
            } else {
                if (this.drawBackgroundColor != null) {
                    gc.setBackground(this.drawBackgroundColor);
                } else {
                    gc.setBackground(this.backgroundColor);
                }
                if (this.drawForegroundColor != null) {
                    gc.setForeground(this.drawForegroundColor);
                } else {
                    gc.setForeground(this.foregroundColor);
                }
            }
            String text = RendererHelper.createLabel((String)itemText, (GC)gc, (int)(width - 50 - 5));
            int textY = y + 5;
            int textX = x + 50 + 10;
            gc.setFont(this.boldFont);
            gc.drawText(text, textX, textY, true);
            gc.setFont(this.normalFont);
            textY += gc.getFontMetrics().getHeight() + 5;
            if (!CommonUtils.isEmpty((String)itemCategory)) {
                gc.drawText(itemCategory, textX, textY, true);
            }
            textY += gc.getFontMetrics().getHeight();
            if (!CommonUtils.isEmpty((String)itemDescription)) {
                gc.drawText(itemDescription, textX, textY, true);
            }
        }
    }

    public Font getFont() {
        if (this.gallery != null) {
            return this.gallery.getFont();
        }
        return null;
    }

    public void setFont(Font font) {
        if (this.gallery != null) {
            this.gallery.setFont(font);
        }
    }

    public void dispose() {
        if (this.boldFont != null) {
            UIUtils.dispose((Resource)this.boldFont);
            this.boldFont = null;
        }
    }
}

