/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.dbeaver.ui.UIIcon;

public class DriverLibraryLocal
extends DriverLibraryAbstract {
    private static final Log log = Log.getLog(DriverLibraryLocal.class);

    public DriverLibraryLocal(DriverDescriptor driver, DBPDriverLibrary.FileType type, String path) {
        super(driver, type, path);
    }

    public DriverLibraryLocal(DriverDescriptor driver, IConfigurationElement config) {
        super(driver, config);
    }

    public DriverLibraryLocal(DriverDescriptor driverDescriptor, DriverLibraryLocal copyFrom) {
        super(driverDescriptor, copyFrom);
    }

    @Override
    public DBPDriverLibrary copyLibrary(DriverDescriptor driverDescriptor) {
        return new DriverLibraryLocal(driverDescriptor, this);
    }

    public boolean isDownloadable() {
        return false;
    }

    public void resetVersion() {
    }

    public boolean isSecureDownload(DBRProgressMonitor monitor) {
        return true;
    }

    protected String getLocalFilePath() {
        return this.path;
    }

    @Nullable
    public String getExternalURL(DBRProgressMonitor monitor) {
        return null;
    }

    @Nullable
    public File getLocalFile() {
        String localFilePath = this.getLocalFilePath();
        File libraryFile = new File(localFilePath);
        if (libraryFile.exists()) {
            return libraryFile;
        }
        File platformFile = this.detectLocalFile();
        if (platformFile != null && platformFile.exists()) {
            return platformFile;
        }
        URL url = this.driver.getProviderDescriptor().getContributorBundle().getEntry(localFilePath);
        if (url == null) {
            url = this.driver.getProviderDescriptor().getRegistry().findResourceURL(localFilePath);
        }
        if (url != null) {
            try {
                url = FileLocator.toFileURL((URL)url);
            }
            catch (IOException ex) {
                log.warn((Object)ex);
            }
            if (url != null) {
                return new File(url.getFile());
            }
        } else {
            try {
                url = FileLocator.toFileURL((URL)new URL(localFilePath));
                File urlFile = new File(url.getFile());
                if (urlFile.exists()) {
                    platformFile = urlFile;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return platformFile;
    }

    @Nullable
    public Collection<? extends DBPDriverLibrary> getDependencies(@NotNull DBRProgressMonitor monitor) throws IOException {
        return null;
    }

    protected File detectLocalFile() {
        String localPath = this.getLocalFilePath();
        File file = new File(new File(Platform.getInstallLocation().getURL().getFile()), localPath);
        if (!file.exists()) {
            file = new File(DriverDescriptor.getCustomDriversHome(), localPath);
        }
        return file;
    }

    @NotNull
    public String getDisplayName() {
        return this.path;
    }

    public String getId() {
        return this.path;
    }

    @NotNull
    public DBIcon getIcon() {
        File localFile = this.getLocalFile();
        if (localFile != null && localFile.isDirectory()) {
            return DBIcon.TREE_FOLDER;
        }
        switch (this.type) {
            case lib: {
                return UIIcon.LIBRARY;
            }
            case jar: {
                return UIIcon.JAR;
            }
        }
        return DBIcon.TYPE_UNKNOWN;
    }
}

