/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.edit;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericPrimaryKey;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKeyColumnTable;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyDeferability;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;

public class GenericForeignKeyManager
extends SQLForeignKeyManager<GenericTableForeignKey, GenericTable> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericTableForeignKey> getObjectsCache(GenericTableForeignKey object) {
        return ((GenericStructContainer)((GenericTable)object.getParentObject()).getContainer()).getForeignKeysCache();
    }

    protected GenericTableForeignKey createDatabaseObject(final DBRProgressMonitor monitor, DBECommandContext context, final GenericTable table, Object from) {
        return (GenericTableForeignKey)((Object)new UITask<GenericTableForeignKey>(){

            protected GenericTableForeignKey runTask() {
                EditForeignKeyPage editPage = new EditForeignKeyPage("Create foreign key", (DBSTable)table, new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.CASCADE, DBSForeignKeyModifyRule.RESTRICT, DBSForeignKeyModifyRule.SET_NULL, DBSForeignKeyModifyRule.SET_DEFAULT});
                if (!editPage.edit()) {
                    return null;
                }
                GenericTableForeignKey foreignKey = new GenericTableForeignKey(table, null, null, (DBSEntityReferrer)((GenericPrimaryKey)editPage.getUniqueConstraint()), editPage.getOnDeleteRule(), editPage.getOnUpdateRule(), DBSForeignKeyDeferability.NOT_DEFERRABLE, false);
                foreignKey.setName(GenericForeignKeyManager.this.getNewConstraintName(monitor, (JDBCTableConstraint)foreignKey));
                int colIndex = 1;
                for (EditForeignKeyPage.FKColumnInfo tableColumn : editPage.getColumns()) {
                    foreignKey.addColumn(new GenericTableForeignKeyColumnTable(foreignKey, (GenericTableColumn)tableColumn.getOwnColumn(), colIndex++, (GenericTableColumn)tableColumn.getRefColumn()));
                }
                return foreignKey;
            }
        }.execute());
    }

    protected boolean isLegacyForeignKeySyntax(GenericTable owner) {
        return GenericUtils.isLegacySQLDialect((DBSObject)owner);
    }
}

