/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.List;
import javax.imageio.ImageIO;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterHTML
extends StreamExporterAbstract {
    private static final int IMAGE_FRAME_SIZE = 200;
    private PrintWriter out;
    private List<DBDAttributeBinding> columns;
    private int rowCount = 0;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        this.out = site.getWriter();
    }

    @Override
    public void dispose() {
        this.out = null;
        super.dispose();
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.printHeader();
    }

    private void printHeader() {
        this.out.write("<html>");
        this.out.write("<head><style>table {font-family:\"Lucida Sans Unicode\", \"Lucida Grande\", Sans-Serif;font-size:12px;text-align:left;border-collapse:collapse;margin:10px;} th{font-size:14px;font-weight:normal;color:#039;padding:10px 8px;} td{color:#669;padding:8px;}.odd{background:#e8edff;}img{padding:5px; border:solid; border-color: #dddddd #aaaaaa #aaaaaa #dddddd; border-width: 1px 2px 2px 1px; background-color:white;}</style></head>");
        this.out.write("<body><table>");
        this.out.write("<tr>");
        int i = 0;
        int columnsSize = this.columns.size();
        while (i < columnsSize) {
            String colName = this.columns.get(i).getLabel();
            if (CommonUtils.isEmpty((String)colName)) {
                colName = this.columns.get(i).getName();
            }
            this.writeTextCell(colName, true);
            ++i;
        }
        this.out.write("</tr>");
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        this.out.write("<tr" + (this.rowCount++ % 2 == 0 ? " class=\"odd\"" : "") + ">");
        int i = 0;
        while (i < row.length) {
            DBDAttributeBinding column = this.columns.get(i);
            if (DBUtils.isNullValue((Object)row[i])) {
                this.writeTextCell(null, false);
            } else if (row[i] instanceof DBDContent) {
                DBDContent content = (DBDContent)row[i];
                try {
                    DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                    this.out.write("<td>");
                    if (cs != null) {
                        if (ContentUtils.isTextContent((DBDContent)content)) {
                            this.writeCellValue(cs.getContentReader());
                        } else {
                            this.getSite().writeBinaryData(cs);
                        }
                    }
                    this.out.write("</td>");
                }
                finally {
                    content.release();
                }
            } else {
                boolean isImage;
                String stringValue = super.getValueDisplayString(column, row[i]);
                boolean bl = isImage = row[i] instanceof File && stringValue != null && stringValue.endsWith(".jpg");
                if (isImage) {
                    this.writeImageCell((File)row[i]);
                } else {
                    this.writeTextCell(stringValue, false);
                }
            }
            ++i;
        }
        this.out.write("</tr>\n");
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws IOException {
        this.out.write("</table></body></html>");
    }

    private void writeTextCell(String value, boolean header) {
        this.out.write(header ? "<th>" : "<td>");
        if (value == null) {
            this.out.write("&nbsp;");
        } else {
            value = value.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;");
            this.out.write(value);
        }
        this.out.write(header ? "</th>" : "</td>");
    }

    private void writeImageCell(File file) throws DBException {
        this.out.write("<td>");
        if (file == null || !file.exists()) {
            this.out.write("&nbsp;");
        } else {
            BufferedImage image = null;
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                throw new DBException("Can't read an exported image " + image, (Throwable)e);
            }
            if (image != null) {
                String imagePath = file.getAbsolutePath();
                imagePath = "files/" + imagePath.substring(imagePath.lastIndexOf(File.separator));
                int width = image.getWidth();
                int height = image.getHeight();
                int rwidth = width;
                int rheight = height;
                if (width > 200 || height > 200) {
                    float scale = 1.0f;
                    scale = width > height ? 200.0f / (float)width : 200.0f / (float)height;
                    rwidth = (int)((float)rwidth * scale);
                    rheight = (int)((float)rheight * scale);
                }
                this.out.write("<a href=\"" + imagePath + "\">");
                this.out.write("<img src=\"" + imagePath + "\" width=\"" + rwidth + "\" height=\"" + rheight + "\" />");
                this.out.write("</a>");
            } else {
                this.out.write("&nbsp;");
            }
        }
        this.out.write("</td>");
    }

    private void writeCellValue(Reader reader) throws IOException {
        try {
            int count;
            char[] buffer = new char[2000];
            block3: while ((count = reader.read(buffer)) > 0) {
                int i = 0;
                while (true) {
                    if (i >= count) continue block3;
                    if (buffer[i] == '<') {
                        this.out.write("&lt;");
                    } else if (buffer[i] == '>') {
                        this.out.write("&gt;");
                    }
                    if (buffer[i] == '&') {
                        this.out.write("&amp;");
                    }
                    this.out.write(buffer[i]);
                    ++i;
                }
                break;
            }
        }
        finally {
            ContentUtils.close((Closeable)reader);
        }
    }

    public boolean saveBinariesAsImages() {
        return true;
    }
}

