/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBNLocalFolder
extends DBNNode
implements DBNContainer {
    private DBPDataSourceFolder folder;

    public DBNLocalFolder(DBNProjectDatabases parentNode, DBPDataSourceFolder folder) {
        super(parentNode);
        this.folder = folder;
    }

    @Override
    void dispose(boolean reflect) {
        super.dispose(reflect);
    }

    public DBPDataSourceFolder getFolder() {
        return this.folder;
    }

    public DBPDataSourceRegistry getDataSourceRegistry() {
        return ((DBNProjectDatabases)this.parentNode).getDataSourceRegistry();
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.getNodeName();
    }

    @Override
    public Object getValueObject() {
        return this.folder;
    }

    @Override
    public String getChildrenType() {
        return "connections";
    }

    @Override
    public String getNodeType() {
        return "folder";
    }

    @Override
    public String getNodeName() {
        return this.folder.getName();
    }

    @Override
    public String getNodeDescription() {
        return this.folder.getDescription();
    }

    @Override
    public DBPImage getNodeIcon() {
        DBPImage dsIcon = null;
        for (DBNDataSource ds : this.getDataSources()) {
            DBPImage icon = DBValueFormatting.getObjectImage(ds.getDataSourceContainer());
            if (dsIcon == null) {
                dsIcon = icon;
                continue;
            }
            if (CommonUtils.equalObjects((Object)dsIcon, (Object)icon)) continue;
            dsIcon = null;
            break;
        }
        return DBIcon.TREE_FOLDER_DATABASE;
    }

    @Override
    public String getNodeItemPath() {
        return String.valueOf(DBNNode.NodePathType.folder.getPrefix()) + this.getParentNode().getDataSourceRegistry().getProject().getName() + "/" + this.folder.getFolderPath();
    }

    @Override
    public DBNProjectDatabases getParentNode() {
        return (DBNProjectDatabases)super.getParentNode();
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    @Override
    public boolean hasChildren(boolean navigableOnly) {
        if (!ArrayUtils.isEmpty((Object[])this.folder.getChildren())) {
            return true;
        }
        for (DBNDataSource dataSource : this.getParentNode().getDataSources()) {
            if (this.folder != dataSource.getDataSourceContainer().getFolder()) continue;
            return true;
        }
        return false;
    }

    public DBNNode getLogicalParent() {
        if (this.folder.getParent() == null) {
            return this.getParentNode();
        }
        return this.getParentNode().getFolderNode(this.folder.getParent());
    }

    @Override
    public DBNNode[] getChildren(DBRProgressMonitor monitor) {
        if (ArrayUtils.isEmpty((Object[])this.folder.getChildren())) {
            return (DBNNode[])ArrayUtils.toArray(DBNDataSource.class, this.getDataSources());
        }
        ArrayList<DBNNode> nodes = new ArrayList<DBNNode>();
        DBPDataSourceFolder[] dBPDataSourceFolderArray = this.folder.getChildren();
        int n = dBPDataSourceFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPDataSourceFolder childFolder = dBPDataSourceFolderArray[n2];
            nodes.add(this.getParentNode().getFolderNode(childFolder));
            ++n2;
        }
        nodes.addAll(this.getDataSources());
        DBNLocalFolder.sortNodes(nodes);
        return (DBNNode[])ArrayUtils.toArray(DBNNode.class, nodes);
    }

    public List<DBNDataSource> getDataSources() {
        ArrayList<DBNDataSource> children = new ArrayList<DBNDataSource>();
        DBNProjectDatabases parent = this.getParentNode();
        for (DBNDataSource dataSource : parent.getDataSources()) {
            if (this.folder != dataSource.getDataSourceContainer().getFolder()) continue;
            children.add(dataSource);
        }
        DBNLocalFolder.sortNodes(children);
        return children;
    }

    public Class<? extends DBSObject> getChildrenClass() {
        return DBPDataSourceContainer.class;
    }

    @Override
    public boolean supportsDrop(DBNNode otherNode) {
        return otherNode == null || otherNode instanceof DBNDataSource;
    }

    @Override
    public void dropNodes(Collection<DBNNode> nodes) throws DBException {
        for (DBNNode node : nodes) {
            if (!(node instanceof DBNDataSource)) continue;
            ((DBNDataSource)node).setFolder(this.folder);
        }
        DBNModel.updateConfigAndRefreshDatabases(this);
    }

    @Override
    public boolean supportsRename() {
        return true;
    }

    @Override
    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        this.folder.setName(newName);
        DBNModel.updateConfigAndRefreshDatabases(this);
    }

    public boolean hasConnected() {
        DBPDataSourceFolder[] dBPDataSourceFolderArray = this.folder.getChildren();
        int n = dBPDataSourceFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPDataSourceFolder childFolder = dBPDataSourceFolderArray[n2];
            if (this.getParentNode().getFolderNode(childFolder).hasConnected()) {
                return true;
            }
            ++n2;
        }
        for (DBNDataSource ds : this.getDataSources()) {
            if (ds.getDataSource() == null) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.folder.getFolderPath();
    }
}

