/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public abstract class AbstractDescriptor {
    private static final Log log = Log.getLog(AbstractDescriptor.class);
    public static final String VAR_OBJECT = "object";
    public static final String VAR_CONTEXT = "context";
    private static JexlEngine jexlEngine;
    private static Map<String, Map<String, Boolean>> classInfoCache;
    private String pluginId;
    private Bundle originBundle;

    static {
        classInfoCache = new HashMap<String, Map<String, Boolean>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Expression parseExpression(String exprString) throws DBException {
        Class<AbstractDescriptor> clazz = AbstractDescriptor.class;
        synchronized (AbstractDescriptor.class) {
            if (jexlEngine == null) {
                jexlEngine = new JexlEngine(null, null, null, null);
                jexlEngine.setCache(100);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                return jexlEngine.createExpression(exprString);
            }
            catch (JexlException e) {
                throw new DBException("Bad expression", e);
            }
        }
    }

    private static synchronized Map<String, Boolean> getTypeInfoCache(Class<?> clazz) {
        Map<String, Boolean> intCache = classInfoCache.get(clazz.getName());
        if (intCache != null) {
            return intCache;
        }
        intCache = new HashMap<String, Boolean>();
        classInfoCache.put(clazz.getName(), intCache);
        Class<?> sc = clazz;
        while (sc != null && sc != Object.class) {
            AbstractDescriptor.collectInterface(sc, intCache);
            sc = sc.getSuperclass();
        }
        return intCache;
    }

    private static void collectInterface(Class clazz, Map<String, Boolean> intCache) {
        intCache.put(clazz.getName(), Boolean.TRUE);
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            AbstractDescriptor.collectInterface(i, intCache);
            ++n2;
        }
    }

    protected AbstractDescriptor(IConfigurationElement contributorConfig) {
        this.pluginId = contributorConfig.getContributor().getName();
    }

    protected AbstractDescriptor(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public Bundle getContributorBundle() {
        if (this.originBundle == null) {
            this.originBundle = Platform.getBundle((String)this.pluginId);
        }
        return this.originBundle;
    }

    @NotNull
    protected DBPImage iconToImage(String icon, @NotNull DBPImage defIcon) {
        DBPImage result = this.iconToImage(icon);
        if (result == null) {
            return defIcon;
        }
        return result;
    }

    @Nullable
    protected DBPImage iconToImage(String icon) {
        if (CommonUtils.isEmpty((String)icon)) {
            return null;
        }
        if (icon.startsWith("#")) {
            return DBIcon.getImageById(icon.substring(1));
        }
        if (!icon.startsWith("platform:")) {
            icon = "platform:/plugin/" + this.pluginId + "/" + icon;
        }
        return new DBIcon(icon);
    }

    public Class<?> getObjectClass(@NotNull String className) {
        return this.getObjectClass(className, null);
    }

    public <T> Class<T> getObjectClass(@NotNull String className, Class<T> type) {
        return AbstractDescriptor.getObjectClass(this.getContributorBundle(), className, type);
    }

    public static <T> Class<T> getObjectClass(@NotNull Bundle fromBundle, @NotNull String className, Class<T> type) {
        Class objectClass;
        try {
            objectClass = fromBundle.loadClass(className);
        }
        catch (Throwable ex) {
            log.error("Can't determine object class '" + className + "'", ex);
            return null;
        }
        if (type != null && !type.isAssignableFrom(objectClass)) {
            log.error("Object class '" + className + "' doesn't match requested type '" + type.getName() + "'");
            return null;
        }
        return objectClass;
    }

    public class ObjectType {
        private static final String ATTR_NAME = "name";
        private static final String ATTR_IF = "if";
        private static final String ATTR_FORCE_CHECK = "forceCheck";
        private final String implName;
        private Class<?> implClass;
        private Expression expression;
        private boolean forceCheck;

        public ObjectType(String implName) {
            this.implName = implName;
        }

        public ObjectType(IConfigurationElement cfg) {
            this(cfg, ATTR_NAME);
        }

        public ObjectType(IConfigurationElement cfg, String typeAttr) {
            String fcAttr;
            this.implName = cfg.getAttribute(typeAttr);
            String condition = cfg.getAttribute(ATTR_IF);
            if (!CommonUtils.isEmpty((String)condition)) {
                try {
                    this.expression = AbstractDescriptor.parseExpression(condition);
                }
                catch (DBException ex) {
                    log.warn("Can't parse object type expression: " + condition, ex);
                }
            }
            if (!CommonUtils.isEmpty((String)(fcAttr = cfg.getAttribute(ATTR_FORCE_CHECK)))) {
                this.forceCheck = CommonUtils.toBoolean((Object)fcAttr);
            }
        }

        public String getImplName() {
            return this.implName;
        }

        public Class<?> getObjectClass() {
            return this.getObjectClass(Object.class);
        }

        public <T> Class<? extends T> getObjectClass(Class<T> type) {
            if (this.implName == null) {
                return null;
            }
            if (this.implClass == null) {
                this.implClass = AbstractDescriptor.this.getObjectClass(this.implName, type);
            }
            return this.implClass;
        }

        public <T> void checkObjectClass(Class<T> type) throws DBException {
            Class<T> objectClass = this.getObjectClass(type);
            if (objectClass == null) {
                throw new DBException("Class '" + this.implName + "' not found");
            }
            if (!type.isAssignableFrom(objectClass)) {
                throw new DBException("Class '" + this.implName + "' do not implements '" + type.getName() + "'");
            }
        }

        public boolean appliesTo(Object object, Object context) {
            if (!this.matchesType(object.getClass())) {
                return false;
            }
            if (this.expression != null) {
                Object result = this.expression.evaluate(this.makeContext(object, context));
                return Boolean.TRUE.equals(result);
            }
            return true;
        }

        public <T> T createInstance(Class<T> type) throws DBException {
            if (this.implName == null) {
                throw new DBException("No implementation class name set for '" + type.getName() + "'");
            }
            Class<T> objectClass = this.getObjectClass(type);
            if (objectClass == null) {
                throw new DBException("Can't load class '" + this.getImplName() + "'");
            }
            try {
                return objectClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DBException("Can't instantiate class '" + this.getImplName() + "'", e);
            }
        }

        public boolean matchesType(Class<?> clazz) {
            if (AbstractDescriptor.this.getContributorBundle().getState() != 32 && !this.forceCheck) {
                return AbstractDescriptor.getTypeInfoCache(clazz).containsKey(this.implName);
            }
            this.getObjectClass();
            return this.implClass != null && this.implClass.isAssignableFrom(clazz);
        }

        private JexlContext makeContext(final Object object, final Object context) {
            return new JexlContext(){

                public Object get(String name) {
                    return name.equals(AbstractDescriptor.VAR_OBJECT) ? object : (name.equals(AbstractDescriptor.VAR_CONTEXT) ? context : null);
                }

                public void set(String name, Object value) {
                    log.warn("Set is not implemented");
                }

                public boolean has(String name) {
                    return name.equals(AbstractDescriptor.VAR_OBJECT) && object != null || name.equals(AbstractDescriptor.VAR_CONTEXT) && context != null;
                }
            };
        }

        public String toString() {
            return this.implName;
        }
    }
}

