/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model.generic;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDialect;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerMetaModel;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class SQLServerGenericDataSource
extends GenericDataSource {
    public SQLServerGenericDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        this(monitor, container, new SQLServerMetaModel(SQLServerUtils.isDriverSqlServer(container.getDriver())));
    }

    SQLServerGenericDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, SQLServerMetaModel metaModel) throws DBException {
        super(monitor, container, (GenericMetaModel)metaModel, (SQLDialect)new SQLServerDialect());
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        HashMap<String, String> connectionsProps = new HashMap<String, String>();
        if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            connectionsProps.put(SQLServerUtils.isDriverJtds(driver) ? "APPNAME" : "ApplicationName", CommonUtils.truncateString((String)DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (String)purpose), (int)64));
        }
        return connectionsProps;
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.limit-affects-dml": {
                return true;
            }
            case "datasource.max-string-type-length": {
                return 8000;
            }
        }
        return super.getDataSourceFeature(featureId);
    }

    public DBPDataKind resolveDataKind(String typeName, int valueType) {
        block14: {
            if (valueType != 12) break block14;
            switch (typeName) {
                case "smalldatetime": 
                case "datetime2": 
                case "datetime": {
                    return DBPDataKind.DATETIME;
                }
                case "datetimeoffset": {
                    return DBPDataKind.STRING;
                }
            }
        }
        return super.resolveDataKind(typeName, valueType);
    }

    protected String getConnectionUserName(DBPConnectionConfiguration connectionInfo) {
        if (SQLServerUtils.isWindowsAuth(connectionInfo)) {
            return "";
        }
        return super.getConnectionUserName(connectionInfo);
    }

    protected String getConnectionUserPassword(DBPConnectionConfiguration connectionInfo) {
        if (SQLServerUtils.isWindowsAuth(connectionInfo)) {
            return "";
        }
        return super.getConnectionUserPassword(connectionInfo);
    }

    protected boolean isPopulateClientAppName() {
        return false;
    }
}

