/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.plan;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PostgrePlanNode
implements DBCPlanNode,
DBPPropertySource {
    public static final String ATTR_NODE_TYPE = "Node-Type";
    public static final String ATTR_RELATION_NAME = "Relation-Name";
    public static final String ATTR_ALIAS = "Alias";
    public static final String ATTR_TOTAL_COST = "Total-Cost";
    public static final String ATTR_STARTUP_COST = "Startup-Cost";
    public static final String ATTR_INDEX_NAME = "Index-Name";
    private PostgreDataSource dataSource;
    private PostgrePlanNode parent;
    private List<PostgrePlanNode> nested;
    private String nodeType;
    private String entity;
    private String cost;
    private Map<String, String> attributes = new LinkedHashMap<String, String>();

    public PostgrePlanNode(PostgreDataSource dataSource, PostgrePlanNode parent, Element element) {
        this.parent = parent;
        this.dataSource = dataSource;
        Node child = element.getFirstChild();
        while (child != null) {
            if (child instanceof Element && !"Plans".equals(child.getNodeName())) {
                this.attributes.put(child.getNodeName(), child.getTextContent());
            }
            child = child.getNextSibling();
        }
        this.nodeType = this.attributes.remove(ATTR_NODE_TYPE);
        this.entity = this.attributes.get(ATTR_RELATION_NAME);
        if (this.entity != null) {
            String alias = this.attributes.get(ATTR_ALIAS);
            if (alias != null && !alias.equals(this.entity)) {
                this.entity = String.valueOf(this.entity) + " as " + alias;
            }
        } else {
            this.entity = this.attributes.get(ATTR_INDEX_NAME);
        }
        String startCost = this.attributes.remove(ATTR_STARTUP_COST);
        String totalCost = this.attributes.remove(ATTR_TOTAL_COST);
        this.cost = String.valueOf(startCost) + " - " + totalCost;
        Element nestedPlansElement = XMLUtils.getChildElement((Element)element, (String)"Plans");
        if (nestedPlansElement != null) {
            for (Element planElement : XMLUtils.getChildElementList((Element)nestedPlansElement, (String)"Plan")) {
                if (this.nested == null) {
                    this.nested = new ArrayList<PostgrePlanNode>();
                }
                this.nested.add(new PostgrePlanNode(dataSource, null, planElement));
            }
        }
    }

    @Property(order=0, viewable=true)
    public String getNodeType() {
        return this.nodeType;
    }

    @Property(order=2, viewable=true)
    public String getEntity() {
        return this.entity;
    }

    @Property(order=3, viewable=true)
    public String getCost() {
        return this.cost;
    }

    @Property(order=21, viewable=true)
    public String getActualRows() {
        String rows = this.attributes.get("Actual-Rows");
        if (rows == null) {
            rows = this.attributes.get("Plan-Rows");
        }
        return rows;
    }

    @Property(order=22, viewable=true)
    public String getTotalTime() {
        return this.attributes.get("Actual-Total-Time");
    }

    @Property(order=23, viewable=true)
    public String getCondition() {
        String cond = this.attributes.get("Index-Cond");
        if (cond == null) {
            cond = this.attributes.get("Filter");
        }
        if (!CommonUtils.isEmpty((String)cond)) {
            cond = SQLUtils.formatSQL((SQLDataSource)this.dataSource, (String)cond);
        }
        return cond;
    }

    public DBCPlanNode getParent() {
        return this.parent;
    }

    public List<PostgrePlanNode> getNested() {
        return this.nested;
    }

    public Object getEditableValue() {
        return this;
    }

    public DBPPropertyDescriptor[] getPropertyDescriptors2() {
        DBPPropertyDescriptor[] props = new DBPPropertyDescriptor[this.attributes.size()];
        int index = 0;
        for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
            props[index++] = new PropertyDescriptor("Source", (Object)attr.getKey(), attr.getKey(), null, String.class, false, null, null, false);
        }
        return props;
    }

    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, Object id) {
        return this.attributes.get(id.toString());
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, Object id) {
    }

    public void resetPropertyValueToDefault(Object id) {
    }

    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, Object id, Object value) {
    }

    public boolean isDirty(Object id) {
        return false;
    }

    public String toString() {
        StringBuilder title = new StringBuilder();
        title.append("Type: ").append(this.nodeType);
        String joinType = this.attributes.get("Join-Type");
        if (!CommonUtils.isEmpty((String)joinType)) {
            title.append(" (").append(joinType).append(")");
        }
        title.append("; ");
        if (!CommonUtils.isEmpty((String)this.entity)) {
            title.append("Rel: ").append(this.entity).append(" ");
        }
        title.append("; Cost: ").append(this.cost);
        return title.toString();
    }
}

