'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GithubLoginView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'handleLoginClick', 'handleCancelTokenClick', 'handleSubmitTokenClick', 'handleSubmitToken', 'handleTokenChange');
    this.state = {
      loggingIn: false,
      token: ''
    };
  }

  render() {
    let subview;
    if (this.state.loggingIn) {
      subview = this.renderTokenInput();
    } else {
      subview = this.renderLogin();
    }

    return _react2.default.createElement(
      'div',
      { className: 'github-GithubLoginView' },
      subview
    );
  }

  renderLogin() {
    return _react2.default.createElement(
      'div',
      { className: 'github-GithubLoginView-Subview' },
      this.props.children,
      _react2.default.createElement(
        'button',
        { onClick: this.handleLoginClick, className: 'btn btn-primary btn-lg icon icon-octoface' },
        'Login'
      )
    );
  }

  renderTokenInput() {
    return _react2.default.createElement(
      'form',
      { className: 'github-GithubLoginView-Subview', onSubmit: this.handleSubmitToken },
      _react2.default.createElement(
        'p',
        null,
        'Step 1: Visit ',
        _react2.default.createElement(
          'a',
          { href: 'https://github.atom.io/login' },
          'github.atom.io/login'
        ),
        ' to generate an authentication token.'
      ),
      _react2.default.createElement(
        'p',
        null,
        'Step 2: Enter the token below:'
      ),
      _react2.default.createElement('input', {
        type: 'text',
        className: 'input-text native-key-bindings',
        placeholder: 'Enter your token...',
        value: this.state.token,
        onChange: this.handleTokenChange
      }),
      _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          'button',
          { type: 'button', onClick: this.handleCancelTokenClick, className: 'btn icon inline-block-tight' },
          'Cancel'
        ),
        _react2.default.createElement('input', {
          type: 'submit',
          value: 'Login',
          onClick: this.handleSubmitTokenClick, className: 'btn btn-primary icon icon-check inline-block-tight'
        })
      )
    );
  }

  handleLoginClick() {
    this.setState({ loggingIn: true });
  }

  handleCancelTokenClick(e) {
    e.preventDefault();
    this.setState({ loggingIn: false });
  }

  handleSubmitTokenClick(e) {
    e.preventDefault();
    this.handleSubmitToken();
  }

  handleSubmitToken() {
    this.props.onLogin(this.state.token);
  }

  handleTokenChange(e) {
    this.setState({ token: e.target.value });
  }
}
exports.default = GithubLoginView;
GithubLoginView.propTypes = {
  children: _propTypes2.default.node,
  onLogin: _propTypes2.default.func
};
GithubLoginView.defaultProps = {
  children: _react2.default.createElement(
    'p',
    null,
    'Log in to GitHub to access PR information and more!'
  ),
  onLogin: token => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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